/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile4
extends DirFile {
    private RandomAccessFile lockFileOpen;
    private FileChannel lockFileChannel;
    private FileLock dbLock;

    DirFile4(String string) {
        super(string);
    }

    DirFile4(String string, String string2) {
        super(string, string2);
    }

    DirFile4(DirFile dirFile, String string) {
        super(dirFile, string);
    }

    public StorageFile getParentDir() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new DirFile4(string);
    }

    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        boolean bl2 = this.exists();
        FileOutputStream fileOutputStream = new FileOutputStream(this, bl);
        if (!bl2) {
            FileUtil.limitAccessToOwner(this);
        }
        return fileOutputStream;
    }

    public synchronized int getExclusiveFileLock() throws StandardException {
        int n;
        block14: {
            boolean bl = false;
            try {
                if (this.createNewFile()) {
                    bl = true;
                } else if (this.length() > 0L) {
                    bl = true;
                }
                if (bl) {
                    int n2 = 120;
                    while (true) {
                        this.lockFileOpen = new RandomAccessFile(this, "rw");
                        this.limitAccessToOwner();
                        this.lockFileChannel = this.lockFileOpen.getChannel();
                        try {
                            this.dbLock = this.lockFileChannel.tryLock();
                            if (this.dbLock == null) {
                                this.lockFileChannel.close();
                                this.lockFileChannel = null;
                                this.lockFileOpen.close();
                                this.lockFileOpen = null;
                                n = 2;
                            } else {
                                this.lockFileOpen.writeInt(1);
                                this.lockFileChannel.force(true);
                                n = 1;
                            }
                            break block14;
                        }
                        catch (AsynchronousCloseException asynchronousCloseException) {
                            InterruptStatus.setInterrupted();
                            this.lockFileOpen.close();
                            if (n2-- > 0) continue;
                            throw asynchronousCloseException;
                        }
                        break;
                    }
                }
                n = 0;
            }
            catch (IOException iOException) {
                this.releaseExclusiveFileLock();
                n = 0;
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                try {
                    this.lockFileChannel.close();
                    this.lockFileOpen.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.lockFileChannel = null;
                this.lockFileOpen = null;
                n = 2;
            }
        }
        return n;
    }

    public synchronized void releaseExclusiveFileLock() {
        try {
            if (this.dbLock != null) {
                this.dbLock.release();
                this.dbLock = null;
            }
            if (this.lockFileChannel != null) {
                this.lockFileChannel.close();
                this.lockFileChannel = null;
            }
            if (this.lockFileOpen != null) {
                this.lockFileOpen.close();
                this.lockFileOpen = null;
            }
            super.releaseExclusiveFileLock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        return new DirRandomAccessFile(this, string);
    }
}

