/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.lake.paimon.utils;

import org.apache.paimon.data.BinaryRow;

import java.util.Objects;

/** Paimon partition and bucket identifier. */
public final class PaimonPartitionBucket {

    private final BinaryRow partition;
    private final Integer bucket;

    public PaimonPartitionBucket(BinaryRow partition, Integer bucket) {
        this.partition = partition;
        this.bucket = bucket;
    }

    public BinaryRow getPartition() {
        return partition;
    }

    public Integer getBucket() {
        return bucket;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaimonPartitionBucket that = (PaimonPartitionBucket) o;
        return Objects.equals(partition, that.partition) && Objects.equals(bucket, that.bucket);
    }

    @Override
    public int hashCode() {
        return Objects.hash(partition, bucket);
    }
}
