/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.flink.sink.shuffle;

import java.util.Random;

/**
 * A subclass of Random with a fixed seed and generation algorithm. This is useful for generating a
 * deterministic sequence of pseudorandom numbers.
 */
public class MockRandom extends Random {
    private long state;

    public MockRandom() {
        this(17);
    }

    public MockRandom(long state) {
        this.state = state;
    }

    @Override
    protected int next(int bits) {
        state = (state * 2862933555777941757L) + 3037000493L;
        return (int) (state >>> (64 - bits));
    }
}
