/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.apiserver.utils.TopicUtil;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.Setting;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.QoS;

@Path(value="/retain")
final class RetainHandler
extends TenantAwareHandler {
    private final IRetainClient retainClient;
    private final ISettingProvider settingProvider;

    RetainHandler(ISettingProvider settingProvider, IRetainClient retainClient) {
        super(settingProvider);
        this.retainClient = retainClient;
        this.settingProvider = settingProvider;
    }

    @Override
    @POST
    @Operation(summary="Retain a message to given topic")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional, caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the tenant id", schema=@Schema(implementation=String.class)), @Parameter(name="topic", in=ParameterIn.HEADER, required=true, description="the message topic", schema=@Schema(implementation=String.class)), @Parameter(name="qos", in=ParameterIn.HEADER, required=true, description="QoS of the message to be retained", schema=@Schema(implementation=Integer.class, allowableValues={"0", "1", "2"})), @Parameter(name="expiry_seconds", in=ParameterIn.HEADER, description="the message expiry seconds", schema=@Schema(implementation=Integer.class)), @Parameter(name="client_type", in=ParameterIn.HEADER, required=true, description="the caller client type", schema=@Schema(implementation=String.class)), @Parameter(name="client_meta_*", in=ParameterIn.HEADER, description="the metadata header about caller client, must be started with client_meta_")})
    @RequestBody(required=true, description="Message payload will be treated as binary", content={@Content(mediaType="application/octet-stream")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Invalid QoS or expiry seconds", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="403", description="Unaccepted Topic", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        String topic = HeaderUtils.getHeader(Headers.HEADER_TOPIC, (HttpRequest)req, true);
        int qos = Integer.parseInt(HeaderUtils.getHeader(Headers.HEADER_QOS, (HttpRequest)req, true));
        boolean retainEnabled = (Boolean)this.settingProvider.provide(Setting.RetainEnabled, tenantId);
        if (!retainEnabled) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.UNAUTHORIZED, Unpooled.EMPTY_BUFFER));
        }
        if (!TopicUtil.checkTopicFilter(topic, tenantId, this.settingProvider)) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER));
        }
        if (qos < 0 || qos > 2) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER));
        }
        int expirySeconds = Optional.ofNullable(HeaderUtils.getHeader(Headers.HEADER_EXPIRY_SECONDS, (HttpRequest)req, false)).map(Integer::parseInt).orElse(Integer.MAX_VALUE);
        String clientType = HeaderUtils.getHeader(Headers.HEADER_CLIENT_TYPE, (HttpRequest)req, true);
        Map<String, String> clientMeta = HeaderUtils.getClientMeta((HttpRequest)req);
        ClientInfo clientInfo = ClientInfo.newBuilder().setTenantId(tenantId).setType(clientType).putAllMetadata(clientMeta).build();
        return this.retainClient.retain(reqId, topic, QoS.AT_MOST_ONCE, ByteString.copyFrom((ByteBuffer)req.content().nioBuffer()), expirySeconds, clientInfo).thenApply(retainReply -> {
            switch (retainReply.getResult()) {
                case RETAINED: 
                case CLEARED: {
                    return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])retainReply.getResult().name().getBytes()));
                }
                case EXCEED_LIMIT: 
                case BACK_PRESSURE_REJECTED: {
                    return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])retainReply.getResult().name().getBytes()));
                }
            }
            return new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
        });
    }
}

