/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerGroupRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.IServerSelector;
import org.apache.bifromq.baserpc.client.loadbalancer.ITenantRouter;
import org.apache.bifromq.baserpc.client.loadbalancer.TenantRouter;

class TenantAwareServerSelector
implements IServerSelector {
    private final Map<String, Boolean> allServers;
    private final Map<String, Set<String>> serverGroupTags;
    private final Map<String, Map<String, Integer>> trafficDirective;
    private final ITenantRouter tenantRouter;

    public TenantAwareServerSelector(Map<String, Boolean> allServers, Map<String, Set<String>> serverGroupTags, Map<String, Map<String, Integer>> trafficDirective) {
        this.allServers = Maps.newHashMap(allServers);
        this.serverGroupTags = Maps.newHashMap(serverGroupTags);
        this.trafficDirective = Maps.newHashMap(trafficDirective);
        this.tenantRouter = new TenantRouter(this.allServers, this.trafficDirective, this.serverGroupTags);
    }

    @Override
    public boolean exists(String serverId) {
        return this.allServers.containsKey(serverId);
    }

    @Override
    public IServerGroupRouter get(String tenantId) {
        return this.tenantRouter.get(tenantId);
    }

    public String toString() {
        return this.allServers.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantAwareServerSelector)) {
            return false;
        }
        TenantAwareServerSelector other = (TenantAwareServerSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Boolean> this$allServers = this.allServers;
        Map<String, Boolean> other$allServers = other.allServers;
        if (this$allServers == null ? other$allServers != null : !((Object)this$allServers).equals(other$allServers)) {
            return false;
        }
        Map<String, Set<String>> this$serverGroupTags = this.serverGroupTags;
        Map<String, Set<String>> other$serverGroupTags = other.serverGroupTags;
        if (this$serverGroupTags == null ? other$serverGroupTags != null : !((Object)this$serverGroupTags).equals(other$serverGroupTags)) {
            return false;
        }
        Map<String, Map<String, Integer>> this$trafficDirective = this.trafficDirective;
        Map<String, Map<String, Integer>> other$trafficDirective = other.trafficDirective;
        return !(this$trafficDirective == null ? other$trafficDirective != null : !((Object)this$trafficDirective).equals(other$trafficDirective));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TenantAwareServerSelector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Boolean> $allServers = this.allServers;
        result = result * 59 + ($allServers == null ? 43 : ((Object)$allServers).hashCode());
        Map<String, Set<String>> $serverGroupTags = this.serverGroupTags;
        result = result * 59 + ($serverGroupTags == null ? 43 : ((Object)$serverGroupTags).hashCode());
        Map<String, Map<String, Integer>> $trafficDirective = this.trafficDirective;
        result = result * 59 + ($trafficDirective == null ? 43 : ((Object)$trafficDirective).hashCode());
        return result;
    }
}

