/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import io.grpc.MethodDescriptor;
import io.reactivex.rxjava3.core.Observable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.RPCClientBuilder;

public interface IRPCClient
extends IConnectable {
    public static RPCClientBuilder newBuilder() {
        return new RPCClientBuilder();
    }

    public Observable<Map<String, Map<String, String>>> serverList();

    default public <ReqT, RespT> CompletableFuture<RespT> invoke(String tenantId, String desiredServerId, ReqT req, MethodDescriptor<ReqT, RespT> methodDesc) {
        return this.invoke(tenantId, desiredServerId, req, Collections.emptyMap(), methodDesc);
    }

    public <ReqT, RespT> CompletableFuture<RespT> invoke(String var1, String var2, ReqT var3, Map<String, String> var4, MethodDescriptor<ReqT, RespT> var5);

    default public <ReqT, RespT> IRequestPipeline<ReqT, RespT> createRequestPipeline(String tenantId, String desiredServerId, String wchKey, Map<String, String> metadata, MethodDescriptor<ReqT, RespT> methodDesc) {
        return this.createRequestPipeline(tenantId, desiredServerId, wchKey, () -> metadata, methodDesc);
    }

    public <ReqT, RespT> IRequestPipeline<ReqT, RespT> createRequestPipeline(String var1, String var2, String var3, Supplier<Map<String, String>> var4, MethodDescriptor<ReqT, RespT> var5);

    default public <MsgT, AckT> IMessageStream<MsgT, AckT> createMessageStream(String tenantId, String desiredServerId, String wchKey, Map<String, String> metadata, MethodDescriptor<AckT, MsgT> methodDesc) {
        return this.createMessageStream(tenantId, desiredServerId, wchKey, () -> metadata, methodDesc);
    }

    public <MsgT, AckT> IMessageStream<MsgT, AckT> createMessageStream(String var1, String var2, String var3, Supplier<Map<String, String>> var4, MethodDescriptor<AckT, MsgT> var5);

    public void stop();

    public static interface IRequestPipeline<ReqT, RespT> {
        public boolean isClosed();

        public CompletableFuture<RespT> invoke(ReqT var1);

        public void close();
    }

    public static interface IMessageStream<MsgT, AckT> {
        public boolean isClosed();

        public void ack(AckT var1);

        public void onMessage(Consumer<MsgT> var1);

        public void onRetarget(Consumer<Long> var1);

        public void close();
    }
}

