/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.session;

import com.google.common.base.Ticker;
import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.bifromq.base.util.FutureTracker;
import org.apache.bifromq.dist.client.IDistClient;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.service.ILocalDistService;
import org.apache.bifromq.mqtt.service.ILocalSessionRegistry;
import org.apache.bifromq.mqtt.session.MQTTSessionAuthProvider;
import org.apache.bifromq.mqtt.session.TenantGauge;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.clientbalancer.IClientBalancer;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sysprops.props.ControlPlaneMaxBurstLatencyMillis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MQTTSessionContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTSessionContext.class);
    public final long retryTimeoutNanos = Duration.ofMillis((Long)ControlPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos();
    public final ILocalSessionRegistry localSessionRegistry;
    public final ILocalDistService localDistService;
    public final IEventCollector eventCollector;
    public final IResourceThrottler resourceThrottler;
    public final ISettingProvider settingProvider;
    public final IDistClient distClient;
    public final IInboxClient inboxClient;
    public final IRetainClient retainClient;
    public final ISessionDictClient sessionDictClient;
    public final IClientBalancer clientBalancer;
    public final IUserPropsCustomizer userPropsCustomizer;
    public final String serverId;
    private final IAuthProvider authProvider;
    private final Ticker ticker;
    private final FutureTracker futureTracker = new FutureTracker();
    private final TenantGauge tenantTransientSubNumGauge;
    private final TenantGauge tenantMemGauge;

    MQTTSessionContext(String serverId, ILocalSessionRegistry localSessionRegistry, ILocalDistService localDistService, IAuthProvider authProvider, IDistClient distClient, IInboxClient inboxClient, IRetainClient retainClient, ISessionDictClient sessionDictClient, IClientBalancer clientBalancer, IEventCollector eventCollector, IResourceThrottler resourceThrottler, ISettingProvider settingProvider, IUserPropsCustomizer userPropsCustomizer, Ticker ticker) {
        this.serverId = serverId;
        this.localSessionRegistry = localSessionRegistry;
        this.localDistService = localDistService;
        this.authProvider = authProvider;
        this.eventCollector = eventCollector;
        this.resourceThrottler = resourceThrottler;
        this.settingProvider = settingProvider;
        this.userPropsCustomizer = userPropsCustomizer;
        this.distClient = distClient;
        this.inboxClient = inboxClient;
        this.retainClient = retainClient;
        this.sessionDictClient = sessionDictClient;
        this.clientBalancer = clientBalancer;
        this.ticker = ticker == null ? Ticker.systemTicker() : ticker;
        this.tenantTransientSubNumGauge = new TenantGauge(TenantMetric.MqttTransientSubCountGauge);
        this.tenantMemGauge = new TenantGauge(TenantMetric.MqttSessionWorkingMemoryGauge);
    }

    public long nanoTime() {
        return this.ticker.read();
    }

    public IAuthProvider authProvider(ChannelHandlerContext ctx) {
        return new MQTTSessionAuthProvider(this.authProvider, ctx);
    }

    public AtomicLong getTransientSubNumGauge(String tenantId) {
        return this.tenantTransientSubNumGauge.get(tenantId);
    }

    public AtomicLong getSessionMemGauge(String tenantId) {
        return this.tenantMemGauge.get(tenantId);
    }

    public <T> CompletableFuture<T> trackBgTask(CompletableFuture<T> task) {
        return this.futureTracker.track(task);
    }

    public CompletableFuture<Void> awaitBgTasksFinish() {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        this.futureTracker.whenComplete((v, e) -> onDone.complete(null));
        return onDone;
    }

    @Generated
    public static MQTTSessionContextBuilder builder() {
        return new MQTTSessionContextBuilder();
    }

    @Generated
    public static class MQTTSessionContextBuilder {
        @Generated
        private String serverId;
        @Generated
        private ILocalSessionRegistry localSessionRegistry;
        @Generated
        private ILocalDistService localDistService;
        @Generated
        private IAuthProvider authProvider;
        @Generated
        private IDistClient distClient;
        @Generated
        private IInboxClient inboxClient;
        @Generated
        private IRetainClient retainClient;
        @Generated
        private ISessionDictClient sessionDictClient;
        @Generated
        private IClientBalancer clientBalancer;
        @Generated
        private IEventCollector eventCollector;
        @Generated
        private IResourceThrottler resourceThrottler;
        @Generated
        private ISettingProvider settingProvider;
        @Generated
        private IUserPropsCustomizer userPropsCustomizer;
        @Generated
        private Ticker ticker;

        @Generated
        MQTTSessionContextBuilder() {
        }

        @Generated
        public MQTTSessionContextBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder localSessionRegistry(ILocalSessionRegistry localSessionRegistry) {
            this.localSessionRegistry = localSessionRegistry;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder localDistService(ILocalDistService localDistService) {
            this.localDistService = localDistService;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder authProvider(IAuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder distClient(IDistClient distClient) {
            this.distClient = distClient;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder inboxClient(IInboxClient inboxClient) {
            this.inboxClient = inboxClient;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder retainClient(IRetainClient retainClient) {
            this.retainClient = retainClient;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder sessionDictClient(ISessionDictClient sessionDictClient) {
            this.sessionDictClient = sessionDictClient;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder clientBalancer(IClientBalancer clientBalancer) {
            this.clientBalancer = clientBalancer;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder eventCollector(IEventCollector eventCollector) {
            this.eventCollector = eventCollector;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder resourceThrottler(IResourceThrottler resourceThrottler) {
            this.resourceThrottler = resourceThrottler;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder settingProvider(ISettingProvider settingProvider) {
            this.settingProvider = settingProvider;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder userPropsCustomizer(IUserPropsCustomizer userPropsCustomizer) {
            this.userPropsCustomizer = userPropsCustomizer;
            return this;
        }

        @Generated
        public MQTTSessionContextBuilder ticker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        @Generated
        public MQTTSessionContext build() {
            return new MQTTSessionContext(this.serverId, this.localSessionRegistry, this.localDistService, this.authProvider, this.distClient, this.inboxClient, this.retainClient, this.sessionDictClient, this.clientBalancer, this.eventCollector, this.resourceThrottler, this.settingProvider, this.userPropsCustomizer, this.ticker);
        }

        @Generated
        public String toString() {
            return "MQTTSessionContext.MQTTSessionContextBuilder(serverId=" + this.serverId + ", localSessionRegistry=" + String.valueOf(this.localSessionRegistry) + ", localDistService=" + String.valueOf(this.localDistService) + ", authProvider=" + String.valueOf(this.authProvider) + ", distClient=" + String.valueOf(this.distClient) + ", inboxClient=" + String.valueOf(this.inboxClient) + ", retainClient=" + String.valueOf(this.retainClient) + ", sessionDictClient=" + String.valueOf(this.sessionDictClient) + ", clientBalancer=" + String.valueOf(this.clientBalancer) + ", eventCollector=" + String.valueOf(this.eventCollector) + ", resourceThrottler=" + String.valueOf(this.resourceThrottler) + ", settingProvider=" + String.valueOf(this.settingProvider) + ", userPropsCustomizer=" + String.valueOf(this.userPropsCustomizer) + ", ticker=" + String.valueOf(this.ticker) + ")";
        }
    }
}

