/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.PriorityQueue;

public class SenderTopicAliasManager {
    private static final String CACHE_KEY = "ALIAS";
    private final int maxAlias;
    private final LoadingCache<String, AliasManagerState> cache;

    public SenderTopicAliasManager(int maxAlias, Duration expiryTime) {
        this.maxAlias = maxAlias;
        this.cache = Caffeine.newBuilder().expireAfterAccess(expiryTime).build(key -> new AliasManagerState(maxAlias));
    }

    public Optional<AliasCreationResult> tryAlias(String topic) {
        if (this.maxAlias == 0) {
            return Optional.empty();
        }
        AliasManagerState state = (AliasManagerState)this.cache.get((Object)CACHE_KEY);
        return state.tryAlias(topic);
    }

    private static class AliasManagerState {
        int nextAlias = 1;
        HashMap<String, AliasEntry> topicToAlias = new HashMap();
        PriorityQueue<AliasEntry> usageQueue = new PriorityQueue<AliasEntry>(Comparator.comparingInt(AliasEntry::usageCount));
        final int maxAlias;

        AliasManagerState(int maxAlias) {
            this.maxAlias = maxAlias;
        }

        public Optional<AliasCreationResult> tryAlias(String topic) {
            boolean isFirstTime = false;
            AliasEntry entry = this.topicToAlias.get(topic);
            if (entry == null) {
                isFirstTime = true;
                if (this.topicToAlias.size() >= this.maxAlias) {
                    entry = this.recycleLeastUsedAlias();
                    entry = new AliasEntry(topic, entry.alias, 1);
                } else {
                    if (this.nextAlias > this.maxAlias) {
                        this.nextAlias = 1;
                    }
                    entry = new AliasEntry(topic, this.nextAlias++, 1);
                }
                this.topicToAlias.put(topic, entry);
                this.usageQueue.offer(entry);
            } else {
                this.usageQueue.remove(entry);
                entry = new AliasEntry(entry.topic(), entry.alias(), entry.usageCount() + 1);
                this.topicToAlias.put(topic, entry);
                this.usageQueue.offer(entry);
            }
            return Optional.of(new AliasCreationResult(entry.alias(), isFirstTime));
        }

        private AliasEntry recycleLeastUsedAlias() {
            AliasEntry leastUsed = this.usageQueue.poll();
            if (leastUsed != null) {
                this.topicToAlias.remove(leastUsed.topic());
            }
            return leastUsed;
        }

        public record AliasEntry(String topic, int alias, int usageCount) {
        }
    }

    public record AliasCreationResult(int alias, boolean isFirstTime) {
    }
}

