/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.Struct;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.localengine.StructUtil;
import org.rocksdb.StatsLevel;

public final class RocksDBDefaultConfigs {
    public static final String DB_ROOT_DIR = "dbRootDir";
    public static final String DB_CHECKPOINT_ROOT_DIR = "dbCheckpointRootDir";
    public static final String ENABLE_STATS = "enableStats";
    public static final String STATS_LEVEL = "statsLevel";
    public static final String MANUAL_COMPACTION = "manualCompaction";
    public static final String COMPACT_MIN_TOMBSTONE_KEYS = "compactMinTombstoneKeys";
    public static final String COMPACT_MIN_TOMBSTONE_RANGES = "compactMinTombstoneRanges";
    public static final String COMPACT_TOMBSTONE_RATIO = "compactTombstoneRatio";
    public static final String BLOCK_CACHE_SIZE = "blockCacheSize";
    public static final String WRITE_BUFFER_SIZE = "writeBufferSize";
    public static final String MAX_WRITE_BUFFER_NUMBER = "maxWriteBufferNumber";
    public static final String MIN_WRITE_BUFFER_NUMBER_TO_MERGE = "minWriteBufferNumberToMerge";
    public static final String MIN_BLOB_SIZE = "minBlobSize";
    public static final String INCREASE_PARALLELISM = "increaseParallelism";
    public static final String MAX_BACKGROUND_JOBS = "maxBackgroundJobs";
    public static final String LEVEL0_FILE_NUM_COMPACTION_TRIGGER = "level0FileNumCompactionTrigger";
    public static final String LEVEL0_SLOWDOWN_WRITES_TRIGGER = "level0SlowdownWritesTrigger";
    public static final String LEVEL0_STOP_WRITES_TRIGGER = "level0StopWritesTrigger";
    public static final String MAX_BYTES_FOR_LEVEL_BASE = "maxBytesForLevelBase";
    public static final String TARGET_FILE_SIZE_BASE = "targetFileSizeBase";
    public static final String ASYNC_WAL_FLUSH = "asyncWALFlush";
    public static final String FSYNC_WAL = "fsyncWAL";
    public static final Struct CP;
    public static final Struct WAL;

    static {
        Struct.Builder configBuilder = Struct.newBuilder();
        configBuilder.putFields(DB_ROOT_DIR, StructUtil.toValue((Object)""));
        configBuilder.putFields(ENABLE_STATS, StructUtil.toValue((Object)false));
        configBuilder.putFields(STATS_LEVEL, StructUtil.toValue((Object)StatsLevel.EXCEPT_DETAILED_TIMERS.name()));
        configBuilder.putFields(MANUAL_COMPACTION, StructUtil.toValue((Object)true));
        configBuilder.putFields(COMPACT_MIN_TOMBSTONE_KEYS, StructUtil.toValue((Object)200000));
        configBuilder.putFields(COMPACT_MIN_TOMBSTONE_RANGES, StructUtil.toValue((Object)100000));
        configBuilder.putFields(COMPACT_TOMBSTONE_RATIO, StructUtil.toValue((Object)0.3));
        configBuilder.putFields(BLOCK_CACHE_SIZE, StructUtil.toValue((Object)0x2000000L));
        configBuilder.putFields(WRITE_BUFFER_SIZE, StructUtil.toValue((Object)0x8000000L));
        configBuilder.putFields(MAX_WRITE_BUFFER_NUMBER, StructUtil.toValue((Object)6));
        configBuilder.putFields(MIN_WRITE_BUFFER_NUMBER_TO_MERGE, StructUtil.toValue((Object)2));
        configBuilder.putFields(MIN_BLOB_SIZE, StructUtil.toValue((Object)2048L));
        configBuilder.putFields(INCREASE_PARALLELISM, StructUtil.toValue((Object)Math.max(EnvProvider.INSTANCE.availableProcessors() / 4, 2)));
        configBuilder.putFields(MAX_BACKGROUND_JOBS, StructUtil.toValue((Object)Math.max(EnvProvider.INSTANCE.availableProcessors() / 4, 2)));
        configBuilder.putFields(LEVEL0_FILE_NUM_COMPACTION_TRIGGER, StructUtil.toValue((Object)8));
        configBuilder.putFields(LEVEL0_SLOWDOWN_WRITES_TRIGGER, StructUtil.toValue((Object)20));
        configBuilder.putFields(LEVEL0_STOP_WRITES_TRIGGER, StructUtil.toValue((Object)24));
        configBuilder.putFields(MAX_BYTES_FOR_LEVEL_BASE, StructUtil.toValue((Object)0x80000000L));
        configBuilder.putFields(TARGET_FILE_SIZE_BASE, StructUtil.toValue((Object)0x10000000L));
        Struct sharedConfig = configBuilder.build();
        CP = sharedConfig.toBuilder().putFields(DB_CHECKPOINT_ROOT_DIR, StructUtil.toValue((Object)"")).build();
        WAL = sharedConfig.toBuilder().putFields(ASYNC_WAL_FLUSH, StructUtil.toValue((Object)true)).putFields(FSYNC_WAL, StructUtil.toValue((Object)false)).build();
    }
}

