/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.subbroker;

import com.google.common.base.Preconditions;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.plugin.subbroker.CheckReply;
import org.apache.bifromq.plugin.subbroker.CheckRequest;
import org.apache.bifromq.plugin.subbroker.DeliveryReply;
import org.apache.bifromq.plugin.subbroker.DeliveryRequest;
import org.apache.bifromq.plugin.subbroker.IDeliverer;
import org.apache.bifromq.plugin.subbroker.ISubBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MonitoredSubBroker
implements ISubBroker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoredSubBroker.class);
    private final AtomicBoolean hasStopped = new AtomicBoolean();
    private final ISubBroker delegate;
    private final Timer checkSubCallTimer;
    private final Timer deliverCallTimer;

    MonitoredSubBroker(ISubBroker delegate) {
        this.delegate = delegate;
        this.checkSubCallTimer = Timer.builder((String)"ib.call.time").tag("type", delegate.getClass().getName()).tag("call", "checkSub").register((MeterRegistry)Metrics.globalRegistry);
        this.deliverCallTimer = Timer.builder((String)"ib.call.time").tag("type", delegate.getClass().getName()).tag("call", "deliver").register((MeterRegistry)Metrics.globalRegistry);
    }

    public int id() {
        return this.delegate.id();
    }

    public CompletableFuture<CheckReply> check(CheckRequest request) {
        try {
            Timer.Sample start = Timer.start();
            return this.delegate.check(request).whenComplete((v, e) -> start.stop(this.checkSubCallTimer));
        }
        catch (Throwable e2) {
            return CompletableFuture.failedFuture(e2);
        }
    }

    public IDeliverer open(String delivererKey) {
        Preconditions.checkState((!this.hasStopped.get() ? 1 : 0) != 0);
        return new MonitoredDeliverer(delivererKey);
    }

    public void close() {
        if (this.hasStopped.compareAndSet(false, true)) {
            this.delegate.close();
            Metrics.globalRegistry.remove((Meter)this.checkSubCallTimer);
            Metrics.globalRegistry.remove((Meter)this.deliverCallTimer);
        }
    }

    private class MonitoredDeliverer
    implements IDeliverer {
        private final IDeliverer deliverer;

        MonitoredDeliverer(String delivererKey) {
            this.deliverer = MonitoredSubBroker.this.delegate.open(delivererKey);
        }

        public CompletableFuture<DeliveryReply> deliver(DeliveryRequest request) {
            try {
                Timer.Sample start = Timer.start();
                return this.deliverer.deliver(request).whenComplete((v, e) -> start.stop(MonitoredSubBroker.this.deliverCallTimer));
            }
            catch (Throwable e2) {
                return CompletableFuture.failedFuture(e2);
            }
        }

        public void close() {
            this.deliverer.close();
        }
    }
}

