/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorState;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateReplicating;
import org.apache.bifromq.basekv.raft.PeerLogReplicatorStateSnapshotSyncing;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.slf4j.Logger;

class PeerLogReplicatorStateProbing
extends PeerLogReplicatorState {
    private int heartbeatElapsedTick = 0;
    private boolean probeSent = false;

    PeerLogReplicatorStateProbing(String peerId, RaftConfig config, IRaftStateStore stateStorage, Logger logger) {
        this(peerId, config, stateStorage, stateStorage.latestSnapshot().getIndex(), stateStorage.lastIndex() + 1L, logger);
    }

    PeerLogReplicatorStateProbing(String peerId, RaftConfig config, IRaftStateStore stateStorage, long matchIndex, long nextIndex, Logger logger) {
        super(peerId, config, stateStorage, matchIndex, nextIndex, logger);
    }

    @Override
    public RaftNodeSyncState state() {
        return RaftNodeSyncState.Probing;
    }

    @Override
    public PeerLogReplicatorState tick() {
        if (this.heartbeatElapsedTick >= this.config.getHeartbeatTimeoutTick()) {
            this.heartbeatElapsedTick = 0;
            this.probeSent = false;
        }
        ++this.heartbeatElapsedTick;
        return this;
    }

    @Override
    public long catchupRate() {
        return 0L;
    }

    @Override
    public boolean pauseReplicating() {
        return this.probeSent;
    }

    @Override
    public boolean needHeartbeat() {
        return !this.probeSent;
    }

    @Override
    public PeerLogReplicatorState backoff(long peerRejectedIndex, long peerLastIndex) {
        if (this.stateStorage.entryAt(this.nextIndex).isEmpty() || this.nextIndex == peerRejectedIndex + 1L) {
            this.nextIndex = Math.max(1L, Math.min(peerRejectedIndex, peerLastIndex + 1L));
            this.matchIndex = Math.min(this.matchIndex, this.nextIndex - 1L);
            if (this.stateStorage.entryAt(this.nextIndex).isEmpty()) {
                this.logger.debug("Entry[index:{}] not available for peer[{}] from tracker[matchIndex:{},nextIndex:{},state:{}], start syncing with snapshot", new Object[]{this.nextIndex, this.peerId, this.matchIndex, this.nextIndex, this.state()});
                return new PeerLogReplicatorStateSnapshotSyncing(this.peerId, this.config, this.stateStorage, this.logger);
            }
            this.probeSent = false;
        }
        return this;
    }

    @Override
    public PeerLogReplicatorState confirmMatch(long peerLastIndex) {
        if (this.matchIndex <= peerLastIndex) {
            this.logger.debug("Peer[{}] accepted entry[{}] from tracker[matchIndex:{},nextIndex:{},state:{}], start replicating", new Object[]{this.peerId, peerLastIndex, this.matchIndex, this.nextIndex, this.state()});
            return new PeerLogReplicatorStateReplicating(this.peerId, this.config, this.stateStorage, peerLastIndex, peerLastIndex + 1L, this.logger);
        }
        return this;
    }

    @Override
    public PeerLogReplicatorState replicateTo(long endIndex) {
        assert (endIndex + 1L >= this.nextIndex);
        this.probeSent = true;
        return this;
    }
}

