/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;

public class MovingAverage {
    private final long freshness;
    private final Observation[] observations;
    private final AtomicReference<Stat> lastStat = new AtomicReference<Stat>(new Stat(0L, 0L, 0L, 0L));
    private long total;
    private int head;
    private int tail;

    public MovingAverage(int precision, Duration freshness) {
        assert (precision > 0) : "Precision must be positive";
        this.observations = new Observation[precision + 1];
        for (int i = 0; i < this.observations.length; ++i) {
            this.observations[i] = new Observation();
        }
        this.freshness = freshness.toNanos();
    }

    public synchronized void observe(long read) {
        long lastObserveTs;
        this.observations[this.head].ts = lastObserveTs = System.nanoTime();
        this.observations[this.head].read = read;
        this.total += read;
        this.head = (this.head + 1) % this.observations.length;
        if (this.head == this.tail) {
            this.total -= this.observations[this.head].read;
            this.tail = (this.tail + 1) % this.observations.length;
        }
        while (lastObserveTs - this.observations[this.tail].ts > this.freshness) {
            this.total -= this.observations[this.tail].read;
            this.tail = (this.tail + 1) % this.observations.length;
        }
        this.updateStat(read, lastObserveTs);
    }

    public long max() {
        long now = System.nanoTime();
        Stat stat = this.lastStat.get();
        if (now - stat.lastObserveTs > this.freshness) {
            return 0L;
        }
        return stat.max;
    }

    public long estimate() {
        long now = System.nanoTime();
        Stat stat = this.lastStat.get();
        if (now - stat.lastObserveTs > this.freshness) {
            return 0L;
        }
        return stat.avg;
    }

    private long calcAvg() {
        int count = (this.head - this.tail + this.observations.length) % this.observations.length;
        long avg = 0L;
        if (count > 0) {
            avg = this.total / (long)count;
        }
        return avg;
    }

    private void updateStat(long read, long lastObserveTs) {
        Stat lastStat = this.lastStat.get();
        lastStat = lastObserveTs - lastStat.lastMaxObserveTs > this.freshness || read >= lastStat.max ? new Stat(this.calcAvg(), read, lastObserveTs, lastObserveTs) : new Stat(this.calcAvg(), lastStat.max, lastObserveTs, lastStat.lastMaxObserveTs);
        this.lastStat.set(lastStat);
    }

    private record Stat(long avg, long max, long lastObserveTs, long lastMaxObserveTs) {
    }

    private static class Observation {
        private long ts;
        private long read;

        private Observation() {
        }
    }
}

