/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.spi;

import com.google.protobuf.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizer;
import org.apache.bifromq.mqtt.spi.IUserPropsCustomizerFactory;
import org.apache.bifromq.mqtt.spi.UserPropsCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPropsCustomizerFactory
implements IUserPropsCustomizerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserPropsCustomizerFactory.class);
    private final List<IUserPropsCustomizerFactory> factories = new ArrayList<IUserPropsCustomizerFactory>();

    public UserPropsCustomizerFactory(Map<String, Struct> configMap) {
        Map loadedFactories = BaseHookLoader.load(IUserPropsCustomizerFactory.class);
        for (String factoryName : loadedFactories.keySet()) {
            IUserPropsCustomizerFactory fac = (IUserPropsCustomizerFactory)loadedFactories.get(factoryName);
            Struct config = configMap.getOrDefault(factoryName, Struct.getDefaultInstance());
            try {
                fac.init(config);
                log.info("UserPropsCustomizerFactory {} Loaded", (Object)factoryName);
                this.factories.add(fac);
            }
            catch (Exception e) {
                log.error("Failed to initialize UserPropsCustomizerFactory {}", (Object)factoryName, (Object)e);
            }
        }
    }

    public IUserPropsCustomizer create() {
        ArrayList<IUserPropsCustomizer> customizers = new ArrayList<IUserPropsCustomizer>();
        for (IUserPropsCustomizerFactory factory : this.factories) {
            try {
                IUserPropsCustomizer customizer = factory.create();
                customizers.add(customizer);
            }
            catch (Exception e) {
                log.error("Failed to create UserPropsCustomizer from factory {}", (Object)factory.getClass().getName(), (Object)e);
            }
        }
        return new UserPropsCustomizer(customizers);
    }

    public void close() {
        for (IUserPropsCustomizerFactory factory : this.factories) {
            try {
                factory.close();
            }
            catch (Exception e) {
                log.error("Failed to close UserPropsCustomizerFactory {}", (Object)factory.getClass().getName(), (Object)e);
            }
        }
        this.factories.clear();
        log.info("All UserPropsCustomizerFactories closed");
    }
}

