/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.api;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;

public final class CRDTURI {
    private static final Pattern NAME;
    private static final Pattern URI;

    public static boolean isValidURI(String uri) {
        return URI.matcher(uri).matches();
    }

    public static String toURI(CausalCRDTType type, String name) {
        Preconditions.checkArgument((boolean)NAME.matcher(name).matches(), (Object)("Invalid name " + name));
        return type.name() + ":" + name;
    }

    public static CausalCRDTType parseType(String uri) {
        CRDTURI.checkURI(uri);
        return CausalCRDTType.valueOf(uri.split(":")[0]);
    }

    public static String parseName(String uri) {
        CRDTURI.checkURI(uri);
        return uri.substring(uri.indexOf(":") + 1);
    }

    public static void checkURI(String uri) {
        Preconditions.checkArgument((boolean)CRDTURI.isValidURI(uri), (Object)"Invalid CRDT replica uri format");
    }

    static {
        String namePattern = "[\\w-:.@]+";
        StringBuilder uriPattern = new StringBuilder("^(");
        for (CausalCRDTType type : CausalCRDTType.values()) {
            uriPattern.append(type.name());
            uriPattern.append("|");
        }
        uriPattern.deleteCharAt(uriPattern.length() - 1);
        uriPattern.append("):").append(namePattern);
        NAME = Pattern.compile(namePattern);
        URI = Pattern.compile(uriPattern.toString());
    }
}

