/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.IClientChannel;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.ManagedBiDiStream;
import org.apache.bifromq.baserpc.client.exception.RequestAbortException;
import org.apache.bifromq.baserpc.client.exception.RequestRejectedException;
import org.apache.bifromq.baserpc.client.exception.RequestThrottledException;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.baserpc.client.exception.ServiceUnavailableException;
import org.apache.bifromq.baserpc.metrics.IRPCMeter;
import org.apache.bifromq.baserpc.metrics.RPCMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedRequestPipeline<ReqT, RespT>
extends ManagedBiDiStream<ReqT, RespT>
implements IRPCClient.IRequestPipeline<ReqT, RespT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedRequestPipeline.class);
    private final ConcurrentLinkedDeque<RequestTask> preflightTaskQueue = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<RequestTask> inflightTaskQueue = new ConcurrentLinkedDeque();
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean sending = new AtomicBoolean(false);
    private final IRPCMeter.IRPCMethodMeter meter;
    private final MethodDescriptor<ReqT, RespT> methodDescriptor;
    private boolean isRetargeting = false;

    ManagedRequestPipeline(String tenantId, String wchKey, String targetServerId, Supplier<Map<String, String>> metadataSupplier, IClientChannel channelHolder, CallOptions callOptions, MethodDescriptor<ReqT, RespT> methodDescriptor, BluePrint bluePrint, IRPCMeter.IRPCMethodMeter meter) {
        super(tenantId, wchKey, targetServerId, bluePrint.semantic(methodDescriptor.getFullMethodName()), metadataSupplier, channelHolder.channel(), callOptions, bluePrint.methodDesc(methodDescriptor.getFullMethodName()));
        this.meter = meter;
        this.methodDescriptor = methodDescriptor;
        this.start(channelHolder.serverSelectorObservable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean prepareRetarget() {
        ManagedRequestPipeline managedRequestPipeline = this;
        synchronized (managedRequestPipeline) {
            this.isRetargeting = true;
            return this.inflightTaskQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean canStartRetarget() {
        ManagedRequestPipeline managedRequestPipeline = this;
        synchronized (managedRequestPipeline) {
            return this.isRetargeting && this.inflightTaskQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onStreamCreated() {
        ManagedRequestPipeline managedRequestPipeline = this;
        synchronized (managedRequestPipeline) {
            this.isRetargeting = false;
        }
        this.meter.recordCount(RPCMetric.ReqPipelineCreateCount);
    }

    @Override
    void onStreamReady() {
        this.sendUntilStreamNotReadyOrNoTask();
    }

    @Override
    void onStreamError(Throwable e) {
        this.meter.recordCount(RPCMetric.ReqPipelineErrorCount);
        this.cancelInflightTasks(e);
    }

    @Override
    void onNoServerAvailable() {
        this.cancelPreflightTasks(new ServerNotFoundException("No Server Available"));
    }

    @Override
    void onServiceUnavailable() {
        this.cancelPreflightTasks(new ServiceUnavailableException("Service unavailable"));
    }

    @Override
    void onReceive(RespT out) {
        RequestTask inflightTask = this.inflightTaskQueue.poll();
        if (inflightTask == null) {
            log.error("ReqPipeline@{} illegal state: No matching request found for the response: method={}, resp={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), out});
            return;
        }
        inflightTask.finish(out);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            super.close();
            this.meter.recordCount(RPCMetric.ReqPipelineCompleteCount);
            this.cancelPreflightTasks(new RequestAbortException("Pipeline has closed"));
        }
    }

    @Override
    public CompletableFuture<RespT> invoke(ReqT req) {
        if (this.isClosed.get()) {
            return CompletableFuture.failedFuture(new RequestRejectedException("Pipeline has closed"));
        }
        RequestTask newRequest = new RequestTask(req);
        switch (this.state()) {
            case Init: 
            case Normal: 
            case PendingRetarget: 
            case Retargeting: 
            case StreamDisconnect: {
                int currentCount = this.taskCount.get();
                log.trace("ReqPipeline@{} enqueue request: method={}, queueSize={}, req={}", new Object[]{this.hashCode(), this.methodDescriptor.getBareMethodName(), currentCount, req});
                this.preflightTaskQueue.offer(newRequest);
                if (this.isClosed.get()) {
                    newRequest.finish(new RequestRejectedException("Pipeline has closed"));
                    return newRequest.future;
                }
                this.sendUntilStreamNotReadyOrNoTask();
                this.meter.recordCount(RPCMetric.PipelineReqAcceptCount);
                this.meter.recordSummary(RPCMetric.ReqPipelineDepth, currentCount);
                break;
            }
            case NoServerAvailable: {
                if (this.balanceMode == BluePrint.BalanceMode.DDBalanced) {
                    newRequest.finish(new ServerNotFoundException("No server available"));
                    break;
                }
                newRequest.finish(new ServiceUnavailableException("Service unavailable"));
            }
        }
        return newRequest.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUntilStreamNotReadyOrNoTask() {
        if (this.sending.compareAndSet(false, true)) {
            ManagedRequestPipeline managedRequestPipeline = this;
            synchronized (managedRequestPipeline) {
                Optional<RequestTask> requestTask;
                while (this.isReady() && !this.isRetargeting && (requestTask = this.prepareForFly()).isPresent()) {
                    this.meter.timer(RPCMetric.PipelineReqQueueTime).record(System.nanoTime() - requestTask.get().enqueueTS, TimeUnit.NANOSECONDS);
                    this.send(requestTask.get().request);
                    this.meter.recordCount(RPCMetric.PipelineReqSendCount);
                }
            }
            this.sending.set(false);
            managedRequestPipeline = this;
            synchronized (managedRequestPipeline) {
                if (this.isReady() && !this.preflightTaskQueue.isEmpty() && !this.isRetargeting) {
                    this.sendUntilStreamNotReadyOrNoTask();
                }
            }
        }
    }

    private Optional<RequestTask> prepareForFly() {
        RequestTask requestTask = this.preflightTaskQueue.poll();
        if (requestTask != null) {
            this.inflightTaskQueue.offer(requestTask);
        }
        return Optional.ofNullable(requestTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInflightTasks(Throwable e) {
        ManagedRequestPipeline managedRequestPipeline = this;
        synchronized (managedRequestPipeline) {
            RequestTask pendingTask;
            if (this.inflightTaskQueue.isEmpty() && this.preflightTaskQueue.isEmpty()) {
                return;
            }
            int i = 0;
            while ((pendingTask = this.inflightTaskQueue.poll()) != null) {
                pendingTask.finish(e);
                ++i;
            }
            log.debug("ReqPipeline@{} abort {} in-flight requests: method={}", new Object[]{this.hashCode(), i, this.methodDescriptor.getBareMethodName()});
        }
    }

    private void cancelPreflightTasks(Throwable e) {
        RequestTask pendingTask;
        int i = 0;
        while ((pendingTask = this.preflightTaskQueue.poll()) != null) {
            pendingTask.finish(e);
            ++i;
        }
        log.debug("ReqPipeline@{} abort {} pre-flight requests: method={}", new Object[]{this.hashCode(), i, this.methodDescriptor.getBareMethodName()});
    }

    private class RequestTask {
        final Long enqueueTS = System.nanoTime();
        final ReqT request;
        final CompletableFuture<RespT> future;

        RequestTask(ReqT request) {
            this.request = request;
            ManagedRequestPipeline.this.taskCount.incrementAndGet();
            this.future = new CompletableFuture();
            this.future.whenComplete((v, e) -> ManagedRequestPipeline.this.taskCount.decrementAndGet());
        }

        public void finish(Throwable throwable) {
            if (this.future.completeExceptionally(throwable)) {
                log.trace("ReqPipeline@{} finished request with error: method={}, req={}, error={}", new Object[]{ManagedRequestPipeline.this.hashCode(), ManagedRequestPipeline.this.methodDescriptor.getBareMethodName(), this.request, throwable.getMessage()});
            }
            if (throwable instanceof RequestRejectedException || throwable instanceof RequestThrottledException) {
                ManagedRequestPipeline.this.meter.recordCount(RPCMetric.PipelineReqDropCount);
            } else if (throwable instanceof RequestAbortException) {
                ManagedRequestPipeline.this.meter.recordCount(RPCMetric.PipelineReqAbortCount);
            }
        }

        public void finish(RespT resp) {
            long finishTime = System.nanoTime() - this.enqueueTS;
            ManagedRequestPipeline.this.meter.timer(RPCMetric.PipelineReqLatency).record(finishTime, TimeUnit.NANOSECONDS);
            if (this.future.complete(resp)) {
                log.trace("ReqPipeline@{} finished request: method={}, req={}, resp={}, flights={}", new Object[]{ManagedRequestPipeline.this.hashCode(), ManagedRequestPipeline.this.methodDescriptor.getBareMethodName(), this.request, resp, ManagedRequestPipeline.this.taskCount.get()});
            }
            ManagedRequestPipeline.this.meter.recordCount(RPCMetric.PipelineReqCompleteCount);
        }
    }
}

