/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.common;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kyuubi.jdbc.hive.common.Date;
import org.apache.kyuubi.jdbc.hive.common.Timestamp;
import org.apache.kyuubi.jdbc.hive.common.TimestampTZ;

public class TimestampTZUtil {
    private static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(0, 0);
    private static final Pattern SINGLE_DIGIT_PATTERN = Pattern.compile("[\\+-]\\d:\\d\\d");
    static final DateTimeFormatter FORMATTER;

    public static TimestampTZ parse(String s) {
        return TimestampTZUtil.parse(s, null);
    }

    public static TimestampTZ parse(String s, ZoneId defaultTimeZone) {
        ZonedDateTime zonedDateTime;
        s = TimestampTZUtil.handleSingleDigitHourOffset(s);
        try {
            zonedDateTime = ZonedDateTime.parse(s, FORMATTER);
        }
        catch (DateTimeParseException e) {
            ZoneId zoneId;
            LocalTime localTime;
            TemporalAccessor accessor = FORMATTER.parse(s);
            LocalDate localDate = LocalDate.from(accessor);
            try {
                localTime = LocalTime.from(accessor);
            }
            catch (DateTimeException e1) {
                localTime = DEFAULT_LOCAL_TIME;
            }
            try {
                zoneId = ZoneId.from(accessor);
            }
            catch (DateTimeException e2) {
                if (defaultTimeZone == null) {
                    throw new DateTimeException("Time Zone not available");
                }
                zoneId = defaultTimeZone;
            }
            zonedDateTime = ZonedDateTime.of(localDate, localTime, zoneId);
        }
        if (defaultTimeZone == null) {
            return new TimestampTZ(zonedDateTime);
        }
        return new TimestampTZ(zonedDateTime.withZoneSameInstant(defaultTimeZone));
    }

    private static String handleSingleDigitHourOffset(String s) {
        Matcher matcher = SINGLE_DIGIT_PATTERN.matcher(s);
        if (matcher.find()) {
            int index = matcher.start() + 1;
            s = s.substring(0, index) + "0" + s.substring(index, s.length());
        }
        return s;
    }

    public static TimestampTZ convert(Date date, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(date.toString(), defaultTimeZone);
    }

    public static TimestampTZ convert(Timestamp ts, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(ts.toString(), defaultTimeZone);
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        builder.optionalStart().appendLiteral(" ").append(DateTimeFormatter.ofPattern("HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd();
        builder.optionalStart().appendLiteral(" ").optionalEnd();
        builder.optionalStart().appendZoneText(TextStyle.NARROW).optionalEnd();
        FORMATTER = builder.toFormatter();
    }
}

