/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayloadManager;

public class NettyConnectionWriterImpl
implements NettyConnectionWriter {
    private final NettyPayloadManager nettyPayloadManager;
    private final NettyConnectionId connectionId;
    private final BufferAvailabilityListener availabilityListener;

    public NettyConnectionWriterImpl(NettyPayloadManager nettyPayloadManager, BufferAvailabilityListener availabilityListener) {
        this.nettyPayloadManager = nettyPayloadManager;
        this.connectionId = NettyConnectionId.newId();
        this.availabilityListener = availabilityListener;
    }

    @Override
    public NettyConnectionId getNettyConnectionId() {
        return this.connectionId;
    }

    @Override
    public void notifyAvailable() {
        this.availabilityListener.notifyDataAvailable();
    }

    @Override
    public int numQueuedPayloads() {
        return this.nettyPayloadManager.getSize();
    }

    @Override
    public int numQueuedBufferPayloads() {
        return this.nettyPayloadManager.getBacklog();
    }

    @Override
    public void writeNettyPayload(NettyPayload nettyPayload) {
        this.nettyPayloadManager.add(nettyPayload);
    }

    @Override
    public void close(@Nullable Throwable error) {
        NettyPayload nettyPayload;
        while ((nettyPayload = this.nettyPayloadManager.poll()) != null) {
            nettyPayload.getBuffer().ifPresent(Buffer::recycleBuffer);
        }
        if (error != null) {
            this.writeNettyPayload(NettyPayload.newError(error));
        }
    }
}

