/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateCheckpointWriter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcher;
import org.apache.flink.runtime.checkpoint.channel.CheckpointAbortRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointStartRequest;
import org.apache.flink.runtime.checkpoint.channel.SubtaskID;
import org.apache.flink.runtime.checkpoint.channel.SubtaskRegisterRequest;
import org.apache.flink.runtime.checkpoint.channel.SubtaskReleaseRequest;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChannelStateWriteRequestDispatcherImpl
implements ChannelStateWriteRequestDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelStateWriteRequestDispatcherImpl.class);
    private final CheckpointStorage checkpointStorage;
    private final JobID jobID;
    private final ChannelStateSerializer serializer;
    private final Set<SubtaskID> registeredSubtasks;
    private CheckpointStorageWorkerView streamFactoryResolver;
    private long ongoingCheckpointId;
    private long maxAbortedCheckpointId;
    private SubtaskID abortedSubtaskID;
    private Throwable abortedCause;
    private ChannelStateCheckpointWriter writer;

    ChannelStateWriteRequestDispatcherImpl(CheckpointStorage checkpointStorage, JobID jobID, ChannelStateSerializer serializer) {
        this.checkpointStorage = (CheckpointStorage)Preconditions.checkNotNull((Object)checkpointStorage);
        this.jobID = jobID;
        this.serializer = (ChannelStateSerializer)Preconditions.checkNotNull((Object)serializer);
        this.registeredSubtasks = new HashSet<SubtaskID>();
        this.ongoingCheckpointId = -1L;
        this.maxAbortedCheckpointId = -1L;
    }

    @Override
    public void dispatch(ChannelStateWriteRequest request) throws Exception {
        LOG.trace("process {}", (Object)request);
        try {
            this.dispatchInternal(request);
        }
        catch (Exception e) {
            try {
                request.cancel(e);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private void dispatchInternal(ChannelStateWriteRequest request) throws Exception {
        if (request instanceof SubtaskRegisterRequest) {
            SubtaskRegisterRequest req = (SubtaskRegisterRequest)request;
            SubtaskID subtaskID = SubtaskID.of(req.getJobVertexID(), req.getSubtaskIndex());
            this.registeredSubtasks.add(subtaskID);
            return;
        }
        if (request instanceof SubtaskReleaseRequest) {
            SubtaskReleaseRequest req = (SubtaskReleaseRequest)request;
            SubtaskID subtaskID = SubtaskID.of(req.getJobVertexID(), req.getSubtaskIndex());
            this.registeredSubtasks.remove(subtaskID);
            if (this.writer == null) {
                return;
            }
            this.writer.releaseSubtask(subtaskID);
            return;
        }
        if (this.isAbortedCheckpoint(request.getCheckpointId())) {
            this.handleAbortedRequest(request);
        } else if (request instanceof CheckpointStartRequest) {
            this.handleCheckpointStartRequest(request);
        } else if (request instanceof CheckpointInProgressRequest) {
            this.handleCheckpointInProgressRequest((CheckpointInProgressRequest)request);
        } else if (request instanceof CheckpointAbortRequest) {
            this.handleCheckpointAbortRequest(request);
        } else {
            throw new IllegalArgumentException("unknown request type: " + request);
        }
    }

    private void handleAbortedRequest(ChannelStateWriteRequest request) throws Exception {
        if (request.getCheckpointId() != this.maxAbortedCheckpointId) {
            request.cancel(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED));
            return;
        }
        SubtaskID requestSubtask = SubtaskID.of(request.getJobVertexID(), request.getSubtaskIndex());
        if (requestSubtask.equals(this.abortedSubtaskID)) {
            request.cancel(this.abortedCause);
        } else {
            request.cancel(new CheckpointException(CheckpointFailureReason.CHANNEL_STATE_SHARED_STREAM_EXCEPTION, this.abortedCause));
        }
    }

    private void handleCheckpointStartRequest(ChannelStateWriteRequest request) throws Exception {
        Preconditions.checkState((request.getCheckpointId() >= this.ongoingCheckpointId ? 1 : 0) != 0, (Object)String.format("Checkpoint must be incremented, ongoingCheckpointId is %s, but the request is %s.", this.ongoingCheckpointId, request));
        if (request.getCheckpointId() > this.ongoingCheckpointId) {
            this.failAndClearWriter(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED));
        }
        CheckpointStartRequest req = (CheckpointStartRequest)request;
        if (this.writer == null) {
            this.writer = this.buildWriter(req);
            this.ongoingCheckpointId = request.getCheckpointId();
        }
        this.writer.registerSubtaskResult(SubtaskID.of(req.getJobVertexID(), req.getSubtaskIndex()), req.getTargetResult());
    }

    private void handleCheckpointInProgressRequest(CheckpointInProgressRequest req) throws Exception {
        Preconditions.checkArgument((this.ongoingCheckpointId == req.getCheckpointId() && this.writer != null ? 1 : 0) != 0, (Object)("writer not found while processing request: " + req));
        req.execute(this.writer);
    }

    private void handleCheckpointAbortRequest(ChannelStateWriteRequest request) {
        CheckpointAbortRequest req = (CheckpointAbortRequest)request;
        if (request.getCheckpointId() > this.maxAbortedCheckpointId) {
            this.maxAbortedCheckpointId = req.getCheckpointId();
            this.abortedCause = req.getThrowable();
            this.abortedSubtaskID = SubtaskID.of(req.getJobVertexID(), req.getSubtaskIndex());
        }
        if (req.getCheckpointId() == this.ongoingCheckpointId) {
            this.failAndClearWriter(req.getJobVertexID(), req.getSubtaskIndex(), req.getThrowable());
        } else if (request.getCheckpointId() > this.ongoingCheckpointId) {
            this.failAndClearWriter(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED));
        }
    }

    private boolean isAbortedCheckpoint(long checkpointId) {
        return checkpointId < this.ongoingCheckpointId || checkpointId <= this.maxAbortedCheckpointId;
    }

    private void failAndClearWriter(Throwable e) {
        if (this.writer == null) {
            return;
        }
        this.writer.fail(e);
        this.writer = null;
    }

    private void failAndClearWriter(JobVertexID jobVertexID, int subtaskIndex, Throwable throwable) {
        if (this.writer == null) {
            return;
        }
        this.writer.fail(jobVertexID, subtaskIndex, throwable);
        this.writer = null;
    }

    private ChannelStateCheckpointWriter buildWriter(CheckpointStartRequest request) throws Exception {
        return new ChannelStateCheckpointWriter(this.registeredSubtasks, request.getCheckpointId(), this.getStreamFactoryResolver().resolveCheckpointStorageLocation(request.getCheckpointId(), request.getLocationReference()), this.serializer, () -> {
            Preconditions.checkState((request.getCheckpointId() == this.ongoingCheckpointId ? 1 : 0) != 0, (String)"The ongoingCheckpointId[%s] was changed when clear writer of checkpoint[%s], it might be a bug.", (Object[])new Object[]{this.ongoingCheckpointId, request.getCheckpointId()});
            this.writer = null;
        });
    }

    @Override
    public void fail(Throwable cause) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.fail(cause);
        }
        catch (Exception ex) {
            LOG.warn("unable to fail write channel state writer", cause);
        }
        this.writer = null;
    }

    CheckpointStorageWorkerView getStreamFactoryResolver() throws IOException {
        if (this.streamFactoryResolver == null) {
            this.streamFactoryResolver = this.checkpointStorage.createCheckpointStorage(this.jobID);
        }
        return this.streamFactoryResolver;
    }
}

