/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava31.com.google.common.io.Files;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

public final class FileUtils {
    private static final Object DELETE_LOCK = new Object();
    private static final char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int RANDOM_FILE_NAME_LENGTH = 12;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 4096;
    private static final String JAR_FILE_EXTENSION = "jar";
    public static final String CLASS_FILE_EXTENSION = "class";
    public static final String PACKAGE_SEPARATOR = ".";

    public static void writeCompletely(WritableByteChannel channel, ByteBuffer src) throws IOException {
        while (src.hasRemaining()) {
            channel.write(src);
        }
    }

    public static java.nio.file.Path[] listDirectory(java.nio.file.Path directory) throws IOException {
        try (Stream<java.nio.file.Path> stream = java.nio.file.Files.list(directory);){
            java.nio.file.Path[] pathArray = (java.nio.file.Path[])stream.toArray(java.nio.file.Path[]::new);
            return pathArray;
        }
    }

    public static String getRandomFilename(String prefix) {
        Random rnd = new Random();
        StringBuilder stringBuilder = new StringBuilder(prefix);
        for (int i = 0; i < 12; ++i) {
            stringBuilder.append(ALPHABET[rnd.nextInt(ALPHABET.length)]);
        }
        return stringBuilder.toString();
    }

    public static String readFile(File file, String charsetName) throws IOException {
        byte[] bytes = FileUtils.readAllBytes(file.toPath());
        return new String(bytes, charsetName);
    }

    public static String readFileUtf8(File file) throws IOException {
        return FileUtils.readFile(file, "UTF-8");
    }

    public static void writeFile(File file, String contents, String encoding) throws IOException {
        byte[] bytes = contents.getBytes(encoding);
        java.nio.file.Files.write(file.toPath(), bytes, StandardOpenOption.WRITE);
    }

    public static void writeFileUtf8(File file, String contents) throws IOException {
        FileUtils.writeFile(file, contents, "UTF-8");
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(java.nio.file.Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] read(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, Math.min(capacity - nread, 4096))) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 4096);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public static void deleteFileOrDirectory(File file) throws IOException {
        Preconditions.checkNotNull(file, "file");
        FileUtils.guardIfNotThreadSafe(FileUtils::deleteFileOrDirectoryInternal, file);
    }

    public static void deleteDirectory(File directory) throws IOException {
        Preconditions.checkNotNull(directory, "directory");
        FileUtils.guardIfNotThreadSafe(FileUtils::deleteDirectoryInternal, directory);
    }

    public static void deleteDirectoryQuietly(File directory) {
        if (directory == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory(directory);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        Preconditions.checkNotNull(directory, "directory");
        FileUtils.guardIfNotThreadSafe(FileUtils::cleanDirectoryInternal, directory);
    }

    private static void deleteFileOrDirectoryInternal(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryInternal(file);
        } else {
            java.nio.file.Files.deleteIfExists(file.toPath());
        }
    }

    private static void deleteDirectoryInternal(File directory) throws IOException {
        if (directory.isDirectory()) {
            try {
                FileUtils.cleanDirectoryInternal(directory);
            }
            catch (FileNotFoundException ignored) {
                return;
            }
            java.nio.file.Files.deleteIfExists(directory.toPath());
        } else if (directory.exists()) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private static void cleanDirectoryInternal(File directory) throws IOException {
        if (java.nio.file.Files.isSymbolicLink(directory.toPath())) {
            return;
        }
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files == null) {
                if (directory.exists()) {
                    throw new IOException("Failed to list contents of " + directory);
                }
                throw new FileNotFoundException(directory.toString());
            }
            for (File file : files) {
                if (file == null) continue;
                FileUtils.deleteFileOrDirectory(file);
            }
        } else {
            if (directory.exists()) {
                throw new IOException(directory + " is not a directory but a regular file");
            }
            throw new FileNotFoundException(directory.toString());
        }
    }

    private static void guardIfNotThreadSafe(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        if (OperatingSystem.isWindows()) {
            FileUtils.guardIfWindows(toRun, file);
            return;
        }
        if (OperatingSystem.isMac()) {
            FileUtils.guardIfMac(toRun, file);
            return;
        }
        toRun.accept(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guardIfWindows(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        Object object = DELETE_LOCK;
        synchronized (object) {
            for (int attempt = 1; attempt <= 10; ++attempt) {
                try {
                    toRun.accept(file);
                    break;
                }
                catch (AccessDeniedException accessDeniedException) {
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException("operation interrupted");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void guardIfMac(ThrowingConsumer<File, IOException> toRun, File file) throws IOException {
        Object object = DELETE_LOCK;
        synchronized (object) {
            toRun.accept(file);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("operation interrupted");
            }
        }
    }

    public static void copy(Path sourcePath, Path targetPath, boolean executable) throws IOException {
        FileSystem sFS = FileSystem.getUnguardedFileSystem(sourcePath.toUri());
        FileSystem tFS = FileSystem.getUnguardedFileSystem(targetPath.toUri());
        if (!tFS.exists(targetPath)) {
            if (sFS.getFileStatus(sourcePath).isDir()) {
                FileUtils.internalCopyDirectory(sourcePath, targetPath, executable, sFS, tFS);
            } else {
                FileUtils.internalCopyFile(sourcePath, targetPath, executable, sFS, tFS);
            }
        }
    }

    private static void internalCopyDirectory(Path sourcePath, Path targetPath, boolean executable, FileSystem sFS, FileSystem tFS) throws IOException {
        FileStatus[] contents;
        tFS.mkdirs(targetPath);
        for (FileStatus content : contents = sFS.listStatus(sourcePath)) {
            String distPath = content.getPath().toString();
            if (content.isDir() && distPath.endsWith("/")) {
                distPath = distPath.substring(0, distPath.length() - 1);
            }
            String localPath = targetPath + distPath.substring(distPath.lastIndexOf("/"));
            FileUtils.copy(content.getPath(), new Path(localPath), executable);
        }
    }

    private static void internalCopyFile(Path sourcePath, Path targetPath, boolean executable, FileSystem sFS, FileSystem tFS) throws IOException {
        try (FSDataOutputStream lfsOutput = tFS.create(targetPath, FileSystem.WriteMode.NO_OVERWRITE);
             FSDataInputStream fsInput = sFS.open(sourcePath);){
            IOUtils.copyBytes(fsInput, lfsOutput);
            new File(targetPath.toString()).setExecutable(executable);
        }
    }

    public static Path compressDirectory(Path directory, Path target) throws IOException {
        FileSystem sourceFs = directory.getFileSystem();
        FileSystem targetFs = target.getFileSystem();
        Path absolutePath = FileUtils.absolutizePath(directory);
        Path absoluteTargetPath = FileUtils.absolutizePath(target);
        try (ZipOutputStream out = new ZipOutputStream(targetFs.create(absoluteTargetPath, FileSystem.WriteMode.NO_OVERWRITE));){
            FileUtils.addToZip(absolutePath, sourceFs, absolutePath.getParent(), out);
        }
        return target;
    }

    private static void addToZip(Path fileOrDirectory, FileSystem fs, Path rootDir, ZipOutputStream out) throws IOException {
        String relativePath = fileOrDirectory.getPath().replace(rootDir.getPath() + '/', "");
        if (fs.getFileStatus(fileOrDirectory).isDir()) {
            out.putNextEntry(new ZipEntry(relativePath + '/'));
            for (FileStatus containedFile : fs.listStatus(fileOrDirectory)) {
                FileUtils.addToZip(containedFile.getPath(), fs, rootDir, out);
            }
        } else {
            ZipEntry entry = new ZipEntry(relativePath);
            out.putNextEntry(entry);
            try (FSDataInputStream in = fs.open(fileOrDirectory);){
                IOUtils.copyBytes(in, out, false);
            }
            out.closeEntry();
        }
    }

    public static Path expandDirectory(Path file, Path targetDirectory) throws IOException {
        FileSystem sourceFs = file.getFileSystem();
        FileSystem targetFs = targetDirectory.getFileSystem();
        Path rootDir = null;
        try (ZipInputStream zis = new ZipInputStream(sourceFs.open(file));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path relativePath = new Path(entry.getName());
                if (rootDir == null) {
                    rootDir = relativePath;
                }
                Path newFile = new Path(targetDirectory, relativePath);
                if (entry.isDirectory()) {
                    targetFs.mkdirs(newFile);
                } else {
                    try (FSDataOutputStream fileStream = targetFs.create(newFile, FileSystem.WriteMode.NO_OVERWRITE);){
                        IOUtils.copyBytes(zis, fileStream, false);
                    }
                }
                zis.closeEntry();
            }
        }
        return new Path(targetDirectory, rootDir);
    }

    public static Collection<java.nio.file.Path> listFilesInDirectory(java.nio.file.Path directory, Predicate<java.nio.file.Path> fileFilter) throws IOException {
        Preconditions.checkNotNull(directory, "directory");
        Preconditions.checkNotNull(fileFilter, "fileFilter");
        if (!java.nio.file.Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The directory %s dose not exist.", directory));
        }
        if (!java.nio.file.Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The %s is not a directory.", directory));
        }
        FilterFileVisitor filterFileVisitor = new FilterFileVisitor(fileFilter);
        java.nio.file.Files.walkFileTree(directory, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, filterFileVisitor);
        return filterFileVisitor.getFiles();
    }

    public static Path absolutizePath(Path pathToAbsolutize) throws IOException {
        if (!pathToAbsolutize.isAbsolute()) {
            FileSystem fs = pathToAbsolutize.getFileSystem();
            return new Path(fs.getWorkingDirectory(), pathToAbsolutize);
        }
        return pathToAbsolutize;
    }

    public static java.nio.file.Path relativizePath(java.nio.file.Path basePath, java.nio.file.Path pathToRelativize) {
        if (pathToRelativize.isAbsolute()) {
            return basePath.relativize(pathToRelativize);
        }
        return pathToRelativize;
    }

    public static java.nio.file.Path getCurrentWorkingDirectory() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static boolean isJarFile(java.nio.file.Path file) {
        return JAR_FILE_EXTENSION.equals(Files.getFileExtension((String)file.toString()));
    }

    public static String stripFileExtension(String fileName) {
        String extension = Files.getFileExtension((String)fileName);
        if (!extension.isEmpty()) {
            return fileName.substring(0, fileName.lastIndexOf(extension) - 1);
        }
        return fileName;
    }

    public static java.nio.file.Path getTargetPathIfContainsSymbolicPath(java.nio.file.Path path) throws IOException {
        java.nio.file.Path targetPath = path;
        java.nio.file.Path suffixPath = Paths.get("", new String[0]);
        while (path != null && path.getFileName() != null) {
            if (java.nio.file.Files.isSymbolicLink(path)) {
                java.nio.file.Path linkedPath = path.toRealPath(new LinkOption[0]);
                targetPath = Paths.get(linkedPath.toString(), suffixPath.toString());
                break;
            }
            suffixPath = Paths.get(path.getFileName().toString(), suffixPath.toString());
            path = path.getParent();
        }
        return targetPath;
    }

    public static URL toURL(java.nio.file.Path path) throws MalformedURLException {
        String scheme = path.toUri().getScheme();
        return new URL(scheme, null, -1, path.toString());
    }

    private FileUtils() {
    }

    private static final class FilterFileVisitor
    extends SimpleFileVisitor<java.nio.file.Path> {
        private final Predicate<java.nio.file.Path> fileFilter;
        private final List<java.nio.file.Path> files;

        FilterFileVisitor(Predicate<java.nio.file.Path> fileFilter) {
            this.fileFilter = Preconditions.checkNotNull(fileFilter);
            this.files = new ArrayList<java.nio.file.Path>();
        }

        @Override
        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
            FileVisitResult fileVisitResult = super.visitFile(file, attrs);
            if (this.fileFilter.test(file)) {
                this.files.add(file);
            }
            return fileVisitResult;
        }

        Collection<java.nio.file.Path> getFiles() {
            return Collections.unmodifiableCollection(this.files);
        }
    }
}

