/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.source.BatchDataReader;
import org.apache.iceberg.spark.source.SparkInputPartition;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.vectorized.ColumnarBatch;

class SparkColumnarReaderFactory
implements PartitionReaderFactory {
    private final int batchSize;

    SparkColumnarReaderFactory(int batchSize) {
        Preconditions.checkArgument((batchSize > 1 ? 1 : 0) != 0, (Object)"Batch size must be > 1");
        this.batchSize = batchSize;
    }

    public PartitionReader<InternalRow> createReader(InputPartition inputPartition) {
        throw new UnsupportedOperationException("Row-based reads are not supported");
    }

    public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition inputPartition) {
        Preconditions.checkArgument((boolean)(inputPartition instanceof SparkInputPartition), (String)"Unknown input partition type: %s", (Object)inputPartition.getClass().getName());
        SparkInputPartition partition = (SparkInputPartition)inputPartition;
        if (partition.allTasksOfType(FileScanTask.class)) {
            return new BatchDataReader(partition, this.batchSize);
        }
        throw new UnsupportedOperationException("Unsupported task group for columnar reads: " + partition.taskGroup());
    }

    public boolean supportColumnarReads(InputPartition inputPartition) {
        return true;
    }
}

