/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.PathIdentifier;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCachedTableCatalog;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsCatalogOptions;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class IcebergSource
implements DataSourceRegister,
SupportsCatalogOptions {
    private static final String DEFAULT_CATALOG_NAME = "default_iceberg";
    private static final String DEFAULT_CACHE_CATALOG_NAME = "default_cache_iceberg";
    private static final String DEFAULT_CATALOG = "spark.sql.catalog.default_iceberg";
    private static final String DEFAULT_CACHE_CATALOG = "spark.sql.catalog.default_cache_iceberg";
    private static final String AT_TIMESTAMP = "at_timestamp_";
    private static final String SNAPSHOT_ID = "snapshot_id_";
    private static final String BRANCH_PREFIX = "branch_";
    private static final String TAG_PREFIX = "tag_";
    private static final String[] EMPTY_NAMESPACE = new String[0];
    private static final SparkTableCache TABLE_CACHE = SparkTableCache.get();

    public String shortName() {
        return "iceberg";
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return null;
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap options) {
        return this.getTable(null, null, (Map<String, String>)options).partitioning();
    }

    public boolean supportsExternalMetadata() {
        return true;
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> options) {
        Spark3Util.CatalogAndIdentifier catalogIdentifier = this.catalogAndIdentifier(new CaseInsensitiveStringMap(options));
        CatalogPlugin catalog = catalogIdentifier.catalog();
        Identifier ident = catalogIdentifier.identifier();
        try {
            if (catalog instanceof TableCatalog) {
                return ((TableCatalog)catalog).loadTable(ident);
            }
        }
        catch (NoSuchTableException e) {
            throw new org.apache.iceberg.exceptions.NoSuchTableException((Throwable)e, "Cannot find table for %s.", new Object[]{ident});
        }
        throw new org.apache.iceberg.exceptions.NoSuchTableException("Cannot find table for %s.", new Object[]{ident});
    }

    private Spark3Util.CatalogAndIdentifier catalogAndIdentifier(CaseInsensitiveStringMap options) {
        Preconditions.checkArgument((boolean)options.containsKey((Object)"path"), (Object)"Cannot open table: path is not set");
        SparkSession spark = SparkSession.active();
        IcebergSource.setupDefaultSparkCatalogs(spark);
        String path = options.get((Object)"path");
        Long snapshotId = IcebergSource.propertyAsLong(options, "snapshot-id");
        Long asOfTimestamp = IcebergSource.propertyAsLong(options, "as-of-timestamp");
        String branch = options.get((Object)"branch");
        String tag = options.get((Object)"tag");
        Preconditions.checkArgument((Stream.of(snapshotId, asOfTimestamp, branch, tag).filter(Objects::nonNull).count() <= 1L ? 1 : 0) != 0, (String)"Can specify only one of snapshot-id (%s), as-of-timestamp (%s), branch (%s), tag (%s)", (Object)snapshotId, (Object)asOfTimestamp, (Object)branch, (Object)tag);
        String selector = null;
        if (snapshotId != null) {
            selector = SNAPSHOT_ID + snapshotId;
        }
        if (asOfTimestamp != null) {
            selector = AT_TIMESTAMP + asOfTimestamp;
        }
        if (branch != null) {
            selector = BRANCH_PREFIX + branch;
        }
        if (tag != null) {
            selector = TAG_PREFIX + tag;
        }
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        if (TABLE_CACHE.contains(path)) {
            return new Spark3Util.CatalogAndIdentifier(catalogManager.catalog(DEFAULT_CACHE_CATALOG_NAME), Identifier.of((String[])EMPTY_NAMESPACE, (String)this.pathWithSelector(path, selector)));
        }
        if (path.contains("/")) {
            return new Spark3Util.CatalogAndIdentifier(catalogManager.catalog(DEFAULT_CATALOG_NAME), new PathIdentifier(this.pathWithSelector(path, selector)));
        }
        Spark3Util.CatalogAndIdentifier catalogAndIdentifier = Spark3Util.catalogAndIdentifier("path or identifier", spark, path);
        Identifier ident = this.identifierWithSelector(catalogAndIdentifier.identifier(), selector);
        if (catalogAndIdentifier.catalog().name().equals("spark_catalog") && !(catalogAndIdentifier.catalog() instanceof SparkSessionCatalog)) {
            return new Spark3Util.CatalogAndIdentifier(catalogManager.catalog(DEFAULT_CATALOG_NAME), ident);
        }
        return new Spark3Util.CatalogAndIdentifier(catalogAndIdentifier.catalog(), ident);
    }

    private String pathWithSelector(String path, String selector) {
        return selector == null ? path : path + "#" + selector;
    }

    private Identifier identifierWithSelector(Identifier ident, String selector) {
        if (selector == null) {
            return ident;
        }
        String[] namespace = ident.namespace();
        String[] ns = Arrays.copyOf(namespace, namespace.length + 1);
        ns[namespace.length] = ident.name();
        return Identifier.of((String[])ns, (String)selector);
    }

    public Identifier extractIdentifier(CaseInsensitiveStringMap options) {
        return this.catalogAndIdentifier(options).identifier();
    }

    public String extractCatalog(CaseInsensitiveStringMap options) {
        return this.catalogAndIdentifier(options).catalog().name();
    }

    public Optional<String> extractTimeTravelVersion(CaseInsensitiveStringMap options) {
        return Optional.ofNullable(PropertyUtil.propertyAsString((Map)options, (String)"versionAsOf", null));
    }

    public Optional<String> extractTimeTravelTimestamp(CaseInsensitiveStringMap options) {
        return Optional.ofNullable(PropertyUtil.propertyAsString((Map)options, (String)"timestampAsOf", null));
    }

    private static Long propertyAsLong(CaseInsensitiveStringMap options, String property) {
        String value = options.get((Object)property);
        if (value != null) {
            return Long.parseLong(value);
        }
        return null;
    }

    private static void setupDefaultSparkCatalogs(SparkSession spark) {
        if (!spark.conf().contains(DEFAULT_CATALOG)) {
            ImmutableMap config = ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)"default", (Object)"cache-enabled", (Object)"false");
            spark.conf().set(DEFAULT_CATALOG, SparkCatalog.class.getName());
            config.forEach((key, value) -> spark.conf().set("spark.sql.catalog.default_iceberg." + key, value));
        }
        if (!spark.conf().contains(DEFAULT_CACHE_CATALOG)) {
            spark.conf().set(DEFAULT_CACHE_CATALOG, SparkCachedTableCatalog.class.getName());
        }
    }
}

