/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Table;
import org.apache.iceberg.actions.RewriteManifests;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.actions.RewriteManifestsSparkAction;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class RewriteManifestsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("use_caching", DataTypes.BooleanType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("rewritten_manifests_count", DataTypes.IntegerType, false, Metadata.empty()), new StructField("added_manifests_count", DataTypes.IntegerType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RewriteManifestsProcedure>(){

            @Override
            protected RewriteManifestsProcedure doBuild() {
                return new RewriteManifestsProcedure(this.tableCatalog());
            }
        };
    }

    private RewriteManifestsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        Boolean useCaching = args.isNullAt(1) ? null : Boolean.valueOf(args.getBoolean(1));
        return this.modifyIcebergTable(tableIdent, table -> {
            RewriteManifestsSparkAction action = this.actions().rewriteManifests((Table)table);
            if (useCaching != null) {
                action.option("use-caching", useCaching.toString());
            }
            RewriteManifests.Result result = action.execute();
            return this.toOutputRows(result);
        });
    }

    private InternalRow[] toOutputRows(RewriteManifests.Result result) {
        int rewrittenManifestsCount = Iterables.size((Iterable)result.rewrittenManifests());
        int addedManifestsCount = Iterables.size((Iterable)result.addedManifests());
        InternalRow row = this.newInternalRow(rewrittenManifestsCount, addedManifestsCount);
        return new InternalRow[]{row};
    }

    @Override
    public String description() {
        return "RewriteManifestsProcedure";
    }
}

