/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayRepeat$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(element, count) - Returns the array containing element count times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       [\"123\",\"123\"]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015)\b\u0001\"\u0011w\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003w\u0001A\u0011BA\u001f\u0011\u001d\tI\u0006\u0001C)\u00037B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u00055\u0004!%A\u0005\u0002\u0005=\u0004\"CAC\u0001E\u0005I\u0011AA8\u0011%\t9\tAA\u0001\n\u0003\nI\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0001\u0002\u001c\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[C\u0011\"a/\u0001\u0003\u0003%\t!!0\t\u0013\u0005\u0005\u0007!!A\u0005B\u0005\rw!CAtC\u0005\u0005\t\u0012AAu\r!\u0001\u0013%!A\t\u0002\u0005-\bBB$\u001b\t\u0003\tI\u0010C\u0005\u0002|j\t\t\u0011\"\u0012\u0002~\"I\u0011q \u000e\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0005\u000fQ\u0012\u0011!CA\u0005\u0013A\u0011Ba\u0006\u001b\u0003\u0003%IA!\u0007\u0003\u0017\u0005\u0013(/Y=SKB,\u0017\r\u001e\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M)\u0001aL\u001a7yA\u0011\u0001'M\u0007\u0002C%\u0011!'\t\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\r\u001b\n\u0005U\n#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001c>\u0013\tq\u0004H\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A!\u0011\u0005A\u0012\u0015BA\"\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rI%j\u0013\t\u0003a\u0001AQaP\u0003A\u0002\u0005CQ!R\u0003A\u0002\u0005\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011+J\u0001\u0006if\u0004Xm]\u0005\u0003'B\u0013\u0011\"\u0011:sCf$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001W!\r9vL\u0019\b\u00031vs!!\u0017/\u000e\u0003iS!aW\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0014B\u000109\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_qA\u0011qjY\u0005\u0003IB\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016,\u0012a\u001a\t\u0003o!L!!\u001b\u001d\u0003\u000f\t{w\u000e\\3b]\u0006!QM^1m)\taw\u000e\u0005\u00028[&\u0011a\u000e\u000f\u0002\u0004\u0003:L\bb\u00029\n!\u0003\u0005\r!]\u0001\u0006S:\u0004X\u000f\u001e\t\u0003eNl\u0011aI\u0005\u0003i\u000e\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003]\u0004\"\u0001\u001f?\u000f\u0005eT\bCA-9\u0013\tY\b(\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>9\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0004\u0005=\u0011\u0011\u0004\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0011\u0002\u000f\r|G-Z4f]&!\u0011QBA\u0004\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\t\u0017\u0001\u0007\u00111C\u0001\u0004GRD\b\u0003BA\u0003\u0003+IA!a\u0006\u0002\b\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u000e\u0017\u0001\u0007\u00111A\u0001\u0003KZ\faC\\;mY\u0016cW-\\3oiN\u0004&o\u001c;fGRLwN\u001c\u000b\bo\u0006\u0005\u00121EA\u0014\u0011\u001d\tY\u0002\u0004a\u0001\u0003\u0007Aa!!\n\r\u0001\u00049\u0018a\u0003:jO\"$\u0018j\u001d(vY2Da!!\u000b\r\u0001\u00049\u0018!C2pe\u0016dunZ5d\u0003i9WM\\\"pI\u00164uN\u001d(v[\n,'o\u00144FY\u0016lWM\u001c;t)\u0019\ty#!\u000e\u00028A)q'!\rxo&\u0019\u00111\u0007\u001d\u0003\rQ+\b\u000f\\33\u0011\u001d\t\t\"\u0004a\u0001\u0003'Aa!!\u000f\u000e\u0001\u00049\u0018!B2pk:$\u0018!E4f]\u000e{G-\u001a$pe\u0016cW-\\3oiRiq/a\u0010\u0002B\u0005-\u0013qJA)\u0003+Bq!!\u0005\u000f\u0001\u0004\t\u0019\u0002C\u0004\u0002D9\u0001\r!!\u0012\u0002\u0017\u0015dW-\\3oiRK\b/\u001a\t\u0004\u001f\u0006\u001d\u0013bAA%!\nAA)\u0019;b)f\u0004X\r\u0003\u0004\u0002N9\u0001\ra^\u0001\bK2,W.\u001a8u\u0011\u0019\tID\u0004a\u0001o\"1\u00111\u000b\bA\u0002]\f!\u0002\\3gi&\u001bh*\u001e7m\u0011\u0019\t9F\u0004a\u0001o\u0006i\u0011M\u001d:bs\u0012\u000bG/\u0019(b[\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000b%\u000bi&!\u0019\t\r\u0005}s\u00021\u0001B\u0003\u001dqWm\u001e'fMRDa!a\u0019\u0010\u0001\u0004\t\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006\u0013\u0006%\u00141\u000e\u0005\b\u007fA\u0001\n\u00111\u0001B\u0011\u001d)\u0005\u0003%AA\u0002\u0005\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002r)\u001a\u0011)a\u001d,\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a 9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\u000bIHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003mC:<'BAAK\u0003\u0011Q\u0017M^1\n\u0007u\fy)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001eB\u0019q'a(\n\u0007\u0005\u0005\u0006HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002m\u0003OC\u0011\"!+\u0016\u0003\u0003\u0005\r!!(\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000bE\u0003\u00022\u0006]F.\u0004\u0002\u00024*\u0019\u0011Q\u0017\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aZA`\u0011!\tIkFA\u0001\u0002\u0004a\u0017AB3rk\u0006d7\u000fF\u0002h\u0003\u000bD\u0001\"!+\u0019\u0003\u0003\u0005\r\u0001\u001c\u0015\u0014\u0001\u0005%\u0017qZAi\u0003+\f9.a7\u0002^\u0006\u0005\u00181\u001d\t\u0004a\u0005-\u0017bAAgC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAj\u0003){f)\u0016(D?\"*G.Z7f]Rd\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u0019:sCf\u00043m\u001c8uC&t\u0017N\\4!K2,W.\u001a8uA\r|WO\u001c;!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!7\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n$g\r\u0012-EE\u00124GI/\u000bA\u0001\nQa\u001a:pkB\f#!a8\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003K\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V\r]3biB\u0011\u0001GG\n\u00055\u00055H\bE\u0004\u0002p\u0006U\u0018)Q%\u000e\u0005\u0005E(bAAzq\u00059!/\u001e8uS6,\u0017\u0002BA|\u0003c\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tI/\u0001\u0005u_N#(/\u001b8h)\t\tY)A\u0003baBd\u0017\u0010F\u0003J\u0005\u0007\u0011)\u0001C\u0003@;\u0001\u0007\u0011\tC\u0003F;\u0001\u0007\u0011)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t-!1\u0003\t\u0006o\t5!\u0011C\u0005\u0004\u0005\u001fA$AB(qi&|g\u000eE\u00038\u0003c\t\u0015\t\u0003\u0005\u0003\u0016y\t\t\u00111\u0001J\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001cA!\u0011Q\u0012B\u000f\u0013\u0011\u0011y\"a$\u0003\r=\u0013'.Z2u\u0001")
public class ArrayRepeat
extends BinaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRepeat arrayRepeat) {
        return ArrayRepeat$.MODULE$.unapply(arrayRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRepeat> tupled() {
        return ArrayRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRepeat>> curried() {
        return ArrayRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public ArrayType dataType() {
        return new ArrayType(this.left().dataType(), this.left().nullable());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public boolean nullable() {
        return this.right().nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object count = this.right().eval(input);
        if (count == null) {
            genericArrayData = null;
        } else {
            if (BoxesRunTime.unboxToInt((Object)count) > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(count);
            }
            Object element = this.left().eval(input);
            genericArrayData = new GenericArrayData((Object[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)count), (Function0 & Serializable & scala.Serializable)() -> element, ClassTag$.MODULE$.Any()));
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "array_repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        ExprValue element = leftGen.value();
        ExprValue count = rightGen.value();
        DataType et = this.dataType().elementType();
        String coreLogic = this.genCodeForElement(ctx, et, ExprValue$.MODULE$.exprValueToString(element), ExprValue$.MODULE$.exprValueToString(count), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), ExprValue$.MODULE$.exprValueToString(ev.value()));
        String resultCode = this.nullElementsProtection(ev, ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), coreLogic);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " =\n         |  ", ";\n         |", "\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private String nullElementsProtection(ExprCode ev, String rightIsNull, String coreLogic) {
        return this.nullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n         |if (").append(rightIsNull).append(") {\n         |  ").append(ev.isNull()).append(" = true;\n         |} else {\n         |  ").append(coreLogic).append("\n         |}\n       ").toString())).stripMargin() : coreLogic;
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String count) {
        String numElements = ctx.freshName("numElements");
        String numElementsCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |int ").append(numElements).append(" = 0;\n         |if (").append(count).append(" > 0) {\n         |  ").append(numElements).append(" = ").append(count).append(";\n         |}\n       ").toString())).stripMargin();
        return new Tuple2((Object)numElements, (Object)numElementsCode);
    }

    private String genCodeForElement(CodegenContext ctx, DataType elementType, String element, String count, String leftIsNull, String arrayDataName) {
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, count);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemName = (String)tuple2._1();
        String numElemCode = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemName, (Object)numElemCode);
        Tuple2 tuple23 = tuple22;
        String numElemName2 = (String)tuple23._1();
        String numElemCode2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, elementType, numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.setArrayElement(tempArrayDataName, elementType, k, element, CodeGenerator$.MODULE$.setArrayElement$default$5());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(244).append("\n       |").append(numElemCode2).append("\n       |").append(allocation).append("\n       |if (!").append(leftIsNull).append(") {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(assignment).append("\n       |  }\n       |} else {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(tempArrayDataName).append(".setNullAt(").append(k).append(");\n       |  }\n       |}\n       |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public ArrayRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRepeat copy(Expression left, Expression right) {
        return new ArrayRepeat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRepeat arrayRepeat = (ArrayRepeat)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRepeat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRepeat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRepeat.canEqual(this)) return false;
        return true;
    }

    public ArrayRepeat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

