/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingContext;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousFromTimestampStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousFromTimestampStartingScanner.class);
    private final long startupMillis;
    private final boolean startFromChangelog;

    public ContinuousFromTimestampStartingScanner(SnapshotManager snapshotManager, long startupMillis, boolean changelogAsFollowup, boolean changelogDecoupled) {
        super(snapshotManager);
        this.startupMillis = startupMillis;
        this.startFromChangelog = changelogAsFollowup && changelogDecoupled;
        this.startingSnapshotId = this.snapshotManager.earlierThanTimeMills(startupMillis, this.startFromChangelog);
    }

    @Override
    public StartingContext startingContext() {
        if (this.startingSnapshotId == null) {
            return StartingContext.EMPTY;
        }
        return new StartingContext(this.startingSnapshotId + 1L, false);
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long startingSnapshotId = this.snapshotManager.earlierThanTimeMills(this.startupMillis, this.startFromChangelog);
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        return new StartingScanner.NextSnapshot(startingSnapshotId + 1L);
    }
}

