/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import org.apache.amoro.server.dashboard.PlatformFileManager;
import org.apache.amoro.server.dashboard.response.ErrorResponse;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class PlatformFileInfoController {
    private final PlatformFileManager platformFileInfoService;

    public PlatformFileInfoController(PlatformFileManager platformFileInfoService) {
        this.platformFileInfoService = platformFileInfoService;
    }

    public void uploadFile(Context ctx) throws IOException {
        InputStream bodyAsInputStream = ctx.uploadedFile("file").getContent();
        String name = ctx.uploadedFile("file").getFilename();
        byte[] bytes = IOUtils.toByteArray((InputStream)bodyAsInputStream);
        if (name.toLowerCase().endsWith(".xml")) {
            try {
                Configuration configuration = new Configuration();
                configuration.addResource((InputStream)new ByteArrayInputStream(bytes));
                configuration.setDeprecatedProperties();
            }
            catch (Exception e) {
                ctx.json((Object)new ErrorResponse("Uploaded file is not in valid XML format"));
                return;
            }
        }
        String content = Base64.getEncoder().encodeToString(bytes);
        Integer fid = this.platformFileInfoService.addFile(name, content);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", String.valueOf(fid));
        result.put("url", "/ams/v1/files/" + fid);
        ctx.json(OkResponse.of(result));
    }

    public void downloadFile(Context ctx) {
        String fileId = ctx.pathParam("fileId");
        Preconditions.checkArgument((boolean)StringUtils.isNumeric((String)fileId), (Object)"Invalid file id");
        byte[] content = this.platformFileInfoService.getFileContentById(Integer.valueOf(fileId));
        ctx.result(content);
    }
}

