/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.util.CharSequenceWrapper;
import org.roaringbitmap.longlong.PeekableLongIterator;
import org.roaringbitmap.longlong.Roaring64Bitmap;

public class SortingPositionOnlyDeleteWriter<T>
implements FileWriter<PositionDelete<T>, DeleteWriteResult> {
    private final FileWriter<PositionDelete<T>, DeleteWriteResult> writer;
    private final Map<CharSequenceWrapper, Roaring64Bitmap> positionsByPath;
    private final CharSequenceWrapper pathWrapper;
    private DeleteWriteResult result = null;

    public SortingPositionOnlyDeleteWriter(FileWriter<PositionDelete<T>, DeleteWriteResult> writer) {
        this.writer = writer;
        this.positionsByPath = Maps.newHashMap();
        this.pathWrapper = CharSequenceWrapper.wrap(null);
    }

    @Override
    public void write(PositionDelete<T> positionDelete) {
        CharSequence path = positionDelete.path();
        long position = positionDelete.pos();
        Roaring64Bitmap positions = this.positionsByPath.get(this.pathWrapper.set(path));
        if (positions != null) {
            positions.add(new long[]{position});
        } else {
            positions = new Roaring64Bitmap();
            positions.add(new long[]{position});
            this.positionsByPath.put(CharSequenceWrapper.wrap((CharSequence)path), positions);
        }
    }

    @Override
    public long length() {
        return this.writer.length();
    }

    @Override
    public DeleteWriteResult result() {
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            this.result = this.writeDeletes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteWriteResult writeDeletes() throws IOException {
        try {
            PositionDelete positionDelete = PositionDelete.create();
            for (CharSequenceWrapper path : this.sortedPaths()) {
                PeekableLongIterator positions = this.positionsByPath.get(path).getLongIterator();
                while (positions.hasNext()) {
                    long position = positions.next();
                    this.writer.write(positionDelete.set(path.get(), position, null));
                }
            }
        }
        finally {
            this.writer.close();
        }
        return this.writer.result();
    }

    private List<CharSequenceWrapper> sortedPaths() {
        ArrayList paths = Lists.newArrayList(this.positionsByPath.keySet());
        paths.sort(Comparators.charSequences());
        return paths;
    }
}

