/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import java.io.IOException;
import java.time.Duration;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.statistics.BlockOutputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.ChangeTrackerStatistics;
import org.apache.hadoop.fs.s3a.statistics.CommitterStatistics;
import org.apache.hadoop.fs.s3a.statistics.DelegationTokenStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AMultipartUploaderStatistics;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticInterface;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;
import org.apache.hadoop.fs.s3a.statistics.impl.CountingChangeTracker;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public final class EmptyS3AStatisticsContext
implements S3AStatisticsContext {
    public static final S3AInputStreamStatistics EMPTY_INPUT_STREAM_STATISTICS = new EmptyInputStreamStatistics();
    public static final CommitterStatistics EMPTY_COMMITTER_STATISTICS = new EmptyCommitterStatistics();
    public static final BlockOutputStreamStatistics EMPTY_BLOCK_OUTPUT_STREAM_STATISTICS = new EmptyBlockOutputStreamStatistics();
    public static final DelegationTokenStatistics EMPTY_DELEGATION_TOKEN_STATISTICS = new EmptyDelegationTokenStatistics();
    public static final StatisticsFromAwsSdk EMPTY_STATISTICS_FROM_AWS_SDK = new EmptyStatisticsFromAwsSdk();

    @Override
    public S3AInputStreamStatistics newInputStreamStatistics() {
        return EMPTY_INPUT_STREAM_STATISTICS;
    }

    @Override
    public CommitterStatistics newCommitterStatistics() {
        return EMPTY_COMMITTER_STATISTICS;
    }

    @Override
    public BlockOutputStreamStatistics newOutputStreamStatistics() {
        return EMPTY_BLOCK_OUTPUT_STREAM_STATISTICS;
    }

    @Override
    public DelegationTokenStatistics newDelegationTokenStatistics() {
        return EMPTY_DELEGATION_TOKEN_STATISTICS;
    }

    @Override
    public StatisticsFromAwsSdk newStatisticsFromAwsSdk() {
        return EMPTY_STATISTICS_FROM_AWS_SDK;
    }

    @Override
    public S3AMultipartUploaderStatistics createMultipartUploaderStatistics() {
        return new EmptyMultipartUploaderStatistics();
    }

    @Override
    public void incrementCounter(Statistic op, long count) {
    }

    @Override
    public void incrementGauge(Statistic op, long count) {
    }

    @Override
    public void decrementGauge(Statistic op, long count) {
    }

    @Override
    public void addValueToQuantiles(Statistic op, long value) {
    }

    @Override
    public void recordDuration(Statistic op, boolean success, Duration duration) {
    }

    public static final class EmptyMultipartUploaderStatistics
    implements S3AMultipartUploaderStatistics {
        @Override
        public void instantiated() {
        }

        @Override
        public void uploadStarted() {
        }

        @Override
        public void partPut(long lengthInBytes) {
        }

        @Override
        public void uploadCompleted() {
        }

        @Override
        public void uploadAborted() {
        }

        @Override
        public void abortUploadsUnderPathInvoked() {
        }

        @Override
        public void close() throws IOException {
        }

        public DurationTracker trackDuration(String key, long count) {
            return IOStatisticsSupport.stubDurationTracker();
        }
    }

    private static final class EmptyStatisticsFromAwsSdk
    implements StatisticsFromAwsSdk {
        private EmptyStatisticsFromAwsSdk() {
        }

        @Override
        public void updateAwsRequestCount(long longValue) {
        }

        @Override
        public void updateAwsRetryCount(long longValue) {
        }

        @Override
        public void updateAwsThrottleExceptionsCount(long longValue) {
        }

        @Override
        public void noteAwsRequestTime(Duration ofMillis) {
        }

        @Override
        public void noteAwsClientExecuteTime(Duration ofMillis) {
        }

        @Override
        public void noteRequestMarshallTime(Duration duration) {
        }

        @Override
        public void noteRequestSigningTime(Duration duration) {
        }

        @Override
        public void noteResponseProcessingTime(Duration duration) {
        }
    }

    private static final class EmptyDelegationTokenStatistics
    extends EmptyS3AStatisticImpl
    implements DelegationTokenStatistics {
        private EmptyDelegationTokenStatistics() {
        }

        @Override
        public void tokenIssued() {
        }
    }

    private static final class EmptyBlockOutputStreamStatistics
    extends EmptyS3AStatisticImpl
    implements BlockOutputStreamStatistics {
        private EmptyBlockOutputStreamStatistics() {
        }

        @Override
        public void blockUploadQueued(long blockSize) {
        }

        @Override
        public void blockUploadStarted(Duration timeInQueue, long blockSize) {
        }

        @Override
        public void blockUploadCompleted(Duration timeSinceUploadStarted, long blockSize) {
        }

        @Override
        public void blockUploadFailed(Duration timeSinceUploadStarted, long blockSize) {
        }

        @Override
        public void bytesTransferred(long byteCount) {
        }

        @Override
        public void exceptionInMultipartComplete(int count) {
        }

        @Override
        public void exceptionInMultipartAbort() {
        }

        @Override
        public long getBytesPendingUpload() {
            return 0L;
        }

        @Override
        public void commitUploaded(long size) {
        }

        @Override
        public int getBlocksAllocated() {
            return 0;
        }

        @Override
        public int getBlocksReleased() {
            return 0;
        }

        @Override
        public int getBlocksActivelyAllocated() {
            return 0;
        }

        public IOStatistics getIOStatistics() {
            return IOStatisticsBinding.emptyStatistics();
        }

        @Override
        public void blockAllocated() {
        }

        @Override
        public void blockReleased() {
        }

        @Override
        public void writeBytes(long count) {
        }

        @Override
        public long getBytesWritten() {
            return 0L;
        }

        @Override
        public Long lookupCounterValue(String name) {
            return 0L;
        }

        @Override
        public Long lookupGaugeValue(String name) {
            return 0L;
        }

        @Override
        public void hflushInvoked() {
        }

        @Override
        public void hsyncInvoked() {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static final class EmptyCommitterStatistics
    extends EmptyS3AStatisticImpl
    implements CommitterStatistics {
        private EmptyCommitterStatistics() {
        }

        @Override
        public void commitCreated() {
        }

        @Override
        public void commitUploaded(long size) {
        }

        @Override
        public void commitCompleted(long size) {
        }

        @Override
        public void commitAborted() {
        }

        @Override
        public void commitReverted() {
        }

        @Override
        public void commitFailed() {
        }

        @Override
        public void taskCompleted(boolean success) {
        }

        @Override
        public void jobCompleted(boolean success) {
        }

        @Override
        public IOStatisticsStore getIOStatistics() {
            return null;
        }
    }

    private static final class EmptyInputStreamStatistics
    extends EmptyS3AStatisticImpl
    implements S3AInputStreamStatistics {
        private EmptyInputStreamStatistics() {
        }

        @Override
        public void seekBackwards(long negativeOffset) {
        }

        @Override
        public void seekForwards(long skipped, long bytesReadInSeek) {
        }

        @Override
        public long streamOpened() {
            return 0L;
        }

        @Override
        public void streamClose(boolean abortedConnection, long remainingInCurrentRequest) {
        }

        @Override
        public void readException() {
        }

        @Override
        public void bytesRead(long bytes) {
        }

        @Override
        public void readOperationStarted(long pos, long len) {
        }

        @Override
        public void readFullyOperationStarted(long pos, long len) {
        }

        @Override
        public void readOperationCompleted(int requested, int actual) {
        }

        @Override
        public void readVectoredOperationStarted(int numIncomingRanges, int numCombinedRanges) {
        }

        @Override
        public void readVectoredBytesDiscarded(int discarded) {
        }

        @Override
        public void close() {
        }

        @Override
        public void inputPolicySet(int updatedPolicy) {
        }

        @Override
        public void unbuffered() {
        }

        public DurationTracker prefetchOperationStarted() {
            return IOStatisticsSupport.stubDurationTracker();
        }

        public void prefetchOperationCompleted() {
        }

        public void blockAddedToFileCache() {
        }

        public void blockRemovedFromFileCache() {
        }

        public void blockEvictedFromFileCache() {
        }

        public void executorAcquired(Duration timeInQueue) {
        }

        public void memoryAllocated(int size) {
        }

        public void memoryFreed(int size) {
        }

        public IOStatistics getIOStatistics() {
            return IOStatisticsBinding.emptyStatistics();
        }

        @Override
        public long getCloseOperations() {
            return 0L;
        }

        @Override
        public long getClosed() {
            return 0L;
        }

        @Override
        public long getAborted() {
            return 0L;
        }

        @Override
        public long getForwardSeekOperations() {
            return 0L;
        }

        @Override
        public long getBackwardSeekOperations() {
            return 0L;
        }

        @Override
        public long getBytesRead() {
            return 0L;
        }

        @Override
        public long getTotalBytesRead() {
            return 0L;
        }

        @Override
        public long getBytesSkippedOnSeek() {
            return 0L;
        }

        @Override
        public long getBytesBackwardsOnSeek() {
            return 0L;
        }

        @Override
        public long getBytesReadInClose() {
            return 0L;
        }

        @Override
        public long getBytesDiscardedInAbort() {
            return 0L;
        }

        @Override
        public long getOpenOperations() {
            return 0L;
        }

        @Override
        public long getSeekOperations() {
            return 0L;
        }

        @Override
        public long getReadExceptions() {
            return 0L;
        }

        @Override
        public long getReadOperations() {
            return 0L;
        }

        @Override
        public long getReadFullyOperations() {
            return 0L;
        }

        @Override
        public long getReadsIncomplete() {
            return 0L;
        }

        @Override
        public long getPolicySetCount() {
            return 0L;
        }

        @Override
        public long getVersionMismatches() {
            return 0L;
        }

        @Override
        public long getInputPolicy() {
            return 0L;
        }

        @Override
        public Long lookupCounterValue(String name) {
            return 0L;
        }

        @Override
        public Long lookupGaugeValue(String name) {
            return 0L;
        }

        @Override
        public ChangeTrackerStatistics getChangeTrackerStatistics() {
            return new CountingChangeTracker();
        }

        @Override
        public DurationTracker initiateGetRequest() {
            return IOStatisticsSupport.stubDurationTracker();
        }

        @Override
        public DurationTracker initiateInnerStreamClose(boolean abort) {
            return IOStatisticsSupport.stubDurationTracker();
        }
    }

    private static class EmptyS3AStatisticImpl
    implements S3AStatisticInterface {
        private EmptyS3AStatisticImpl() {
        }

        public DurationTracker trackDuration(String key, long count) {
            return IOStatisticsSupport.stubDurationTracker();
        }
    }
}

