/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.amoro.utils.map.StructLikeBaseMap;
import org.apache.amoro.utils.map.StructLikeMemoryMap;
import org.apache.amoro.utils.map.StructLikeSpillableMap;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;

public class StructLikeSet
implements Closeable {
    private static final Integer _V = 0;
    private final StructLikeBaseMap<Integer> structLikeMap;

    public static StructLikeSet createMemorySet(Types.StructType type) {
        return new StructLikeSet(type);
    }

    public static StructLikeSet createSpillableSet(Types.StructType type, Long maxInMemorySizeInBytes, @Nullable String backendBaseDir) {
        return new StructLikeSet(type, maxInMemorySizeInBytes, backendBaseDir);
    }

    private StructLikeSet(Types.StructType type) {
        this.structLikeMap = StructLikeMemoryMap.create(type);
    }

    private StructLikeSet(Types.StructType type, Long maxInMemorySizeInBytes, @Nullable String backendBaseDir) {
        this.structLikeMap = StructLikeSpillableMap.create(type, maxInMemorySizeInBytes, backendBaseDir);
    }

    public boolean contains(StructLike key) {
        return this.structLikeMap.get(key) != null;
    }

    public void add(StructLike struct) {
        this.structLikeMap.put(struct, _V);
    }

    public void remove(StructLike struct) {
        this.structLikeMap.delete(struct);
    }

    @Override
    public void close() throws IOException {
        this.structLikeMap.close();
    }
}

