/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.ChangelogResult;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.MergeTreeCompactRewriter;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.FieldsComparator;

public abstract class ChangelogMergeTreeRewriter
extends MergeTreeCompactRewriter {
    protected final int maxLevel;
    protected final CoreOptions.MergeEngine mergeEngine;
    private final boolean produceChangelog;
    private final boolean forceDropDelete;

    public ChangelogMergeTreeRewriter(int maxLevel, CoreOptions.MergeEngine mergeEngine, FileReaderFactory<KeyValue> readerFactory, KeyValueFileWriterFactory writerFactory, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeFunctionFactory<KeyValue> mfFactory, MergeSorter mergeSorter, boolean produceChangelog, boolean forceDropDelete) {
        super(readerFactory, writerFactory, keyComparator, userDefinedSeqComparator, mfFactory, mergeSorter);
        this.maxLevel = maxLevel;
        this.mergeEngine = mergeEngine;
        this.produceChangelog = produceChangelog;
        this.forceDropDelete = forceDropDelete;
    }

    protected abstract boolean rewriteChangelog(int var1, boolean var2, List<List<SortedRun>> var3);

    protected abstract UpgradeStrategy upgradeStrategy(int var1, DataFileMeta var2);

    protected abstract MergeFunctionWrapper<ChangelogResult> createMergeWrapper(int var1);

    protected boolean rewriteLookupChangelog(int outputLevel, List<List<SortedRun>> sections) {
        if (outputLevel == 0) {
            return false;
        }
        for (List<SortedRun> runs : sections) {
            for (SortedRun run : runs) {
                for (DataFileMeta file : run.files()) {
                    if (file.level() != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public CompactResult rewrite(int outputLevel, boolean dropDelete, List<List<SortedRun>> sections) throws Exception {
        if (this.rewriteChangelog(outputLevel, dropDelete, sections)) {
            return this.rewriteOrProduceChangelog(outputLevel, sections, dropDelete, true);
        }
        return this.rewriteCompaction(outputLevel, dropDelete, sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompactResult rewriteOrProduceChangelog(int outputLevel, List<List<SortedRun>> sections, boolean dropDelete, boolean rewriteCompactFile) throws Exception {
        List<DataFileMeta> after;
        CloseableIterator<ChangelogResult> iterator = null;
        RollingFileWriter<KeyValue, DataFileMeta> compactFileWriter = null;
        RollingFileWriter<KeyValue, DataFileMeta> changelogFileWriter = null;
        try {
            iterator = this.readerForMergeTree(sections, this.createMergeWrapper(outputLevel)).toCloseableIterator();
            if (rewriteCompactFile) {
                compactFileWriter = this.writerFactory.createRollingMergeTreeFileWriter(outputLevel);
            }
            if (this.produceChangelog) {
                changelogFileWriter = this.writerFactory.createRollingChangelogFileWriter(outputLevel);
            }
            while (iterator.hasNext()) {
                ChangelogResult result = (ChangelogResult)iterator.next();
                KeyValue keyValue = result.result();
                if (compactFileWriter != null && keyValue != null && (!dropDelete || keyValue.isAdd())) {
                    compactFileWriter.write(keyValue);
                }
                if (!this.produceChangelog) continue;
                for (KeyValue kv : result.changelogs()) {
                    changelogFileWriter.write(kv);
                }
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
            if (compactFileWriter != null) {
                compactFileWriter.close();
            }
            if (changelogFileWriter != null) {
                changelogFileWriter.close();
            }
        }
        List<DataFileMeta> before = ChangelogMergeTreeRewriter.extractFilesFromSections(sections);
        List<DataFileMeta> list = after = compactFileWriter != null ? compactFileWriter.result() : before.stream().map(x -> x.upgrade(outputLevel)).collect(Collectors.toList());
        if (rewriteCompactFile) {
            this.notifyRewriteCompactBefore(before);
        }
        Object changelogFiles = changelogFileWriter != null ? changelogFileWriter.result() : Collections.emptyList();
        return new CompactResult(before, after, (List<DataFileMeta>)changelogFiles);
    }

    @Override
    public CompactResult upgrade(int outputLevel, DataFileMeta file) throws Exception {
        UpgradeStrategy strategy = this.upgradeStrategy(outputLevel, file);
        if (strategy.changelog) {
            return this.rewriteOrProduceChangelog(outputLevel, Collections.singletonList(Collections.singletonList(SortedRun.fromSingle(file))), this.forceDropDelete, strategy.rewrite);
        }
        return super.upgrade(outputLevel, file);
    }

    protected static enum UpgradeStrategy {
        NO_CHANGELOG_NO_REWRITE(false, false),
        CHANGELOG_NO_REWRITE(true, false),
        CHANGELOG_WITH_REWRITE(true, true);

        private final boolean changelog;
        private final boolean rewrite;

        private UpgradeStrategy(boolean changelog, boolean rewrite) {
            this.changelog = changelog;
            this.rewrite = rewrite;
        }
    }
}

