/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientMessage;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQuery;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryCloseRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryCloseResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteBatchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteBatchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryFetchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryFetchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetColumnsMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetColumnsMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetParamsMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetParamsMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetResultsetMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetResultsetMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetTablesMetaRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryGetTablesMetaResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryMoreResultsRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcQueryMoreResultsResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcResponse;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcStreamingBatchRequest;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcStreamingBatchResult;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcTableMeta;
import org.jetbrains.annotations.NotNull;

public class OdbcMessageParser
implements ClientListenerMessageParser {
    private final GridBinaryMarshaller marsh;
    protected static final int INIT_CAP = 1024;
    protected final GridKernalContext ctx;
    private final IgniteLogger log;
    private final ClientListenerProtocolVersion ver;

    public OdbcMessageParser(GridKernalContext ctx, ClientListenerProtocolVersion ver) {
        this.ctx = ctx;
        this.ver = ver;
        this.log = ctx.log(this.getClass());
        if (!(ctx.cacheObjects() instanceof CacheObjectBinaryProcessorImpl)) {
            throw new IgniteException("ODBC can only be used with BinaryMarshaller (please set it through IgniteConfiguration.setMarshaller())");
        }
        CacheObjectBinaryProcessorImpl cacheObjProc = (CacheObjectBinaryProcessorImpl)ctx.cacheObjects();
        this.marsh = cacheObjProc.marshaller();
    }

    @Override
    public ClientListenerRequest decode(ClientMessage msg) {
        OdbcRequest res;
        assert (msg != null);
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg.payload());
        BinaryReaderExImpl reader = new BinaryReaderExImpl(this.marsh.context(), stream, this.ctx.config().getClassLoader(), true);
        byte cmd = reader.readByte();
        switch (cmd) {
            case 2: {
                String schema = reader.readString();
                String sql = reader.readString();
                int paramNum = reader.readInt();
                Object[] params = OdbcMessageParser.readParameterRow(reader, paramNum);
                int timeout = 0;
                if (this.ver.compareTo(OdbcConnectionContext.VER_2_3_2) >= 0) {
                    timeout = reader.readInt();
                }
                boolean autoCommit = true;
                if (this.ver.compareTo(OdbcConnectionContext.VER_2_7_0) >= 0) {
                    autoCommit = reader.readBoolean();
                }
                res = new OdbcQueryExecuteRequest(schema, sql, params, timeout, autoCommit);
                break;
            }
            case 8: {
                String schema = reader.readString();
                String sql = reader.readString();
                int paramRowLen = reader.readInt();
                int rowNum = reader.readInt();
                boolean last = reader.readBoolean();
                Object[][] params = new Object[rowNum][];
                for (int i = 0; i < rowNum; ++i) {
                    params[i] = OdbcMessageParser.readParameterRow(reader, paramRowLen);
                }
                int timeout = 0;
                if (this.ver.compareTo(OdbcConnectionContext.VER_2_3_2) >= 0) {
                    timeout = reader.readInt();
                }
                boolean autoCommit = true;
                if (this.ver.compareTo(OdbcConnectionContext.VER_2_7_0) >= 0) {
                    autoCommit = reader.readBoolean();
                }
                res = new OdbcQueryExecuteBatchRequest(schema, sql, last, params, timeout, autoCommit);
                break;
            }
            case 10: {
                String schema = reader.readString();
                int num = reader.readInt();
                ArrayList<OdbcQuery> queries = new ArrayList<OdbcQuery>(num);
                for (int i = 0; i < num; ++i) {
                    OdbcQuery qry = new OdbcQuery();
                    qry.readBinary(reader);
                    queries.add(qry);
                }
                boolean last = reader.readBoolean();
                long order = reader.readLong();
                res = new OdbcStreamingBatchRequest(schema, queries, last, order);
                break;
            }
            case 3: {
                long queryId = reader.readLong();
                int pageSize = reader.readInt();
                res = new OdbcQueryFetchRequest(queryId, pageSize);
                break;
            }
            case 4: {
                long queryId = reader.readLong();
                res = new OdbcQueryCloseRequest(queryId);
                break;
            }
            case 5: {
                String schema = reader.readString();
                String table = reader.readString();
                String column = reader.readString();
                res = new OdbcQueryGetColumnsMetaRequest(schema, table, column);
                break;
            }
            case 6: {
                String catalog = reader.readString();
                String schema = reader.readString();
                String table = reader.readString();
                String tableType = reader.readString();
                res = new OdbcQueryGetTablesMetaRequest(catalog, schema, table, tableType);
                break;
            }
            case 7: {
                String schema = reader.readString();
                String sqlQuery = reader.readString();
                res = new OdbcQueryGetParamsMetaRequest(schema, sqlQuery);
                break;
            }
            case 11: {
                String schema = reader.readString();
                String sqlQuery = reader.readString();
                res = new OdbcQueryGetResultsetMetaRequest(schema, sqlQuery);
                break;
            }
            case 9: {
                long queryId = reader.readLong();
                int pageSize = reader.readInt();
                res = new OdbcQueryMoreResultsRequest(queryId, pageSize);
                break;
            }
            default: {
                throw new IgniteException("Unknown ODBC command: [cmd=" + cmd + ']');
            }
        }
        return res;
    }

    @NotNull
    private static Object[] readParameterRow(BinaryReaderExImpl reader, int paramNum) {
        Object[] params = new Object[paramNum];
        for (int i = 0; i < paramNum; ++i) {
            params[i] = SqlListenerUtils.readObject(reader, true);
        }
        return params;
    }

    @Override
    public ClientMessage encode(ClientListenerResponse msg0) {
        assert (msg0 != null);
        assert (msg0 instanceof OdbcResponse);
        OdbcResponse msg = (OdbcResponse)msg0;
        BinaryWriterExImpl writer = new BinaryWriterExImpl(this.marsh.context(), new BinaryHeapOutputStream(1024), BinaryThreadLocalContext.get().schemaHolder(), null);
        if (this.ver.compareTo(OdbcConnectionContext.VER_2_1_5) < 0) {
            writer.writeByte((byte)(msg.status() != 0 ? 1 : 0));
        } else {
            writer.writeInt(msg.status());
        }
        if (msg.status() != 0) {
            writer.writeString(msg.error());
            return new ClientMessage(writer.array());
        }
        Object res0 = msg.response();
        if (res0 == null) {
            return new ClientMessage(writer.array());
        }
        if (res0 instanceof OdbcQueryExecuteResult) {
            OdbcQueryExecuteResult res = (OdbcQueryExecuteResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.queryId());
            }
            writer.writeLong(res.queryId());
            Collection<OdbcColumnMeta> metas = res.columnsMetadata();
            this.writeResultsetMeta(writer, metas);
            this.writeAffectedRows(writer, res.affectedRows());
        } else if (res0 instanceof OdbcQueryExecuteBatchResult) {
            OdbcQueryExecuteBatchResult res = (OdbcQueryExecuteBatchResult)res0;
            writer.writeBoolean(res.errorMessage() == null);
            this.writeAffectedRows(writer, res.affectedRows());
            if (res.errorMessage() != null) {
                writer.writeLong(res.errorSetIdx());
                writer.writeString(res.errorMessage());
                if (this.ver.compareTo(OdbcConnectionContext.VER_2_1_5) >= 0) {
                    writer.writeInt(res.errorCode());
                }
            }
        } else if (res0 instanceof OdbcStreamingBatchResult) {
            OdbcStreamingBatchResult res = (OdbcStreamingBatchResult)res0;
            writer.writeString(res.error());
            writer.writeInt(res.status());
            writer.writeLong(res.order());
        } else if (res0 instanceof OdbcQueryFetchResult) {
            OdbcQueryFetchResult res = (OdbcQueryFetchResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.queryId());
            }
            writer.writeLong(res.queryId());
            Collection<?> items0 = res.items();
            assert (items0 != null);
            writer.writeBoolean(res.last());
            writer.writeInt(items0.size());
            for (Object row0 : items0) {
                if (row0 == null) continue;
                Collection row = (Collection)row0;
                writer.writeInt(row.size());
                for (Object obj : row) {
                    SqlListenerUtils.writeObject(writer, obj, true);
                }
            }
        } else if (res0 instanceof OdbcQueryMoreResultsResult) {
            OdbcQueryMoreResultsResult res = (OdbcQueryMoreResultsResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.queryId());
            }
            writer.writeLong(res.queryId());
            Collection<?> items0 = res.items();
            assert (items0 != null);
            writer.writeBoolean(res.last());
            writer.writeInt(items0.size());
            for (Object row0 : items0) {
                if (row0 == null) continue;
                Collection row = (Collection)row0;
                writer.writeInt(row.size());
                for (Object obj : row) {
                    SqlListenerUtils.writeObject(writer, obj, true);
                }
            }
        } else if (res0 instanceof OdbcQueryCloseResult) {
            OdbcQueryCloseResult res = (OdbcQueryCloseResult)res0;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resulting query ID: " + res.getQueryId());
            }
            writer.writeLong(res.getQueryId());
        } else if (res0 instanceof OdbcQueryGetColumnsMetaResult) {
            OdbcQueryGetColumnsMetaResult res = (OdbcQueryGetColumnsMetaResult)res0;
            Collection<OdbcColumnMeta> columnsMeta = res.meta();
            this.writeResultsetMeta(writer, columnsMeta);
        } else if (res0 instanceof OdbcQueryGetTablesMetaResult) {
            OdbcQueryGetTablesMetaResult res = (OdbcQueryGetTablesMetaResult)res0;
            Collection<OdbcTableMeta> tablesMeta = res.meta();
            assert (tablesMeta != null);
            writer.writeInt(tablesMeta.size());
            for (OdbcTableMeta tableMeta : tablesMeta) {
                tableMeta.writeBinary(writer);
            }
        } else if (res0 instanceof OdbcQueryGetParamsMetaResult) {
            OdbcQueryGetParamsMetaResult res = (OdbcQueryGetParamsMetaResult)res0;
            byte[] typeIds = res.typeIds();
            SqlListenerUtils.writeObject(writer, typeIds, true);
        } else if (res0 instanceof OdbcQueryGetResultsetMetaResult) {
            OdbcQueryGetResultsetMetaResult res = (OdbcQueryGetResultsetMetaResult)res0;
            this.writeResultsetMeta(writer, res.columnsMetadata());
        } else assert (false) : "Should not reach here.";
        return new ClientMessage(writer.array());
    }

    private void writeResultsetMeta(BinaryWriterExImpl writer, Collection<OdbcColumnMeta> meta) {
        assert (meta != null);
        writer.writeInt(meta.size());
        for (OdbcColumnMeta columnMeta : meta) {
            columnMeta.write(writer, this.ver);
        }
    }

    @Override
    public int decodeCommandType(ClientMessage msg) {
        assert (msg != null);
        return msg.payload()[0];
    }

    @Override
    public long decodeRequestId(ClientMessage msg) {
        return 0L;
    }

    private void writeAffectedRows(BinaryWriterExImpl writer, long[] affectedRows) {
        if (this.ver.compareTo(OdbcConnectionContext.VER_2_3_2) < 0) {
            long summ = 0L;
            long[] lArray = affectedRows;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long value = lArray[i];
                summ += value == null ? 0L : value;
            }
            writer.writeLong(summ);
        } else {
            writer.writeInt(affectedRows.length);
            for (long value : affectedRows) {
                writer.writeLong(value);
            }
        }
    }
}

