/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.store.PageStoreCollection;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PageReadWriteManagerImpl
implements PageReadWriteManager {
    private final GridKernalContext ctx;
    @GridToStringExclude
    protected final PageStoreCollection pageStores;
    private final String name;

    public PageReadWriteManagerImpl(GridKernalContext ctx, PageStoreCollection pageStores, String name) {
        this.ctx = ctx;
        this.pageStores = pageStores;
        this.name = name;
    }

    @Override
    public void read(int grpId, long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteCheckedException {
        PageStore store = this.pageStores.getStore(grpId, PageIdUtils.partId(pageId));
        try {
            store.read(pageId, pageBuf, keepCrc);
            this.ctx.compress().decompressPage(pageBuf, store.getPageSize());
        }
        catch (StorageException e) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public PageStore write(int grpId, long pageId, ByteBuffer pageBuf, int tag, boolean calculateCrc) throws IgniteCheckedException {
        int partId = PageIdUtils.partId(pageId);
        PageStore store = this.pageStores.getStore(grpId, partId);
        try {
            int pageSize;
            int compressedPageSize = pageSize = store.getPageSize();
            GridCacheContext cctx0 = this.ctx.cache().context().cacheContext(grpId);
            if (cctx0 != null) {
                assert (pageBuf.position() == 0 && pageBuf.limit() == pageSize) : pageBuf;
                ByteBuffer compressedPageBuf = cctx0.compress().compressPage(pageBuf, store);
                if (compressedPageBuf != pageBuf) {
                    compressedPageSize = PageIO.getCompressedSize(compressedPageBuf);
                    if (!calculateCrc) {
                        calculateCrc = true;
                        PageIO.setCrc(compressedPageBuf, 0);
                    }
                    PageIO.setCrc(pageBuf, 0);
                    pageBuf = compressedPageBuf;
                }
            }
            store.write(pageId, pageBuf, tag, calculateCrc);
            if (pageSize > compressedPageSize) {
                store.punchHole(pageId, compressedPageSize);
            }
        }
        catch (StorageException e) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
        return store;
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteCheckedException {
        assert (partId <= 65500 || partId == 65535);
        PageStore store = this.pageStores.getStore(grpId, partId);
        try {
            long pageIdx = store.allocatePage();
            return PageIdUtils.pageId(partId, flags, (int)pageIdx);
        }
        catch (StorageException e) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    public String toString() {
        return S.toString(PageReadWriteManagerImpl.class, this);
    }
}

