/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.StripedCompositeReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridDhtPartitionTopologyImpl
implements GridDhtPartitionTopology {
    private static final GridDhtPartitionState[] MOVING_STATES = new GridDhtPartitionState[]{GridDhtPartitionState.MOVING};
    private static final boolean FULL_MAP_DEBUG = false;
    private static final boolean FAST_DIFF_REBUILD = false;
    private final GridCacheSharedContext ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private final IgniteLogger timeLog;
    private final AtomicReferenceArray<GridDhtLocalPartition> locParts;
    private GridDhtPartitionFullMap node2part;
    private Set<Integer> lostParts;
    private final Map<Integer, Set<UUID>> diffFromAffinity = new HashMap<Integer, Set<UUID>>();
    private volatile AffinityTopologyVersion diffFromAffinityVer = AffinityTopologyVersion.NONE;
    private volatile AffinityTopologyVersion lastTopChangeVer = AffinityTopologyVersion.NONE;
    private volatile AffinityTopologyVersion readyTopVer = AffinityTopologyVersion.NONE;
    private volatile DiscoCache discoCache;
    private volatile boolean stopping;
    private volatile GridDhtTopologyFuture topReadyFut;
    private final GridAtomicLong updateSeq = new GridAtomicLong(1L);
    private final StripedCompositeReadWriteLock lock = new StripedCompositeReadWriteLock(16);
    private final CachePartitionFullCountersMap cntrMap;
    private volatile Map<Integer, Long> globalPartSizes;
    private volatile AffinityTopologyVersion rebalancedTopVer = AffinityTopologyVersion.NONE;
    private PartitionFactory partFactory;

    public GridDhtPartitionTopologyImpl(GridCacheSharedContext ctx, CacheGroupContext grp) {
        assert (ctx != null);
        assert (grp != null);
        this.ctx = ctx;
        this.grp = grp;
        this.log = ctx.logger(this.getClass());
        this.timeLog = ctx.logger("org.apache.ignite.internal.exchange.time");
        this.locParts = new AtomicReferenceArray(grp.affinityFunction().partitions());
        this.cntrMap = new CachePartitionFullCountersMap(this.locParts.length());
        this.partFactory = GridDhtLocalPartition::new;
    }

    public void partitionFactory(PartitionFactory factory) {
        this.partFactory = factory;
    }

    @Override
    public int partitions() {
        return this.grp.affinityFunction().partitions();
    }

    @Override
    public int groupId() {
        return this.grp.groupId();
    }

    public void onReconnected() {
        this.lock.writeLock().lock();
        try {
            this.node2part = null;
            this.diffFromAffinity.clear();
            this.updateSeq.set(1L);
            this.topReadyFut = null;
            this.diffFromAffinityVer = AffinityTopologyVersion.NONE;
            this.rebalancedTopVer = AffinityTopologyVersion.NONE;
            this.readyTopVer = AffinityTopologyVersion.NONE;
            this.lastTopChangeVer = AffinityTopologyVersion.NONE;
            this.discoCache = this.ctx.discovery().discoCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String fullMapString() {
        return this.node2part == null ? "null" : this.node2part.toString();
    }

    private String mapString(GridDhtPartitionMap map) {
        return map == null ? "null" : map.toString();
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    @Override
    public boolean holdsLock() {
        return this.lock.isWriteLockedByCurrentThread() || this.lock.getReadHoldCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologyVersion(GridDhtTopologyFuture exchFut, @NotNull DiscoCache discoCache, long updSeq, boolean stopping) throws IgniteInterruptedCheckedException {
        U.writeLock(this.lock);
        try {
            AffinityTopologyVersion exchTopVer = exchFut.initialVersion();
            assert (exchTopVer.compareTo(this.readyTopVer) > 0) : "Invalid topology version [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.readyTopVer + ", exchTopVer=" + exchTopVer + ", discoCacheVer=" + (this.discoCache != null ? this.discoCache.version() : "None") + ", exchDiscoCacheVer=" + discoCache.version() + ", fut=" + exchFut + ']';
            this.stopping = stopping;
            this.updateSeq.setIfGreater(updSeq);
            this.topReadyFut = exchFut;
            this.rebalancedTopVer = AffinityTopologyVersion.NONE;
            this.lastTopChangeVer = exchTopVer;
            this.discoCache = discoCache;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean initialized() {
        AffinityTopologyVersion topVer = this.readyTopVer;
        assert (topVer != null);
        return topVer.initialized();
    }

    @Override
    public AffinityTopologyVersion readyTopologyVersion() {
        AffinityTopologyVersion topVer = this.readyTopVer;
        assert (topVer.topologyVersion() > 0L) : "Invalid topology version [topVer=" + topVer + ", group=" + this.grp.cacheOrGroupName() + ']';
        return topVer;
    }

    @Override
    public AffinityTopologyVersion lastTopologyChangeVersion() {
        AffinityTopologyVersion topVer = this.lastTopChangeVer;
        assert (topVer.topologyVersion() > 0L) : "Invalid topology version [topVer=" + topVer + ", group=" + this.grp.cacheOrGroupName() + ']';
        return topVer;
    }

    @Override
    public GridDhtTopologyFuture topologyVersionFuture() {
        GridDhtPartitionsExchangeFuture lastFut;
        GridDhtTopologyFuture topReadyFut0 = this.topReadyFut;
        assert (topReadyFut0 != null);
        if (!topReadyFut0.changedAffinity() && (lastFut = this.ctx.exchange().lastFinishedFuture()) != null) {
            return lastFut;
        }
        return topReadyFut0;
    }

    @Override
    public boolean stopping() {
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initPartitionsWhenAffinityReady(AffinityTopologyVersion affVer, GridDhtPartitionsExchangeFuture exchFut) throws IgniteInterruptedCheckedException {
        boolean needRefresh;
        this.ctx.database().checkpointReadLock();
        try {
            U.writeLock(this.lock);
            try {
                if (this.stopping) {
                    boolean bl = false;
                    return bl;
                }
                long updateSeq = this.updateSeq.incrementAndGet();
                needRefresh = this.initPartitions(affVer, this.grp.affinity().readyAssignments(affVer), exchFut, updateSeq);
                this.consistencyCheck();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
        return needRefresh;
    }

    private boolean initPartitions(AffinityTopologyVersion affVer, List<List<ClusterNode>> affAssignment, GridDhtPartitionsExchangeFuture exchFut, long updateSeq) {
        boolean needRefresh = false;
        if (this.grp.affinityNode()) {
            ClusterNode loc = this.ctx.localNode();
            ClusterNode oldest = this.discoCache.oldestAliveServerNode();
            GridDhtPartitionExchangeId exchId = exchFut.exchangeId();
            int partitions = this.grp.affinity().partitions();
            if (this.grp.rebalanceEnabled()) {
                boolean first;
                boolean added = exchFut.cacheGroupAddedOnExchange(this.grp.groupId(), this.grp.receivedFrom());
                boolean bl = first = added || loc.equals(oldest) && loc.id().equals(exchId.nodeId()) && exchId.isJoined() || exchFut.activateCluster();
                if (first) {
                    assert (exchId.isJoined() || added || exchFut.activateCluster());
                    if (this.log.isDebugEnabled()) {
                        String reason = exchId.isJoined() ? "First node in cluster" : (added ? "Cache group added" : "Cluster activate");
                        this.log.debug("Initialize partitions (" + reason + ") [grp=" + this.grp.cacheOrGroupName() + "]");
                    }
                    for (int p = 0; p < partitions; ++p) {
                        if (this.localNode(p, affAssignment)) {
                            boolean shouldOwn = this.locParts.get(p) == null;
                            GridDhtLocalPartition locPart = this.getOrCreatePartition(p);
                            if (shouldOwn) {
                                locPart.own();
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Partition has been owned (created first time) [grp=" + this.grp.cacheOrGroupName() + ", p=" + locPart.id() + ']');
                                }
                            }
                            needRefresh = true;
                            updateSeq = this.updateLocal(p, locPart.state(), updateSeq, affVer);
                            continue;
                        }
                        GridDhtLocalPartition locPart = this.locParts.get(p);
                        if (locPart == null) continue;
                        needRefresh = true;
                        updateSeq = this.updateLocal(p, locPart.state(), updateSeq, affVer);
                    }
                } else {
                    this.createPartitions(affVer, affAssignment, updateSeq);
                }
            } else {
                for (int p = 0; p < partitions; ++p) {
                    GridDhtLocalPartition locPart = this.localPartition0(p, affVer, false, true);
                    boolean belongs = this.localNode(p, affAssignment);
                    if (locPart != null) {
                        if (!belongs) {
                            GridDhtPartitionState state = locPart.state();
                            if (!state.active()) continue;
                            locPart.rent();
                            updateSeq = this.updateLocal(p, locPart.state(), updateSeq, affVer);
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Evicting partition with rebalancing disabled (it does not belong to affinity) [grp=" + this.grp.cacheOrGroupName() + ", part=" + locPart + ']');
                            continue;
                        }
                        locPart.own();
                        updateSeq = this.updateLocal(p, locPart.state(), updateSeq, affVer);
                        continue;
                    }
                    if (!belongs) continue;
                    locPart = this.getOrCreatePartition(p);
                    locPart.own();
                    this.updateLocal(p, locPart.state(), updateSeq, affVer);
                }
            }
        }
        this.updateRebalanceVersion(affVer, affAssignment);
        return needRefresh;
    }

    private void createPartitions(AffinityTopologyVersion affVer, List<List<ClusterNode>> aff, long updateSeq) {
        if (!this.grp.affinityNode()) {
            return;
        }
        int partitions = this.grp.affinity().partitions();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create non-existing partitions [grp=" + this.grp.cacheOrGroupName() + "]");
        }
        for (int p = 0; p < partitions; ++p) {
            if (this.node2part != null && this.node2part.valid()) {
                if (!this.localNode(p, aff)) continue;
                GridDhtLocalPartition locPart = this.locParts.get(p);
                if (locPart != null) {
                    if (locPart.state() == GridDhtPartitionState.RENTING) {
                        if (this.lostPartitions().contains(locPart.id())) {
                            locPart.markLost();
                        } else {
                            locPart.moving();
                        }
                    }
                    if (locPart.state() == GridDhtPartitionState.EVICTED) {
                        locPart = this.getOrCreatePartition(p);
                    }
                } else {
                    locPart = this.getOrCreatePartition(p);
                }
                updateSeq = this.updateLocal(p, locPart.state(), updateSeq, affVer);
                continue;
            }
            if (!this.localNode(p, aff)) continue;
            this.getOrCreatePartition(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture exchFut, boolean affReady, boolean updateMoving) throws IgniteCheckedException {
        this.ctx.database().checkpointReadLock();
        try {
            U.writeLock(this.lock);
            try {
                if (this.stopping) {
                    return;
                }
                assert (this.lastTopChangeVer.equals(exchFut.initialVersion())) : "Invalid topology version [topVer=" + this.lastTopChangeVer + ", exchId=" + exchFut.exchangeId() + ']';
                ExchangeDiscoveryEvents evts = exchFut.context().events();
                if (affReady) {
                    assert (this.grp.affinity().lastVersion().equals(evts.topologyVersion())) : "Invalid affinity version [grp=" + this.grp.cacheOrGroupName() + ", affVer=" + this.grp.affinity().lastVersion() + ", evtsVer=" + evts.topologyVersion() + ']';
                    this.lastTopChangeVer = this.readyTopVer = evts.topologyVersion();
                    this.discoCache = evts.discoveryCache();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map beforeExchange [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
                }
                long updateSeq = this.updateSeq.incrementAndGet();
                this.cntrMap.clear();
                this.initializeFullMap(updateSeq);
                boolean grpStarted = exchFut.cacheGroupAddedOnExchange(this.grp.groupId(), this.grp.receivedFrom());
                if (evts.hasServerLeft()) {
                    for (DiscoveryEvent discoveryEvent : evts.events()) {
                        if (!ExchangeDiscoveryEvents.serverLeftEvent(discoveryEvent)) continue;
                        this.removeNode(discoveryEvent.eventNode().id());
                    }
                } else if (affReady && grpStarted && exchFut.exchangeType() == GridDhtPartitionsExchangeFuture.ExchangeType.NONE) {
                    assert (!exchFut.context().mergeExchanges()) : exchFut;
                    assert (this.node2part != null && this.node2part.valid()) : exchFut;
                    List<ClusterNode> nodes = exchFut.firstEventCache().cacheGroupAffinityNodes(this.grp.groupId());
                    for (ClusterNode node : nodes) {
                        if (this.node2part.containsKey(node.id()) || !this.ctx.discovery().alive(node)) continue;
                        GridDhtPartitionMap partMap = new GridDhtPartitionMap(node.id(), 1L, exchFut.initialVersion(), new GridPartitionStateMap(), false);
                        AffinityAssignment aff = this.grp.affinity().cachedAffinity(exchFut.initialVersion());
                        for (Integer p0 : aff.primaryPartitions(node.id())) {
                            partMap.put(p0, GridDhtPartitionState.OWNING);
                        }
                        for (Integer p0 : aff.backupPartitions(node.id())) {
                            partMap.put(p0, GridDhtPartitionState.OWNING);
                        }
                        this.node2part.put(node.id(), partMap);
                    }
                }
                if (this.grp.affinityNode() && (grpStarted || exchFut.firstEvent().type() == 18 || exchFut.serverNodeDiscoveryEvent())) {
                    void var9_13;
                    AffinityTopologyVersion affVer;
                    if (affReady) {
                        affVer = evts.topologyVersion();
                        assert (this.grp.affinity().lastVersion().equals(affVer)) : "Invalid affinity [topVer=" + this.grp.affinity().lastVersion() + ", grp=" + this.grp.cacheOrGroupName() + ", affVer=" + affVer + ", fut=" + exchFut + ']';
                        List<List<ClusterNode>> list = this.grp.affinity().readyAssignments(affVer);
                    } else {
                        assert (!exchFut.context().mergeExchanges());
                        affVer = exchFut.initialVersion();
                        List<List<ClusterNode>> list = this.grp.affinity().idealAssignmentRaw();
                    }
                    this.initPartitions(affVer, (List<List<ClusterNode>>)var9_13, exchFut, updateSeq);
                }
                this.consistencyCheck();
                if (updateMoving) {
                    assert (this.grp.affinity().lastVersion().equals(evts.topologyVersion()));
                    this.createMovingPartitions(this.grp.affinity().readyAffinity(evts.topologyVersion()));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map after beforeExchange [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Partition states after beforeExchange [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", states=" + this.dumpPartitionStates() + ']');
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    private void initializeFullMap(long updateSeq) {
        if (!(this.topReadyFut instanceof GridDhtPartitionsExchangeFuture)) {
            return;
        }
        GridDhtPartitionsExchangeFuture exchFut = (GridDhtPartitionsExchangeFuture)this.topReadyFut;
        boolean grpStarted = exchFut.cacheGroupAddedOnExchange(this.grp.groupId(), this.grp.receivedFrom());
        ClusterNode oldest = this.discoCache.oldestAliveServerNode();
        if (oldest != null && (this.ctx.localNode().equals(oldest) || grpStarted)) {
            if (this.node2part == null) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created brand new full topology map on oldest node [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
                }
            } else if (!this.node2part.valid()) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Created new full topology map on oldest node [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.node2part + ']');
                }
            } else if (!this.node2part.nodeId().equals(this.ctx.localNode().id())) {
                this.node2part = new GridDhtPartitionFullMap(oldest.id(), oldest.order(), updateSeq, this.node2part, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Copied old map into new map on oldest node (previous oldest node left) [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
                }
            }
        }
    }

    private boolean partitionLocalNode(int p, AffinityTopologyVersion topVer) {
        return this.grp.affinity().nodes(p, topVer).contains(this.ctx.localNode());
    }

    @Override
    public void afterStateRestored(AffinityTopologyVersion topVer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterExchange(GridDhtPartitionsExchangeFuture exchFut) {
        boolean changed = false;
        int partitions = this.grp.affinity().partitions();
        AffinityTopologyVersion topVer = exchFut.context().events().topologyVersion();
        assert (this.grp.affinity().lastVersion().equals(topVer)) : "Affinity is not initialized [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + topVer + ", affVer=" + this.grp.affinity().lastVersion() + ", fut=" + exchFut + ']';
        this.ctx.database().checkpointReadLock();
        try {
            this.lock.writeLock().lock();
            try {
                if (this.stopping) {
                    boolean bl = false;
                    return bl;
                }
                assert (this.readyTopVer.initialized()) : this.readyTopVer;
                assert (this.lastTopChangeVer.equals(this.readyTopVer));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map before afterExchange [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchFut.exchangeId() + ", fullMap=" + this.fullMapString() + ']');
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Partition states before afterExchange [grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchFut.exchangeId() + ", states=" + this.dumpPartitionStates() + ']');
                }
                long updateSeq = this.updateSeq.incrementAndGet();
                if (!this.ctx.localNode().isClient() && exchFut.exchangeType() == GridDhtPartitionsExchangeFuture.ExchangeType.ALL) {
                    for (int p = 0; p < partitions; ++p) {
                        GridDhtPartitionState state;
                        GridDhtLocalPartition locPart = this.localPartition0(p, topVer, false, true);
                        if (this.partitionLocalNode(p, topVer)) {
                            if (locPart == null || locPart.state() == GridDhtPartitionState.RENTING || locPart.state() == GridDhtPartitionState.EVICTED) {
                                locPart = this.rebalancePartition(p, true, exchFut);
                            }
                            if ((state = locPart.state()) != GridDhtPartitionState.MOVING) continue;
                            if (this.grp.rebalanceEnabled()) {
                                List<ClusterNode> owners = this.owners(p);
                                if (F.isEmpty(owners) || !this.log.isDebugEnabled()) continue;
                                this.log.debug("Will not own partition (there are owners to rebalance from) [grp=" + this.grp.cacheOrGroupName() + ", p=" + p + ", owners = " + owners + ']');
                                continue;
                            }
                            updateSeq = this.updateLocal(p, locPart.state(), updateSeq, topVer);
                            continue;
                        }
                        if (locPart == null || (state = locPart.state()) != GridDhtPartitionState.MOVING) continue;
                        locPart.rent();
                        updateSeq = this.updateLocal(p, locPart.state(), updateSeq, topVer);
                        changed = true;
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Evicting MOVING partition (it does not belong to affinity) [grp=" + this.grp.cacheOrGroupName() + ", p=" + locPart.id() + ']');
                    }
                }
                AffinityAssignment aff = this.grp.affinity().readyAffinity(topVer);
                if (this.node2part != null && this.node2part.valid()) {
                    changed |= this.checkEvictions(updateSeq, aff);
                }
                this.updateRebalanceVersion(aff.topologyVersion(), aff.assignment());
                this.consistencyCheck();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Partition states after afterExchange [grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchFut.exchangeId() + ", states=" + this.dumpPartitionStates() + ']');
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
        return changed;
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create) throws GridDhtInvalidPartitionException {
        return this.localPartition0(p, topVer, create, false);
    }

    @Override
    @Nullable
    public GridDhtLocalPartition localPartition(int p, AffinityTopologyVersion topVer, boolean create, boolean showRenting) throws GridDhtInvalidPartitionException {
        return this.localPartition0(p, topVer, create, showRenting);
    }

    public GridDhtLocalPartition getOrCreatePartition(int p) {
        assert (this.lock.isWriteLockedByCurrentThread());
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        GridDhtLocalPartition loc = this.locParts.get(p);
        if (loc == null || loc.state() == GridDhtPartitionState.EVICTED) {
            long updCntr;
            boolean recreate = false;
            if (loc != null) {
                recreate = true;
            }
            loc = this.partFactory.create(this.ctx, this.grp, p, false);
            this.locParts.set(p, loc);
            if (recreate) {
                loc.resetUpdateCounter();
            }
            if ((updCntr = this.cntrMap.updateCounter(p)) != 0L) {
                loc.updateCounter(updCntr);
            }
            if (this.lostParts != null && this.lostParts.contains(p)) {
                loc.markLost();
            }
            if (this.ctx.pageStore() != null) {
                try {
                    this.ctx.pageStore().onPartitionCreated(this.grp.groupId(), p);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtLocalPartition forceCreatePartition(int p) throws IgniteCheckedException {
        this.lock.writeLock().lock();
        try {
            GridDhtLocalPartition part = this.locParts.get(p);
            boolean recreate = false;
            if (part != null) {
                if (part.state() != GridDhtPartitionState.EVICTED) {
                    GridDhtLocalPartition gridDhtLocalPartition = part;
                    return gridDhtLocalPartition;
                }
                recreate = true;
            }
            part = this.partFactory.create(this.ctx, this.grp, p, true);
            if (recreate) {
                part.resetUpdateCounter();
            }
            this.locParts.set(p, part);
            GridDhtLocalPartition gridDhtLocalPartition = part;
            return gridDhtLocalPartition;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridDhtLocalPartition localPartition0(int p, AffinityTopologyVersion topVer, boolean create, boolean showRenting) {
        GridDhtPartitionState state;
        GridDhtLocalPartition loc = this.locParts.get(p);
        GridDhtPartitionState gridDhtPartitionState = state = loc != null ? loc.state() : null;
        if (loc != null && state != GridDhtPartitionState.EVICTED && (state != GridDhtPartitionState.RENTING || showRenting)) {
            return loc;
        }
        if (!create) {
            return null;
        }
        boolean created = false;
        this.ctx.database().checkpointReadLock();
        try {
            this.lock.writeLock().lock();
            try {
                loc = this.locParts.get(p);
                state = loc != null ? loc.state() : null;
                boolean belongs = this.partitionLocalNode(p, topVer);
                boolean recreate = false;
                if (loc != null && state == GridDhtPartitionState.EVICTED) {
                    recreate = true;
                    loc = null;
                    this.locParts.set(p, null);
                    if (!belongs) {
                        throw new GridDhtInvalidPartitionException(p, "Adding entry to evicted partition (often may be caused by inconsistent 'key.hashCode()' implementation) [grp=" + this.grp.cacheOrGroupName() + ", part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.readyTopVer + ']');
                    }
                } else if (loc != null && state == GridDhtPartitionState.RENTING && !showRenting) {
                    boolean belongsNow = topVer.equals(this.readyTopVer) ? belongs : this.partitionLocalNode(p, this.readyTopVer);
                    throw new GridDhtInvalidPartitionException(p, "Adding entry to partition that is concurrently evicted [grp=" + this.grp.cacheOrGroupName() + ", part=" + p + ", belongsNow=" + belongsNow + ", belongs=" + belongs + ", topVer=" + topVer + ", curTopVer=" + this.readyTopVer + "]");
                }
                if (loc == null) {
                    if (!belongs) {
                        throw new GridDhtInvalidPartitionException(p, "Creating partition which does not belong to local node (often may be caused by inconsistent 'key.hashCode()' implementation) [grp=" + this.grp.cacheOrGroupName() + ", part=" + p + ", topVer=" + topVer + ", this.topVer=" + this.readyTopVer + ']');
                    }
                    loc = this.partFactory.create(this.ctx, this.grp, p, false);
                    this.locParts.set(p, loc);
                    if (recreate) {
                        loc.resetUpdateCounter();
                    }
                    this.updateSeq.incrementAndGet();
                    created = true;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
        if (created && this.ctx.pageStore() != null) {
            try {
                this.ctx.pageStore().onPartitionCreated(this.grp.groupId(), p);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
        return loc;
    }

    @Override
    public void releasePartitions(int ... parts) {
        assert (parts != null);
        assert (parts.length > 0);
        for (int i = 0; i < parts.length; ++i) {
            GridDhtLocalPartition part = this.locParts.get(parts[i]);
            if (part == null) continue;
            part.release();
        }
    }

    @Override
    public GridDhtLocalPartition localPartition(int part) {
        return this.locParts.get(part);
    }

    @Override
    public List<GridDhtLocalPartition> localPartitions() {
        ArrayList<GridDhtLocalPartition> list = new ArrayList<GridDhtLocalPartition>(this.locParts.length());
        for (int i = 0; i < this.locParts.length(); ++i) {
            GridDhtLocalPartition part = this.locParts.get(i);
            if (part == null || !part.state().active()) continue;
            list.add(part);
        }
        return list;
    }

    @Override
    public Iterable<GridDhtLocalPartition> currentLocalPartitions() {
        return new Iterable<GridDhtLocalPartition>(){

            @Override
            public Iterator<GridDhtLocalPartition> iterator() {
                return new CurrentPartitionsIterator();
            }
        };
    }

    @Override
    public void onRemoved(GridDhtCacheEntry e) {
        GridDhtLocalPartition loc = this.localPartition(e.partition(), this.readyTopVer, false);
        if (loc != null) {
            loc.onRemoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionMap localPartitionMap() {
        GridPartitionStateMap map = new GridPartitionStateMap(this.locParts.length());
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                map.put(i, part.state());
            }
            GridDhtPartitionMap locPartMap = this.node2part != null ? (GridDhtPartitionMap)this.node2part.get(this.ctx.localNodeId()) : null;
            GridDhtPartitionMap gridDhtPartitionMap = new GridDhtPartitionMap(this.ctx.localNodeId(), this.updateSeq.get(), locPartMap != null ? locPartMap.topologyVersion() : this.readyTopVer, map, true);
            return gridDhtPartitionMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionState partitionState(UUID nodeId, int part) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap partMap = (GridDhtPartitionMap)this.node2part.get(nodeId);
            if (partMap != null) {
                GridDhtPartitionState state = partMap.get(part);
                GridDhtPartitionState gridDhtPartitionState = state == null ? GridDhtPartitionState.EVICTED : state;
                return gridDhtPartitionState;
            }
            GridDhtPartitionState gridDhtPartitionState = GridDhtPartitionState.EVICTED;
            return gridDhtPartitionState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public List<ClusterNode> nodes(int p, AffinityAssignment affAssignment, List<ClusterNode> affNodes) {
        return this.nodes0(p, affAssignment, affNodes);
    }

    @Override
    public List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer) {
        List<ClusterNode> affNodes;
        AffinityAssignment affAssignment = this.grp.affinity().cachedAffinity(topVer);
        List<ClusterNode> nodes = this.nodes0(p, affAssignment, affNodes = affAssignment.get(p));
        return nodes != null ? nodes : affNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<ClusterNode> nodes0(int p, AffinityAssignment affAssignment, List<ClusterNode> affNodes) {
        if (this.grp.isReplicated()) {
            return affNodes;
        }
        AffinityTopologyVersion topVer = affAssignment.topologyVersion();
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer1=" + topVer + ", topVer2=" + this.readyTopVer + ", node=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ", node2part=" + this.node2part + ']';
            ArrayList<ClusterNode> nodes = null;
            AffinityTopologyVersion diffVer = this.diffFromAffinityVer;
            if (!diffVer.equals(topVer)) {
                boolean affChanged;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Requested topology version does not match calculated diff, need to check if affinity has changed [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + topVer + ", diffVer=" + diffVer + "]");
                }
                if (affChanged = diffVer.compareTo(topVer) < 0 ? this.ctx.exchange().affinityChanged(diffVer, topVer) : this.ctx.exchange().affinityChanged(topVer, diffVer)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Requested topology version does not match calculated diff, will require full iteration tocalculate mapping [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + topVer + ", diffVer=" + diffVer + "]");
                    }
                    nodes = new ArrayList<ClusterNode>();
                    nodes.addAll(affNodes);
                    for (Map.Entry entry : this.node2part.entrySet()) {
                        GridDhtPartitionState state = ((GridDhtPartitionMap)entry.getValue()).get(p);
                        ClusterNode n = this.ctx.discovery().node((UUID)entry.getKey());
                        if (n == null || state == null || state != GridDhtPartitionState.MOVING && state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.RENTING || nodes.contains(n) || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                        nodes.add(n);
                    }
                }
                ArrayList<ClusterNode> arrayList = nodes;
                return arrayList;
            }
            Collection diffIds = this.diffFromAffinity.get(p);
            if (!F.isEmpty(diffIds)) {
                Collection<UUID> affIds = affAssignment.getIds(p);
                for (UUID nodeId : diffIds) {
                    ClusterNode n;
                    if (affIds.contains(nodeId) || !this.hasState(p, nodeId, GridDhtPartitionState.OWNING, GridDhtPartitionState.MOVING, GridDhtPartitionState.RENTING) || (n = this.ctx.discovery().node(nodeId)) == null || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                    if (nodes == null) {
                        nodes = new ArrayList(affNodes.size() + diffIds.size());
                        nodes.addAll(affNodes);
                    }
                    nodes.add(n);
                }
            }
            ArrayList<ClusterNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClusterNode> nodes(int p, AffinityTopologyVersion topVer, GridDhtPartitionState state, GridDhtPartitionState ... states) {
        Collection<UUID> allIds = F.nodeIds(this.discoCache.cacheGroupAffinityNodes(this.grp.groupId()));
        this.lock.readLock().lock();
        try {
            assert (this.node2part != null && this.node2part.valid()) : "Invalid node-to-partitions map [topVer=" + topVer + ", grp=" + this.grp.cacheOrGroupName() + ", allIds=" + allIds + ", node2part=" + this.node2part + ']';
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(allIds.size() / 2 + 1);
            for (UUID id : allIds) {
                ClusterNode n;
                if (!this.hasState(p, id, state, states) || (n = this.ctx.discovery().node(id)) == null || topVer.topologyVersion() >= 0L && n.order() > topVer.topologyVersion()) continue;
                nodes.add(n);
            }
            ArrayList<ClusterNode> arrayList = nodes;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> owners(int p, AffinityTopologyVersion topVer) {
        if (!this.grp.rebalanceEnabled()) {
            return this.ownersAndMoving(p, topVer);
        }
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, null);
    }

    @Override
    public List<ClusterNode> owners(int p) {
        return this.owners(p, AffinityTopologyVersion.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<ClusterNode>> allOwners() {
        this.lock.readLock().lock();
        try {
            int parts = this.partitions();
            ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(parts);
            for (int i = 0; i < parts; ++i) {
                res.add(new ArrayList());
            }
            List<ClusterNode> allNodes = this.discoCache.cacheGroupAffinityNodes(this.grp.groupId());
            for (int i = 0; i < allNodes.size(); ++i) {
                ClusterNode node = allNodes.get(i);
                GridDhtPartitionMap nodeParts = (GridDhtPartitionMap)this.node2part.get(node.id());
                if (nodeParts == null) continue;
                for (Map.Entry<Integer, GridDhtPartitionState> e : nodeParts.map().entrySet()) {
                    if (e.getValue() != GridDhtPartitionState.OWNING) continue;
                    int part = e.getKey();
                    List owners = (List)res.get(part);
                    owners.add(node);
                }
            }
            ArrayList<List<ClusterNode>> arrayList = res;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<ClusterNode> moving(int p) {
        if (!this.grp.rebalanceEnabled()) {
            return this.ownersAndMoving(p, AffinityTopologyVersion.NONE);
        }
        return this.nodes(p, AffinityTopologyVersion.NONE, GridDhtPartitionState.MOVING, null);
    }

    private List<ClusterNode> ownersAndMoving(int p, AffinityTopologyVersion topVer) {
        return this.nodes(p, topVer, GridDhtPartitionState.OWNING, MOVING_STATES);
    }

    @Override
    public long updateSequence() {
        return this.updateSeq.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridDhtPartitionFullMap partitionMap(boolean onlyActive) {
        this.lock.readLock().lock();
        try {
            if (this.node2part == null || this.stopping) {
                GridDhtPartitionFullMap gridDhtPartitionFullMap = null;
                return gridDhtPartitionFullMap;
            }
            assert (this.node2part.valid()) : "Invalid node2part [node2part=" + this.node2part + ", grp=" + this.grp.cacheOrGroupName() + ", stopping=" + this.stopping + ", locNodeId=" + this.ctx.localNode().id() + ", locName=" + this.ctx.igniteInstanceName() + ']';
            GridDhtPartitionFullMap m = this.node2part;
            GridDhtPartitionFullMap gridDhtPartitionFullMap = new GridDhtPartitionFullMap(m.nodeId(), m.nodeOrder(), m.updateSequence(), m, onlyActive);
            return gridDhtPartitionFullMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean shouldOverridePartitionMap(GridDhtPartitionMap currentMap, GridDhtPartitionMap newMap) {
        return newMap != null && newMap.compareTo(currentMap) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(@Nullable AffinityTopologyVersion exchangeVer, GridDhtPartitionFullMap partMap, @Nullable CachePartitionFullCountersMap incomeCntrMap, Set<Integer> partsToReload, @Nullable Map<Integer, Long> partSizes, @Nullable AffinityTopologyVersion msgTopVer, @Nullable GridDhtPartitionsExchangeFuture exchFut, @Nullable Set<Integer> lostParts) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating full partition map [grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchangeVer + ", fullMap=" + this.fullMapString() + ']');
        }
        assert (partMap != null);
        this.ctx.database().checkpointReadLock();
        try {
            block54: {
                boolean fullMapUpdated;
                block53: {
                    int i;
                    block52: {
                        this.lock.writeLock().lock();
                        if (this.log.isTraceEnabled() && exchangeVer != null) {
                            this.log.trace("Partition states before full update [grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchangeVer + ", states=" + this.dumpPartitionStates() + ']');
                        }
                        if (!this.stopping && this.lastTopChangeVer.initialized() && (exchangeVer != null || this.lastTopChangeVer.equals(this.readyTopVer))) break block52;
                        boolean bl = false;
                        this.lock.writeLock().unlock();
                        return bl;
                    }
                    if (incomeCntrMap != null) {
                        for (i = 0; i < this.locParts.length(); i += 1) {
                            this.cntrMap.updateCounter(i, incomeCntrMap.updateCounter(i));
                            Iterator part = this.locParts.get(i);
                            if (part == null || ((GridDhtLocalPartition)((Object)part)).state() != GridDhtPartitionState.OWNING && ((GridDhtLocalPartition)((Object)part)).state() != GridDhtPartitionState.MOVING) continue;
                            long updCntr = incomeCntrMap.updateCounter(((GridDhtLocalPartition)((Object)part)).id());
                            long curCntr = ((GridDhtLocalPartition)((Object)part)).updateCounter();
                            if (updCntr == 0L && curCntr == 0L) continue;
                            ((GridDhtLocalPartition)((Object)part)).updateCounter(updCntr);
                            if (updCntr <= curCntr || !this.log.isDebugEnabled()) continue;
                            this.log.debug("Partition update counter has updated [grp=" + this.grp.cacheOrGroupName() + ", p=" + ((GridDhtLocalPartition)((Object)part)).id() + ", state=" + (Object)((Object)((GridDhtLocalPartition)((Object)part)).state()) + ", prevCntr=" + curCntr + ", nextCntr=" + updCntr + "]");
                        }
                    }
                    if (exchangeVer == null || !this.readyTopVer.after(exchangeVer) && !this.lastTopChangeVer.after(exchangeVer)) break block53;
                    U.warn(this.log, "Stale exchange id for full partition map update (will ignore) [grp=" + this.grp.cacheOrGroupName() + ", lastTopChange=" + this.lastTopChangeVer + ", readTopVer=" + this.readyTopVer + ", exchVer=" + exchangeVer + ']');
                    i = 0;
                    this.lock.writeLock().unlock();
                    return i != 0;
                }
                boolean bl = fullMapUpdated = this.node2part == null;
                if (this.node2part != null) {
                    GridDhtPartitionsExchangeFuture topFut;
                    for (GridDhtPartitionMap part : this.node2part.values()) {
                        GridDhtPartitionMap gridDhtPartitionMap;
                        if (this.shouldOverridePartitionMap(part, gridDhtPartitionMap = (GridDhtPartitionMap)partMap.get(part.nodeId()))) {
                            fullMapUpdated = true;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Overriding partition map in full update map [node=" + part.nodeId() + ", grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchangeVer + ", curPart=" + this.mapString(part) + ", newPart=" + this.mapString(gridDhtPartitionMap) + ']');
                            }
                            if (!gridDhtPartitionMap.nodeId().equals(this.ctx.localNodeId())) continue;
                            this.updateSeq.setIfGreater(gridDhtPartitionMap.updateSequence());
                            continue;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Partitions map for the node keeps newer value than message [node=" + part.nodeId() + ", grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchangeVer + ", curPart=" + this.mapString(part) + ", newPart=" + this.mapString(gridDhtPartitionMap) + ']');
                        }
                        partMap.put(part.nodeId(), part);
                    }
                    for (GridDhtPartitionMap part : partMap.values()) {
                        if (fullMapUpdated) break;
                        fullMapUpdated = !this.node2part.containsKey(part.nodeId());
                    }
                    GridDhtPartitionsExchangeFuture gridDhtPartitionsExchangeFuture = topFut = exchFut == null ? this.ctx.exchange().lastFinishedFuture() : exchFut;
                    if (topFut != null) {
                        Iterator it = partMap.keySet().iterator();
                        while (it.hasNext()) {
                            UUID uUID = (UUID)it.next();
                            ClusterNode node = topFut.events().discoveryCache().node(uUID);
                            if (node != null) continue;
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Removing left node from full map update [grp=" + this.grp.cacheOrGroupName() + ", exchTopVer=" + exchangeVer + ", futVer=" + topFut.initialVersion() + ", nodeId=" + uUID + ", partMap=" + partMap + ']');
                            }
                            it.remove();
                        }
                    }
                } else {
                    GridDhtPartitionMap locNodeMap = (GridDhtPartitionMap)partMap.get(this.ctx.localNodeId());
                    if (locNodeMap != null) {
                        this.updateSeq.setIfGreater(locNodeMap.updateSequence());
                    }
                }
                if (fullMapUpdated) break block54;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("No updates for full partition map (will ignore) [grp=" + this.grp.cacheOrGroupName() + ", lastExch=" + this.lastTopChangeVer + ", exchVer=" + exchangeVer + ", curMap=" + this.node2part + ", newMap=" + partMap + ']');
                }
                boolean locNodeMap = false;
                this.lock.writeLock().unlock();
                return locNodeMap;
            }
            try {
                if (exchangeVer != null) {
                    assert (exchangeVer.compareTo(this.readyTopVer) >= 0 && exchangeVer.compareTo(this.lastTopChangeVer) >= 0);
                    this.lastTopChangeVer = this.readyTopVer = exchangeVer;
                    if (lostParts != null) {
                        this.lostParts = new HashSet<Integer>(lostParts);
                        for (Integer part : lostParts) {
                            GridDhtLocalPartition gridDhtLocalPartition = this.localPartition(part);
                            if (gridDhtLocalPartition == null || gridDhtLocalPartition.state() == GridDhtPartitionState.EVICTED) continue;
                            gridDhtLocalPartition.markLost();
                            GridDhtPartitionMap locMap = (GridDhtPartitionMap)partMap.get(this.ctx.localNodeId());
                            locMap.put(part, GridDhtPartitionState.LOST);
                        }
                    }
                }
                this.node2part = partMap;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map after processFullMessage [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + (exchFut == null ? null : exchFut.exchangeId()) + ", fullMap=" + this.fullMapString() + ']');
                }
                if (exchangeVer == null && !this.grp.isReplicated() && this.readyTopVer.initialized() && this.readyTopVer.compareTo(this.diffFromAffinityVer) >= 0) {
                    AffinityAssignment affAssignment = this.grp.affinity().readyAffinity(this.readyTopVer);
                    for (Map.Entry entry : partMap.entrySet()) {
                        for (Map.Entry<Integer, GridDhtPartitionState> e0 : ((GridDhtPartitionMap)entry.getValue()).entrySet()) {
                            int p = e0.getKey();
                            Set<UUID> diffIds = this.diffFromAffinity.get(p);
                            if (!(e0.getValue() != GridDhtPartitionState.MOVING && e0.getValue() != GridDhtPartitionState.OWNING && e0.getValue() != GridDhtPartitionState.RENTING || affAssignment.getIds(p).contains(entry.getKey()))) {
                                if (diffIds == null) {
                                    diffIds = U.newHashSet(3);
                                    this.diffFromAffinity.put(p, diffIds);
                                }
                                diffIds.add((UUID)entry.getKey());
                                continue;
                            }
                            if (diffIds == null || !diffIds.remove(entry.getKey()) || !diffIds.isEmpty()) continue;
                            this.diffFromAffinity.remove(p);
                        }
                    }
                    this.diffFromAffinityVer = this.readyTopVer;
                }
                boolean changed = false;
                GridDhtPartitionMap nodeMap = (GridDhtPartitionMap)partMap.get(this.ctx.localNodeId());
                if (exchangeVer != null && nodeMap != null && this.grp.persistenceEnabled() && this.readyTopVer.initialized()) {
                    assert (exchFut != null);
                    for (Map.Entry<Integer, GridDhtPartitionState> e : nodeMap.entrySet()) {
                        GridDhtLocalPartition locPart;
                        int p = e.getKey();
                        GridDhtPartitionState state = e.getValue();
                        if (state == GridDhtPartitionState.OWNING) {
                            locPart = this.locParts.get(p);
                            assert (locPart != null) : this.grp.cacheOrGroupName();
                            if (locPart.state() != GridDhtPartitionState.MOVING) continue;
                            boolean success = locPart.own();
                            assert (success) : locPart;
                            changed |= success;
                            continue;
                        }
                        if (state != GridDhtPartitionState.MOVING) continue;
                        locPart = this.locParts.get(p);
                        this.rebalancePartition(p, partsToReload.contains(p) || locPart != null && locPart.state() == GridDhtPartitionState.MOVING && exchFut.localJoinExchange(), exchFut);
                        changed = true;
                    }
                }
                long l = this.updateSeq.incrementAndGet();
                if (this.readyTopVer.initialized() && this.readyTopVer.equals(this.lastTopChangeVer)) {
                    AffinityAssignment aff = this.grp.affinity().readyAffinity(this.readyTopVer);
                    if (exchangeVer == null) {
                        changed |= this.checkEvictions(l, aff);
                    }
                    this.updateRebalanceVersion(aff.topologyVersion(), aff.assignment());
                }
                if (partSizes != null) {
                    this.globalPartSizes = partSizes;
                }
                this.consistencyCheck();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map after full update [grp=" + this.grp.cacheOrGroupName() + ", map=" + this.fullMapString() + ']');
                }
                if (this.log.isTraceEnabled() && exchangeVer != null) {
                    this.log.trace("Partition states after full update [grp=" + this.grp.cacheOrGroupName() + ", exchVer=" + exchangeVer + ", states=" + this.dumpPartitionStates() + ']');
                }
                if (changed) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partitions have been scheduled to resend [reason=Full map update [grp" + this.grp.cacheOrGroupName() + "]");
                    }
                    this.ctx.exchange().scheduleResendPartitions();
                }
                boolean bl = changed;
                this.lock.writeLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectUpdateCounters(CachePartitionPartialCountersMap cntrMap) {
        assert (cntrMap != null);
        long nowNanos = System.nanoTime();
        this.lock.writeLock().lock();
        try {
            long acquiredNanos = System.nanoTime();
            if (acquiredNanos - nowNanos >= U.millisToNanos(100L) && this.timeLog.isInfoEnabled()) {
                this.timeLog.info("Waited too long to acquire topology write lock [grp=" + this.grp.cacheOrGroupName() + ", waitTime=" + U.nanosToMillis(acquiredNanos - nowNanos) + ']');
            }
            if (this.stopping) {
                return;
            }
            for (int i = 0; i < cntrMap.size(); ++i) {
                int pId = cntrMap.partitionAt(i);
                long initialUpdateCntr = cntrMap.initialUpdateCounterAt(i);
                long updateCntr = cntrMap.updateCounterAt(i);
                if (this.cntrMap.updateCounter(pId) >= updateCntr) continue;
                this.cntrMap.initialUpdateCounter(pId, initialUpdateCntr);
                this.cntrMap.updateCounter(pId, updateCntr);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyUpdateCounters() {
        long nowNanos = System.nanoTime();
        this.lock.writeLock().lock();
        try {
            long acquiredNanos = System.nanoTime();
            if (acquiredNanos - nowNanos >= U.millisToNanos(100L) && this.timeLog.isInfoEnabled()) {
                this.timeLog.info("Waited too long to acquire topology write lock [grp=" + this.grp.cacheOrGroupName() + ", waitTime=" + U.nanosToMillis(acquiredNanos - nowNanos) + ']');
            }
            if (this.stopping) {
                return;
            }
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                boolean reserve = part.reserve();
                try {
                    GridDhtPartitionState state = part.state();
                    if (!reserve || state == GridDhtPartitionState.EVICTED || state == GridDhtPartitionState.RENTING || state == GridDhtPartitionState.LOST) continue;
                    long updCntr = this.cntrMap.updateCounter(part.id());
                    long locUpdCntr = part.updateCounter();
                    if (updCntr != 0L || locUpdCntr != 0L) {
                        part.updateCounter(updCntr);
                        if (updCntr > locUpdCntr && this.log.isDebugEnabled()) {
                            this.log.debug("Partition update counter has updated [grp=" + this.grp.cacheOrGroupName() + ", p=" + part.id() + ", state=" + (Object)((Object)part.state()) + ", prevCntr=" + locUpdCntr + ", nextCntr=" + updCntr + "]");
                        }
                    }
                    if (locUpdCntr <= updCntr) continue;
                    this.cntrMap.initialUpdateCounter(part.id(), part.initialUpdateCounter());
                    this.cntrMap.updateCounter(part.id(), locUpdCntr);
                    continue;
                }
                finally {
                    if (reserve) {
                        part.release();
                    }
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean isStaleUpdate(GridDhtPartitionMap currentMap, GridDhtPartitionMap newMap) {
        return currentMap != null && newMap.compareTo(currentMap) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionMap parts, boolean force) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Updating single partition map [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchId + ", parts=" + this.mapString(parts) + ']');
        }
        if (!this.ctx.discovery().alive(parts.nodeId())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Received partition update for non-existing node (will ignore) [grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchId + ", parts=" + parts + ']');
            }
            return false;
        }
        this.ctx.database().checkpointReadLock();
        try {
            GridDhtPartitionMap cur;
            block36: {
                block35: {
                    block34: {
                        this.lock.writeLock().lock();
                        if (!this.stopping) break block34;
                        boolean bl = false;
                        this.lock.writeLock().unlock();
                        return bl;
                    }
                    if (force || !this.lastTopChangeVer.initialized() || exchId == null || this.lastTopChangeVer.compareTo(exchId.topologyVersion()) <= 0) break block35;
                    U.warn(this.log, "Stale exchange id for single partition map update (will ignore) [grp=" + this.grp.cacheOrGroupName() + ", lastTopChange=" + this.lastTopChangeVer + ", readTopVer=" + this.readyTopVer + ", exch=" + exchId.topologyVersion() + ']');
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
                if (this.node2part == null) {
                    this.node2part = new GridDhtPartitionFullMap();
                }
                cur = (GridDhtPartitionMap)this.node2part.get(parts.nodeId());
                if (force) {
                    if (cur != null && cur.topologyVersion().initialized()) {
                        parts.updateSequence(cur.updateSequence(), cur.topologyVersion());
                    }
                    break block36;
                }
                if (!this.isStaleUpdate(cur, parts)) break block36;
                assert (cur != null);
                String msg = "Stale update for single partition map update (will ignore) [nodeId=" + parts.nodeId() + ", grp=" + this.grp.cacheOrGroupName() + ", exchId=" + exchId + ", curMap=" + cur + ", newMap=" + parts + ']';
                if (cur.compareTo(parts) == 0) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(msg);
                    }
                } else {
                    U.warn(this.log, msg);
                }
                boolean bl = false;
                this.lock.writeLock().unlock();
                return bl;
            }
            try {
                long updateSeq = this.updateSeq.incrementAndGet();
                this.node2part.newUpdateSequence(updateSeq);
                boolean changed = false;
                if (cur == null || !cur.equals(parts)) {
                    changed = true;
                }
                this.node2part.put(parts.nodeId(), parts);
                if (exchId == null && !this.grp.isReplicated() && this.readyTopVer.initialized() && this.readyTopVer.compareTo(this.diffFromAffinityVer) >= 0) {
                    AffinityAssignment affAssignment = this.grp.affinity().readyAffinity(this.readyTopVer);
                    for (Map.Entry<Integer, GridDhtPartitionState> e : parts.entrySet()) {
                        int p = e.getKey();
                        Set<UUID> diffIds = this.diffFromAffinity.get(p);
                        if (!(e.getValue() != GridDhtPartitionState.MOVING && e.getValue() != GridDhtPartitionState.OWNING && e.getValue() != GridDhtPartitionState.RENTING || affAssignment.getIds(p).contains(parts.nodeId()))) {
                            if (diffIds == null) {
                                diffIds = U.newHashSet(3);
                                this.diffFromAffinity.put(p, diffIds);
                            }
                            if (!diffIds.add(parts.nodeId())) continue;
                            changed = true;
                            continue;
                        }
                        if (diffIds == null || !diffIds.remove(parts.nodeId())) continue;
                        changed = true;
                        if (!diffIds.isEmpty()) continue;
                        this.diffFromAffinity.remove(p);
                    }
                    if (cur != null) {
                        for (Integer p : F.view(cur.keySet(), F0.notIn(parts.keySet()))) {
                            Set<UUID> ids = this.diffFromAffinity.get(p);
                            if (ids == null || !ids.remove(parts.nodeId())) continue;
                            changed = true;
                            if (!ids.isEmpty()) continue;
                            this.diffFromAffinity.remove(p);
                        }
                    }
                    this.diffFromAffinityVer = this.readyTopVer;
                }
                if (this.readyTopVer.initialized() && this.readyTopVer.equals(this.lastTopChangeVer)) {
                    AffinityAssignment aff = this.grp.affinity().readyAffinity(this.readyTopVer);
                    if (exchId == null) {
                        changed |= this.checkEvictions(updateSeq, aff);
                    }
                    this.updateRebalanceVersion(aff.topologyVersion(), aff.assignment());
                }
                this.consistencyCheck();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition map after single update [grp=" + this.grp.cacheOrGroupName() + ", map=" + this.fullMapString() + ']');
                }
                if (changed && exchId == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partitions have been scheduled to resend [reason=Single map update [grp" + this.grp.cacheOrGroupName() + "]");
                    }
                    this.ctx.exchange().scheduleResendPartitions();
                }
                boolean bl = changed;
                this.lock.writeLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExchangeDone(@Nullable GridDhtPartitionsExchangeFuture fut, AffinityAssignment assignment, boolean updateRebalanceVer) {
        this.lock.writeLock().lock();
        try {
            assert (!(this.topReadyFut instanceof GridDhtPartitionsExchangeFuture) || assignment.topologyVersion().equals(((GridDhtPartitionsExchangeFuture)this.topReadyFut).context().events().topologyVersion()));
            this.readyTopVer = this.lastTopChangeVer = assignment.topologyVersion();
            if (fut != null) {
                this.discoCache = fut.events().discoveryCache();
            }
            if (!this.grp.isReplicated()) {
                boolean rebuildDiff;
                boolean bl = rebuildDiff = fut == null || fut.localJoinExchange() || fut.serverNodeDiscoveryEvent() || fut.firstEvent().type() == 18 || !this.diffFromAffinityVer.initialized();
                if (rebuildDiff) {
                    if (assignment.topologyVersion().compareTo(this.diffFromAffinityVer) >= 0) {
                        this.rebuildDiff(assignment);
                    }
                } else {
                    this.diffFromAffinityVer = this.readyTopVer;
                }
                if (!updateRebalanceVer) {
                    this.updateRebalanceVersion(assignment.topologyVersion(), assignment.assignment());
                }
            }
            if (updateRebalanceVer) {
                this.updateRebalanceVersion(assignment.topologyVersion(), assignment.assignment());
            }
            if (fut != null && (fut.events().hasServerJoin() || fut.changedBaseline())) {
                this.ownOrphans();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void ownOrphans() {
        for (int p = 0; p < this.grp.affinity().partitions(); ++p) {
            GridDhtLocalPartition locPart;
            boolean hasOwner = false;
            for (GridDhtPartitionMap map : this.node2part.values()) {
                if (map.get(p) != GridDhtPartitionState.OWNING) continue;
                hasOwner = true;
                break;
            }
            if (hasOwner || (locPart = this.localPartition(p)) == null || locPart.state() == GridDhtPartitionState.EVICTED || locPart.state() == GridDhtPartitionState.LOST) continue;
            locPart.own();
            for (GridDhtPartitionMap map : this.node2part.values()) {
                if (map.get(p) == null) continue;
                map.put(p, GridDhtPartitionState.OWNING);
            }
        }
    }

    private void createMovingPartitions(AffinityAssignment aff) {
        for (Map.Entry e : this.node2part.entrySet()) {
            GridDhtPartitionMap map = (GridDhtPartitionMap)e.getValue();
            this.addMoving(map, aff.backupPartitions((UUID)e.getKey()));
            this.addMoving(map, aff.primaryPartitions((UUID)e.getKey()));
        }
    }

    private void addMoving(GridDhtPartitionMap map, Set<Integer> parts) {
        if (F.isEmpty(parts)) {
            return;
        }
        for (Integer p : parts) {
            GridDhtPartitionState state = map.get(p);
            if (state != null && state != GridDhtPartitionState.EVICTED) continue;
            map.put(p, GridDhtPartitionState.MOVING);
        }
    }

    private void rebuildDiff(AffinityAssignment affAssignment) {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (this.node2part == null) {
            return;
        }
        for (Map.Entry e : this.node2part.entrySet()) {
            UUID nodeId = (UUID)e.getKey();
            for (Map.Entry<Integer, GridDhtPartitionState> e0 : ((GridDhtPartitionMap)e.getValue()).entrySet()) {
                Integer p0 = e0.getKey();
                GridDhtPartitionState state = e0.getValue();
                Set<UUID> ids = this.diffFromAffinity.get(p0);
                if (!(state != GridDhtPartitionState.MOVING && state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.RENTING || affAssignment.getIds(p0).contains(nodeId))) {
                    if (ids == null) {
                        ids = U.newHashSet(3);
                        this.diffFromAffinity.put(p0, ids);
                    }
                    ids.add(nodeId);
                    continue;
                }
                if (ids == null) continue;
                ids.remove(nodeId);
            }
        }
        this.diffFromAffinityVer = affAssignment.topologyVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detectLostPartitions(AffinityTopologyVersion resTopVer, GridDhtPartitionsExchangeFuture fut) {
        this.ctx.database().checkpointReadLock();
        try {
            block22: {
                this.lock.writeLock().lock();
                if (this.node2part != null) break block22;
                boolean bl = false;
                this.lock.writeLock().unlock();
                return bl;
            }
            try {
                DiscoveryEvent discoEvt = fut.activateCluster() ? null : fut.firstEvent();
                GridClusterStateProcessor state = this.grp.shared().kernalContext().state();
                boolean isInMemoryCluster = CU.isInMemoryCluster(this.grp.shared().kernalContext().discovery().allNodes(), this.grp.shared().kernalContext().marshallerContext().jdkMarshaller(), U.resolveClassLoader(this.grp.shared().kernalContext().config()));
                boolean compatibleWithIgnorePlc = isInMemoryCluster && state.isBaselineAutoAdjustEnabled() && state.baselineAutoAdjustTimeout() == 0L;
                boolean safe = this.grp.config().getPartitionLossPolicy() != PartitionLossPolicy.IGNORE || !compatibleWithIgnorePlc;
                int parts = this.grp.affinity().partitions();
                HashSet<Integer> recentlyLost = null;
                boolean changed = false;
                for (int part = 0; part < parts; ++part) {
                    boolean lost = F.contains(this.lostParts, Integer.valueOf(part));
                    if (!lost) {
                        boolean hasOwner = false;
                        for (GridDhtPartitionMap gridDhtPartitionMap : this.node2part.values()) {
                            if (gridDhtPartitionMap.get(part) != GridDhtPartitionState.OWNING) continue;
                            hasOwner = true;
                            break;
                        }
                        if (!hasOwner) {
                            lost = true;
                            if (safe) {
                                if (this.lostParts == null) {
                                    this.lostParts = new TreeSet<Integer>();
                                }
                                this.lostParts.add(part);
                                if (discoEvt != null) {
                                    if (recentlyLost == null) {
                                        recentlyLost = new HashSet<Integer>();
                                    }
                                    recentlyLost.add(part);
                                    if (this.grp.eventRecordable(86)) {
                                        this.grp.addRebalanceEvent(part, 86, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
                                    }
                                }
                            }
                        }
                    }
                    if (!lost) continue;
                    GridDhtLocalPartition locPart = this.localPartition(part, resTopVer, false, true);
                    if (locPart != null) {
                        if (locPart.state() == GridDhtPartitionState.LOST) continue;
                        GridDhtPartitionState prevState = locPart.state();
                        boolean bl = changed = safe ? locPart.markLost() : locPart.own();
                        if (changed) {
                            long l = this.updateSeq.incrementAndGet();
                            this.updateLocal(locPart.id(), locPart.state(), l, resTopVer);
                            if (prevState == GridDhtPartitionState.MOVING) {
                                locPart.resetUpdateCounter();
                            }
                        }
                    }
                    for (Map.Entry entry : this.node2part.entrySet()) {
                        GridDhtPartitionState p0;
                        if (((UUID)entry.getKey()).equals(this.ctx.localNodeId()) || (p0 = ((GridDhtPartitionMap)entry.getValue()).get(part)) == null || p0 == GridDhtPartitionState.EVICTED) continue;
                        ((GridDhtPartitionMap)entry.getValue()).put(part, safe ? GridDhtPartitionState.LOST : GridDhtPartitionState.OWNING);
                    }
                }
                if (recentlyLost != null) {
                    U.warn(this.log, "Detected lost partitions" + (!safe ? " (will ignore)" : "") + " [grp=" + this.grp.cacheOrGroupName() + ", parts=" + S.compact(recentlyLost) + ", topVer=" + resTopVer + "]");
                }
                boolean bl = changed;
                this.lock.writeLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetLostPartitions(AffinityTopologyVersion resTopVer) {
        this.ctx.database().checkpointReadLock();
        try {
            this.lock.writeLock().lock();
            try {
                long updSeq = this.updateSeq.incrementAndGet();
                for (Map.Entry e : this.node2part.entrySet()) {
                    for (Map.Entry<Integer, GridDhtPartitionState> e0 : ((GridDhtPartitionMap)e.getValue()).entrySet()) {
                        boolean marked;
                        if (e0.getValue() != GridDhtPartitionState.LOST) continue;
                        e0.setValue(GridDhtPartitionState.OWNING);
                        GridDhtLocalPartition locPart = this.localPartition(e0.getKey(), resTopVer, false);
                        if (locPart == null || locPart.state() != GridDhtPartitionState.LOST || !(marked = locPart.own())) continue;
                        this.updateLocal(locPart.id(), locPart.state(), updSeq, resTopVer);
                        locPart.resetInitialUpdateCounter();
                    }
                }
                this.lostParts = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    @Override
    public Set<Integer> lostPartitions() {
        this.lock.readLock().lock();
        try {
            HashSet<Integer> hashSet = this.lostParts == null ? Collections.emptySet() : new HashSet<Integer>(this.lostParts);
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Set<Integer>> resetOwners(Map<Integer, Set<UUID>> ownersByUpdCounters, Set<Integer> haveHist, GridDhtPartitionsExchangeFuture exchFut) {
        HashMap<UUID, Set<Integer>> res = new HashMap<UUID, Set<Integer>>();
        Collection<DiscoveryEvent> evts = exchFut.events().events();
        HashSet joinedNodes = U.newHashSet(evts.size());
        for (DiscoveryEvent evt : evts) {
            if (evt.type() != 10) continue;
            joinedNodes.add(evt.eventNode().id());
        }
        this.ctx.database().checkpointReadLock();
        try {
            HashMap<UUID, HashSet<UUID>> addToWaitGroups = new HashMap<UUID, HashSet<UUID>>();
            this.lock.writeLock().lock();
            try {
                int part;
                UUID locNodeId = this.ctx.localNodeId();
                for (Map.Entry<Integer, Set<UUID>> entry : ownersByUpdCounters.entrySet()) {
                    part = entry.getKey();
                    Set<UUID> set = entry.getValue();
                    GridDhtLocalPartition locPart = this.localPartition(part);
                    if (locPart == null || locPart.state() != GridDhtPartitionState.OWNING || !joinedNodes.isEmpty() || set.contains(locNodeId)) continue;
                    this.rebalancePartition(part, !haveHist.contains(part), exchFut);
                    res.computeIfAbsent(locNodeId, n -> new HashSet()).add(part);
                }
                for (Map.Entry<Integer, Set<UUID>> entry : ownersByUpdCounters.entrySet()) {
                    part = entry.getKey();
                    Set<UUID> set = entry.getValue();
                    for (Map.Entry entry2 : this.node2part.entrySet()) {
                        GridDhtPartitionMap partMap;
                        GridDhtPartitionState state;
                        UUID remoteNodeId = (UUID)entry2.getKey();
                        if (!joinedNodes.isEmpty() && !joinedNodes.contains(remoteNodeId) || (state = (partMap = (GridDhtPartitionMap)entry2.getValue()).get(part)) != GridDhtPartitionState.OWNING || set.contains(remoteNodeId)) continue;
                        partMap.put(part, GridDhtPartitionState.MOVING);
                        partMap.updateSequence(partMap.updateSequence() + 1L, partMap.topologyVersion());
                        if (partMap.nodeId().equals(locNodeId)) {
                            this.updateSeq.setIfGreater(partMap.updateSequence());
                        }
                        res.computeIfAbsent(remoteNodeId, n -> new HashSet()).add(part);
                    }
                }
                for (Map.Entry<Integer, Set<UUID>> entry : res.entrySet()) {
                    UUID nodeId = (UUID)((Object)entry.getKey());
                    Set<UUID> set = entry.getValue();
                    addToWaitGroups.put(nodeId, new HashSet<UUID>(set));
                    if (set.isEmpty()) continue;
                    Set<Integer> historical = set.stream().filter(haveHist::contains).collect(Collectors.toSet());
                    set.removeAll(historical);
                    U.warn(this.log, "Partitions have been scheduled for rebalancing due to outdated update counter [grp=" + this.grp.cacheOrGroupName() + ", readyTopVer=" + this.readyTopVer + ", topVer=" + exchFut.initialVersion() + ", nodeId=" + nodeId + ", partsFull=" + S.compact(set) + ", partsHistorical=" + S.compact(historical) + "]");
                }
                this.node2part = new GridDhtPartitionFullMap(this.node2part, this.updateSeq.incrementAndGet());
            }
            finally {
                this.lock.writeLock().unlock();
            }
            List<List<ClusterNode>> ideal = this.ctx.affinity().affinity(this.groupId()).idealAssignmentRaw();
            for (Map.Entry<Integer, Set<UUID>> entry : addToWaitGroups.entrySet()) {
                for (Integer n2 : entry.getValue()) {
                    this.ctx.cache().context().affinity().addToWaitGroup(this.groupId(), n2, this.topologyVersionFuture().initialVersion(), ideal.get(n2));
                }
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
        return res;
    }

    private GridDhtLocalPartition rebalancePartition(int p, boolean clear, GridDhtPartitionsExchangeFuture exchFut) {
        GridDhtLocalPartition part = this.getOrCreatePartition(p);
        if (part.state() == GridDhtPartitionState.LOST) {
            return part;
        }
        if (part.state() == GridDhtPartitionState.RENTING && !part.moving()) {
            assert (part.state() == GridDhtPartitionState.EVICTED) : part;
            part = this.getOrCreatePartition(p);
            if (part.state() == GridDhtPartitionState.LOST) {
                return part;
            }
        }
        if (part.state() != GridDhtPartitionState.MOVING) {
            part.moving();
        }
        if (clear) {
            exchFut.addClearingPartition(this.grp, part.id());
        }
        assert (part.state() == GridDhtPartitionState.MOVING) : part;
        return part;
    }

    private boolean checkEvictions(long updateSeq, AffinityAssignment aff) {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (!this.ctx.kernalContext().state().evictionsAllowed()) {
            return false;
        }
        boolean hasEvictedPartitions = false;
        UUID locId = this.ctx.localNodeId();
        block0: for (int p = 0; p < this.locParts.length(); ++p) {
            int affCnt;
            List<ClusterNode> affNodes;
            GridDhtLocalPartition part = this.locParts.get(p);
            if (part == null || !part.state().active() || (affNodes = aff.get(p)).contains(this.ctx.localNode())) continue;
            List<ClusterNode> nodes = this.nodes(p, aff.topologyVersion(), GridDhtPartitionState.OWNING, new GridDhtPartitionState[0]);
            Collection<UUID> nodeIds = F.nodeIds(nodes);
            if (nodeIds.containsAll(F.nodeIds(affNodes))) {
                GridDhtPartitionState state0 = part.state();
                part.rent();
                updateSeq = this.updateLocal(part.id(), part.state(), updateSeq, aff.topologyVersion());
                boolean stateChanged = state0 != part.state();
                hasEvictedPartitions |= stateChanged;
                if (!stateChanged || !this.log.isDebugEnabled()) continue;
                this.log.debug("Partition has been scheduled for eviction (all affinity nodes are owners) [grp=" + this.grp.cacheOrGroupName() + ", p=" + part.id() + ", prevState=" + (Object)((Object)state0) + ", state=" + (Object)((Object)part.state()) + "]");
                continue;
            }
            int ownerCnt = nodeIds.size();
            if (ownerCnt <= (affCnt = affNodes.size())) continue;
            Collections.sort(nodes, CU.nodeComparator(true));
            int diff = nodes.size() - affCnt;
            for (int i = 0; i < diff; ++i) {
                ClusterNode n = nodes.get(i);
                if (!locId.equals(n.id())) continue;
                GridDhtPartitionState state0 = part.state();
                part.rent();
                updateSeq = this.updateLocal(part.id(), part.state(), updateSeq, aff.topologyVersion());
                boolean stateChanged = state0 != part.state();
                hasEvictedPartitions |= stateChanged;
                if (!stateChanged || !this.log.isDebugEnabled()) continue block0;
                this.log.debug("Partition has been scheduled for eviction (this node is oldest non-affinity node) [grp=" + this.grp.cacheOrGroupName() + ", p=" + part.id() + ", prevState=" + (Object)((Object)state0) + ", state=" + (Object)((Object)part.state()) + "]");
                continue block0;
            }
        }
        return hasEvictedPartitions;
    }

    private long updateLocal(int p, GridDhtPartitionState state, long updateSeq, AffinityTopologyVersion affVer) {
        long seq;
        assert (this.lock.isWriteLockedByCurrentThread());
        ClusterNode oldest = this.discoCache.oldestAliveServerNode();
        assert (oldest != null || this.ctx.kernalContext().clientNode());
        if (this.ctx.localNode().equals(oldest) && this.node2part != null && (seq = this.node2part.updateSequence()) != updateSeq) {
            if (seq > updateSeq) {
                long seq0 = this.updateSeq.get();
                if (seq0 < seq) {
                    boolean b = this.updateSeq.compareAndSet(seq0, seq + 1L);
                    assert (b) : "Invalid update sequence [updateSeq=" + updateSeq + ", grp=" + this.grp.cacheOrGroupName() + ", seq=" + seq + ", curUpdateSeq=" + this.updateSeq.get() + ", node2part=" + this.node2part.toFullString() + ']';
                    updateSeq = seq + 1L;
                } else {
                    updateSeq = seq;
                }
            }
            this.node2part.updateSequence(updateSeq);
        }
        if (this.node2part != null) {
            AffinityAssignment assignment;
            UUID locNodeId = this.ctx.localNodeId();
            GridDhtPartitionMap map = (GridDhtPartitionMap)this.node2part.get(locNodeId);
            if (map == null) {
                map = new GridDhtPartitionMap(locNodeId, updateSeq, affVer, GridPartitionStateMap.EMPTY, false);
                this.node2part.put(locNodeId, map);
            } else {
                map.updateSequence(updateSeq, affVer);
            }
            map.put(p, state);
            if (!(this.grp.isReplicated() || state != GridDhtPartitionState.MOVING && state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.RENTING || (assignment = this.grp.affinity().cachedAffinity(this.diffFromAffinityVer)).getIds(p).contains(this.ctx.localNodeId()))) {
                Set<UUID> diffIds = this.diffFromAffinity.get(p);
                if (diffIds == null) {
                    diffIds = U.newHashSet(3);
                    this.diffFromAffinity.put(p, diffIds);
                }
                diffIds.add(this.ctx.localNodeId());
            }
        }
        return updateSeq;
    }

    private void removeNode(UUID nodeId) {
        assert (nodeId != null);
        assert (this.lock.isWriteLockedByCurrentThread());
        ClusterNode oldest = this.discoCache.oldestAliveServerNode();
        assert (oldest != null || this.ctx.kernalContext().clientNode());
        ClusterNode loc = this.ctx.localNode();
        if (this.node2part != null) {
            this.node2part = loc.equals(oldest) && !this.node2part.nodeId().equals(loc.id()) ? new GridDhtPartitionFullMap(loc.id(), loc.order(), this.updateSeq.get(), this.node2part, false) : new GridDhtPartitionFullMap(this.node2part, this.node2part.updateSequence());
            GridDhtPartitionMap parts = (GridDhtPartitionMap)this.node2part.remove(nodeId);
            if (!this.grp.isReplicated() && parts != null) {
                for (Integer p : parts.keySet()) {
                    Set<UUID> diffIds = this.diffFromAffinity.get(p);
                    if (diffIds == null) continue;
                    diffIds.remove(nodeId);
                }
            }
            this.consistencyCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean own(GridDhtLocalPartition part) {
        this.lock.writeLock().lock();
        try {
            if (part.own()) {
                assert (this.lastTopChangeVer.initialized()) : this.lastTopChangeVer;
                long updSeq = this.updateSeq.incrementAndGet();
                this.updateLocal(part.id(), part.state(), updSeq, this.lastTopChangeVer);
                this.consistencyCheck();
                boolean bl = true;
                return bl;
            }
            this.consistencyCheck();
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ownMoving() {
        this.ctx.database().checkpointReadLock();
        try {
            this.lock.writeLock().lock();
            try {
                for (GridDhtLocalPartition locPart : this.currentLocalPartitions()) {
                    if (locPart.state() != GridDhtPartitionState.MOVING) continue;
                    boolean reserved = locPart.reserve();
                    try {
                        if (!reserved || locPart.state() != GridDhtPartitionState.MOVING) continue;
                        this.own(locPart);
                    }
                    finally {
                        if (!reserved) continue;
                        locPart.release();
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryFinishEviction(GridDhtLocalPartition part) {
        this.ctx.database().checkpointReadLock();
        try {
            block16: {
                block15: {
                    this.lock.writeLock().lock();
                    if (!this.stopping) break block15;
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
                part.finishEviction();
                if (part.state() == GridDhtPartitionState.EVICTED) break block16;
                boolean bl = false;
                this.lock.writeLock().unlock();
                return bl;
            }
            try {
                long seq = this.updateSeq.incrementAndGet();
                assert (this.lastTopChangeVer.initialized()) : this.lastTopChangeVer;
                this.updateLocal(part.id(), part.state(), seq, this.lastTopChangeVer);
                this.consistencyCheck();
                this.grp.onPartitionEvicted(part.id());
                try {
                    this.grp.offheap().destroyCacheDataStore(part.dataStore());
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Unable to destroy cache data store on partition eviction [id=" + part.id() + "]", e);
                }
                part.clearDeferredDeletes();
                List<GridDhtLocalPartition> parts = this.localPartitions();
                boolean renting = false;
                for (GridDhtLocalPartition part0 : parts) {
                    if (part0.state() != GridDhtPartitionState.RENTING) continue;
                    renting = true;
                    break;
                }
                if (!renting) {
                    this.ctx.exchange().scheduleResendPartitions();
                }
                boolean bl = true;
                this.lock.writeLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    @Override
    @Nullable
    public GridDhtPartitionMap partitions(UUID nodeId) {
        this.lock.readLock().lock();
        try {
            GridDhtPartitionMap gridDhtPartitionMap = (GridDhtPartitionMap)this.node2part.get(nodeId);
            return gridDhtPartitionMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeUpdateCounters(Set<Integer> parts) {
        this.ctx.database().checkpointReadLock();
        try {
            WALPointer ptr = null;
            this.lock.readLock().lock();
            try {
                for (int p : parts) {
                    GridDhtLocalPartition part = this.locParts.get(p);
                    if (part == null || !part.state().active()) continue;
                    AffinityTopologyVersion topVer = this.ctx.exchange().readyAffinityVersion();
                    GridLongList gaps = part.finalizeUpdateCounters();
                    if (gaps == null) continue;
                    for (int j = 0; j < gaps.size() / 2; ++j) {
                        long gapStart = gaps.get(j * 2);
                        long gapStop = gaps.get(j * 2 + 1);
                        if (!part.group().persistenceEnabled() || !part.group().walEnabled() || part.group().mvccEnabled()) continue;
                        RollbackRecord rec = new RollbackRecord(part.group().groupId(), part.id(), gapStart - 1L, gapStop - gapStart + 1L);
                        try {
                            ptr = this.ctx.wal().log(rec);
                            continue;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    }
                    for (GridCacheContext ctx0 : this.grp.caches()) {
                        ctx0.continuousQueries().closeBackupUpdateCountersGaps(ctx0, part.id(), topVer, gaps);
                    }
                }
            }
            finally {
                try {
                    if (ptr != null) {
                        this.ctx.wal().flush(ptr, false);
                    }
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    @Override
    public CachePartitionFullCountersMap fullUpdateCounters() {
        this.lock.readLock().lock();
        try {
            CachePartitionFullCountersMap cachePartitionFullCountersMap = new CachePartitionFullCountersMap(this.cntrMap);
            return cachePartitionFullCountersMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachePartitionPartialCountersMap localUpdateCounters(boolean skipZeros) {
        this.lock.readLock().lock();
        try {
            int locPartCnt = 0;
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                ++locPartCnt;
            }
            CachePartitionPartialCountersMap res = new CachePartitionPartialCountersMap(locPartCnt);
            for (int i = 0; i < this.locParts.length(); ++i) {
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null) continue;
                long initCntr = part.initialUpdateCounter();
                long updCntr = part.updateCounter();
                if (skipZeros && initCntr == 0L && updCntr == 0L) continue;
                res.add(part.id(), initCntr, updCntr);
            }
            res.trim();
            CachePartitionPartialCountersMap cachePartitionPartialCountersMap = res;
            return cachePartitionPartialCountersMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Long> partitionSizes() {
        this.lock.readLock().lock();
        try {
            HashMap<Integer, Long> partitionSizes = new HashMap<Integer, Long>();
            for (int p = 0; p < this.locParts.length(); ++p) {
                GridDhtLocalPartition part = this.locParts.get(p);
                if (part == null || part.fullSize() == 0L) continue;
                partitionSizes.put(part.id(), part.fullSize());
            }
            HashMap<Integer, Long> hashMap = partitionSizes;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Map<Integer, Long> globalPartSizes() {
        this.lock.readLock().lock();
        try {
            if (this.globalPartSizes == null) {
                Map<Integer, Long> map = Collections.emptyMap();
                return map;
            }
            Map<Integer, Long> map = Collections.unmodifiableMap(this.globalPartSizes);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void globalPartSizes(@Nullable Map<Integer, Long> partSizes) {
        this.lock.writeLock().lock();
        try {
            this.globalPartSizes = partSizes;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean rebalanceFinished(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion curTopVer = this.readyTopVer;
        return curTopVer.equals(topVer) && curTopVer.equals(this.rebalancedTopVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMovingPartitions() {
        this.lock.readLock().lock();
        try {
            if (this.node2part == null) {
                boolean bl = false;
                return bl;
            }
            assert (this.node2part.valid()) : "Invalid node2part [node2part: " + this.node2part + ", grp=" + this.grp.cacheOrGroupName() + ", stopping=" + this.stopping + ", locNodeId=" + this.ctx.localNodeId() + ", locName=" + this.ctx.igniteInstanceName() + ']';
            for (GridDhtPartitionMap map : this.node2part.values()) {
                if (!map.hasMovingPartitions()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void onCacheStopped(int cacheId) {
        if (!this.grp.sharedGroup()) {
            return;
        }
        for (int i = 0; i < this.locParts.length(); ++i) {
            GridDhtLocalPartition part = this.locParts.get(i);
            if (part == null) continue;
            part.onCacheStopped(cacheId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printMemoryStats(int threshold) {
        X.println(">>>  Cache partition topology stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ']', new Object[0]);
        this.lock.readLock().lock();
        try {
            for (int i = 0; i < this.locParts.length(); ++i) {
                long size;
                GridDhtLocalPartition part = this.locParts.get(i);
                if (part == null || (size = part.dataStore().fullSize()) < (long)threshold) continue;
                X.println(">>>   Local partition [part=" + part.id() + ", size=" + size + ']', new Object[0]);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean localNode(int part, List<List<ClusterNode>> aff) {
        return aff.get(part).contains(this.ctx.localNode());
    }

    private void updateRebalanceVersion(AffinityTopologyVersion affVer, List<List<ClusterNode>> aff) {
        if (!this.grp.isReplicated() && !affVer.equals(this.diffFromAffinityVer)) {
            return;
        }
        if (!this.rebalancedTopVer.equals(this.readyTopVer)) {
            if (this.node2part == null || !this.node2part.valid()) {
                return;
            }
            for (int i = 0; i < this.grp.affinity().partitions(); ++i) {
                Set<UUID> diff;
                List<ClusterNode> affNodes = aff.get(i);
                if (affNodes.isEmpty()) continue;
                for (ClusterNode node : affNodes) {
                    if (this.hasState(i, node.id(), GridDhtPartitionState.OWNING, new GridDhtPartitionState[0])) continue;
                    return;
                }
                if (this.grp.isReplicated() || (diff = this.diffFromAffinity.get(i)) == null) continue;
                for (UUID nodeId : diff) {
                    ClusterNode node;
                    if (!this.hasState(i, nodeId, GridDhtPartitionState.OWNING, new GridDhtPartitionState[0]) || (node = this.ctx.discovery().node(nodeId)) == null || affNodes.contains(node)) continue;
                    return;
                }
            }
            this.rebalancedTopVer = this.readyTopVer;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Updated rebalanced version [grp=" + this.grp.cacheOrGroupName() + ", ver=" + this.rebalancedTopVer + ']');
            }
        }
    }

    private boolean hasState(int p, @Nullable UUID nodeId, GridDhtPartitionState match, GridDhtPartitionState ... matches) {
        if (nodeId == null) {
            return false;
        }
        GridDhtPartitionMap parts = (GridDhtPartitionMap)this.node2part.get(nodeId);
        if (parts != null) {
            GridDhtPartitionState state = parts.get(p);
            if (state == match) {
                return true;
            }
            if (matches != null && matches.length > 0) {
                for (GridDhtPartitionState s : matches) {
                    if (state != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rent(int p) {
        this.ctx.database().checkpointReadLock();
        try {
            GridDhtPartitionState state0;
            GridDhtLocalPartition locPart;
            block12: {
                block11: {
                    this.lock.writeLock().lock();
                    try {
                        if (!this.lastTopChangeVer.after(this.readyTopVer)) break block11;
                        boolean bl = false;
                        this.lock.writeLock().unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        this.lock.writeLock().unlock();
                        throw throwable;
                    }
                }
                locPart = this.localPartition(p);
                state0 = locPart.state();
                if (locPart != null && state0 != GridDhtPartitionState.RENTING && state0 != GridDhtPartitionState.EVICTED && !this.partitionLocalNode(p, this.readyTopVer)) break block12;
                boolean bl = false;
                this.lock.writeLock().unlock();
                return bl;
            }
            locPart.rent();
            GridDhtPartitionState state = locPart.state();
            if (state == GridDhtPartitionState.RENTING && state != state0) {
                long updateSeq = this.updateSeq.incrementAndGet();
                this.updateLocal(p, state0, updateSeq, this.readyTopVer);
                this.ctx.exchange().scheduleResendPartitions();
            }
            boolean bl = true;
            this.lock.writeLock().unlock();
            return bl;
        }
        finally {
            this.ctx.database().checkpointReadUnlock();
        }
    }

    private void consistencyCheck() {
    }

    private String dumpPartitionStates() {
        SB sb = new SB();
        for (int p = 0; p < this.locParts.length(); ++p) {
            GridDhtLocalPartition part = this.locParts.get(p);
            if (part == null) continue;
            sb.a("Part [");
            sb.a("id=" + part.id() + ", ");
            sb.a("state=" + (Object)((Object)part.state()) + ", ");
            sb.a("initCounter=" + part.initialUpdateCounter() + ", ");
            sb.a("updCounter=" + part.updateCounter() + ", ");
            sb.a("size=" + part.fullSize() + "] ");
        }
        return sb.toString();
    }

    public static interface PartitionFactory {
        public GridDhtLocalPartition create(GridCacheSharedContext var1, CacheGroupContext var2, int var3, boolean var4);
    }

    private class CurrentPartitionsIterator
    implements Iterator<GridDhtLocalPartition> {
        private int nextIdx;
        private GridDhtLocalPartition nextPart;

        private CurrentPartitionsIterator() {
            this.advance();
        }

        private void advance() {
            while (this.nextIdx < GridDhtPartitionTopologyImpl.this.locParts.length()) {
                GridDhtLocalPartition part = (GridDhtLocalPartition)GridDhtPartitionTopologyImpl.this.locParts.get(this.nextIdx);
                if (part != null && part.state().active()) {
                    this.nextPart = part;
                    return;
                }
                ++this.nextIdx;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextPart != null;
        }

        @Override
        public GridDhtLocalPartition next() {
            if (this.nextPart == null) {
                throw new NoSuchElementException();
            }
            GridDhtLocalPartition retVal = this.nextPart;
            this.nextPart = null;
            ++this.nextIdx;
            this.advance();
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

