/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.internal.U;

public class JdbcBlob
implements Blob {
    private byte[] arr;

    public JdbcBlob(byte[] arr) {
        this.arr = arr;
    }

    @Override
    public long length() throws SQLException {
        this.ensureNotClosed();
        return this.arr.length;
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || (long)this.arr.length - pos < 0L || len < 0) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than size of underlying byte array. Requested length also can't be negative [pos=" + pos + ", len=" + len + ']');
        }
        int idx = (int)(pos - 1L);
        int size = len > this.arr.length - idx ? this.arr.length - idx : len;
        byte[] res = new byte[size];
        U.arrayCopy(this.arr, idx, res, 0, size);
        return res;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.ensureNotClosed();
        return new ByteArrayInputStream(this.arr);
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L || len < 1L || pos > (long)this.arr.length || len > (long)this.arr.length - pos + 1L) {
            throw new SQLException("Invalid argument. Position can't be less than 1 or greater than size of underlying byte array. Requested length can't be negative and can't be greater than available bytes from given position [pos=" + pos + ", len=" + len + ']');
        }
        return new ByteArrayInputStream(this.arr, (int)(pos - 1L), (int)len);
    }

    @Override
    public long position(byte[] ptrn, long start) throws SQLException {
        this.ensureNotClosed();
        if (start < 1L || start > (long)this.arr.length || ptrn.length == 0 || ptrn.length > this.arr.length) {
            return -1L;
        }
        int i = 0;
        int pos = (int)(start - 1L);
        while (pos < this.arr.length) {
            if (this.arr[pos] == ptrn[i]) {
                ++pos;
                if (++i != ptrn.length) continue;
                return pos - ptrn.length + 1;
            }
            pos = pos - i + 1;
            i = 0;
        }
        return -1L;
    }

    @Override
    public long position(Blob ptrn, long start) throws SQLException {
        this.ensureNotClosed();
        if (start < 1L || start > (long)this.arr.length || ptrn.length() == 0L || ptrn.length() > (long)this.arr.length) {
            return -1L;
        }
        return this.position(ptrn.getBytes(1L, (int)ptrn.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int off, int len) throws SQLException {
        this.ensureNotClosed();
        if (pos < 1L) {
            throw new SQLException("Invalid argument. Position can't be less than 1 [pos=" + pos + ']');
        }
        int idx = (int)(pos - 1L);
        if (pos - 1L > (long)this.arr.length || off < 0 || off >= bytes.length || off + len > bytes.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] dst = this.arr;
        if (idx + len > this.arr.length) {
            dst = new byte[this.arr.length + (len - (this.arr.length - idx))];
            U.arrayCopy(this.arr, 0, dst, 0, idx);
            this.arr = dst;
        }
        U.arrayCopy(bytes, off, dst, idx, len);
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.ensureNotClosed();
        if (len < 0L || len > (long)this.arr.length) {
            throw new SQLException("Invalid argument. Length can't be less than zero or greater than Blob length [len=" + len + ']');
        }
        this.arr = Arrays.copyOf(this.arr, (int)len);
    }

    @Override
    public void free() throws SQLException {
        if (this.arr != null) {
            this.arr = null;
        }
    }

    private void ensureNotClosed() throws SQLException {
        if (this.arr == null) {
            throw new SQLException("Blob instance can't be used after free() has been called.");
        }
    }
}

