/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.sql;

import java.util.List;
import org.apache.ignite3.internal.cli.commands.sql.SqlMetaData;
import org.apache.ignite3.internal.cli.sql.SchemaProvider;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class SqlCompleter
implements Completer {
    private final SchemaProvider schemaProvider;

    SqlCompleter(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        if (commandLine.line().startsWith("help")) {
            return;
        }
        if (commandLine.wordIndex() == 0) {
            SqlCompleter.addCandidatesFromArray(SqlMetaData.STARTING_KEYWORDS, candidates);
        } else {
            this.fillCandidates(candidates);
        }
    }

    private void fillCandidates(List<Candidate> candidates) {
        this.addKeywords(candidates);
        for (String schema : this.schemaProvider.getSchema().schemas()) {
            SqlCompleter.addCandidate(schema, candidates);
            for (String table : this.schemaProvider.getSchema().tables(schema)) {
                SqlCompleter.addCandidate(table, candidates);
            }
        }
    }

    private void addKeywords(List<Candidate> candidates) {
        SqlCompleter.addCandidatesFromArray(SqlMetaData.KEYWORDS, candidates);
        SqlCompleter.addCandidatesFromArray(SqlMetaData.NUMERIC_FUNCTIONS, candidates);
        SqlCompleter.addCandidatesFromArray(SqlMetaData.STRING_FUNCTIONS, candidates);
        SqlCompleter.addCandidatesFromArray(SqlMetaData.TIME_DATE_FUNCTIONS, candidates);
        SqlCompleter.addCandidatesFromArray(SqlMetaData.SYSTEM_FUNCTIONS, candidates);
    }

    private static void addCandidatesFromArray(String[] strings, List<Candidate> candidates) {
        for (String keyword : strings) {
            SqlCompleter.addCandidate(keyword, candidates);
        }
    }

    private static void addCandidate(String string, List<Candidate> candidates) {
        candidates.add(new Candidate(string));
        candidates.add(new Candidate(string.toLowerCase()));
    }
}

