/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.ignite.configuration.ConfigurationListenOnlyException;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.internal.configuration.ConfigurationListenerHolder;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationNode<VIEWT>
implements ConfigurationProperty<VIEWT> {
    private final ConfigurationListenerHolder<ConfigurationListener<VIEWT>> updateListeners = new ConfigurationListenerHolder();
    protected final List<String> keys;
    protected final String key;
    protected final RootKey<?, ?> rootKey;
    protected final DynamicConfigurationChanger changer;
    protected final boolean listenOnly;
    private volatile TraversableTreeNode cachedRootNode;
    private VIEWT val;
    private boolean invalid;

    protected ConfigurationNode(List<String> keys, String key, RootKey<?, ?> rootKey, DynamicConfigurationChanger changer, boolean listenOnly) {
        this.keys = keys;
        this.key = key;
        this.rootKey = rootKey;
        this.changer = changer;
        this.listenOnly = listenOnly;
        assert (Objects.equals(rootKey.key(), keys.get(0)));
    }

    public void listen(ConfigurationListener<VIEWT> listener) {
        this.updateListeners.addListener(listener, this.changer.notificationCount());
    }

    public void stopListen(ConfigurationListener<VIEWT> listener) {
        this.updateListeners.removeListener(listener);
    }

    public Iterator<ConfigurationListener<VIEWT>> listeners(long notificationNumber) {
        return this.updateListeners.listeners(notificationNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final VIEWT refreshValue() throws NoSuchElementException {
        InnerNode newRootNode = this.changer.getRootNode(this.rootKey);
        TraversableTreeNode oldRootNode = this.cachedRootNode;
        if (this.invalid) {
            throw this.noSuchElementException();
        }
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        if (oldRootNode == newRootNode) {
            return this.val;
        }
        try {
            Object newVal = ConfigurationUtil.find(this.keys.subList(1, this.keys.size()), newRootNode, true).value();
            ConfigurationNode configurationNode = this;
            synchronized (configurationNode) {
                if (this.cachedRootNode == oldRootNode) {
                    this.beforeRefreshValue(newVal, this.val);
                    this.val = newVal;
                    this.cachedRootNode = newRootNode;
                    return (VIEWT)newVal;
                }
                if (this.invalid) {
                    throw this.noSuchElementException();
                }
                return this.val;
            }
        }
        catch (KeyNotFoundException e) {
            ConfigurationNode configurationNode = this;
            synchronized (configurationNode) {
                this.invalid = true;
                this.cachedRootNode = newRootNode;
            }
            throw this.noSuchElementException();
        }
    }

    private NoSuchElementException noSuchElementException() {
        return new NoSuchElementException(ConfigurationUtil.join(this.keys));
    }

    protected void beforeRefreshValue(VIEWT newValue, @Nullable VIEWT oldValue) {
    }

    protected final ConfigurationListenOnlyException listenOnlyException() {
        return new ConfigurationListenOnlyException("`any` configuration node can only be used for listeners [keys=" + String.valueOf(this.keys) + "]");
    }

    protected final List<KeyPathNode> keyPath() {
        if (this.listenOnly) {
            throw this.listenOnlyException();
        }
        ConfigurationVisitor<List<KeyPathNode>> visitor = new ConfigurationVisitor<List<KeyPathNode>>(){
            private List<KeyPathNode> res;
            private int idx;
            {
                this.res = new ArrayList<KeyPathNode>(ConfigurationNode.this.keys.size());
                this.idx = 1;
            }

            @Override
            @Nullable
            public List<KeyPathNode> visitLeafNode(Field field, String key, Serializable val) {
                this.res.add(new KeyPathNode(key));
                return this.res;
            }

            @Override
            @Nullable
            public List<KeyPathNode> visitInnerNode(Field field, String key, InnerNode node) {
                this.res.add(new KeyPathNode(key));
                if (ConfigurationNode.this.keys.size() == this.idx) {
                    return this.res;
                }
                node.traverseChild(ConfigurationNode.this.keys.get(this.idx++), this, true);
                return this.res;
            }

            @Override
            @Nullable
            public List<KeyPathNode> visitNamedListNode(Field field, String key, NamedListNode node) {
                InnerNode innerNode;
                this.res.add(new KeyPathNode(key));
                if (ConfigurationNode.this.keys.size() == this.idx) {
                    return this.res;
                }
                if ((innerNode = node.getInnerNode(ConfigurationNode.this.keys.get(this.idx++))) == null) {
                    throw ConfigurationNode.this.noSuchElementException();
                }
                this.res.add(new KeyPathNode(innerNode.internalId().toString(), false));
                if (ConfigurationNode.this.keys.size() == this.idx) {
                    return this.res;
                }
                innerNode.traverseChild(ConfigurationNode.this.keys.get(this.idx++), this, true);
                return this.res;
            }
        };
        return this.changer.getRootNode(this.rootKey).accept(null, this.keys.get(0), visitor);
    }

    @Nullable
    protected final VIEWT currentValue() {
        return this.val;
    }
}

