/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.MakeIndexAvailableEventParameters;
import org.apache.ignite.internal.catalog.storage.AbstractChangeIndexStatusEntry;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class MakeIndexAvailableEntry
extends AbstractChangeIndexStatusEntry
implements Fireable {
    public static final CatalogObjectSerializer<MakeIndexAvailableEntry> SERIALIZER = new MakeIndexAvailableEntrySerializer();

    public MakeIndexAvailableEntry(int indexId) {
        super(indexId, CatalogIndexStatus.AVAILABLE);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.MAKE_INDEX_AVAILABLE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_AVAILABLE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new MakeIndexAvailableEventParameters(causalityToken, catalogVersion, this.indexId);
    }

    private static class MakeIndexAvailableEntrySerializer
    implements CatalogObjectSerializer<MakeIndexAvailableEntry> {
        private MakeIndexAvailableEntrySerializer() {
        }

        @Override
        public MakeIndexAvailableEntry readFrom(IgniteDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            return new MakeIndexAvailableEntry(indexId);
        }

        @Override
        public void writeTo(MakeIndexAvailableEntry object, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)object.indexId);
        }
    }
}

