/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import org.apache.ignite.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.rocksdb.RocksIterator;

public abstract class BusyRocksIteratorAdapter<T>
extends RocksIteratorAdapter<T> {
    private final IgniteSpinBusyLock busyLock;

    protected BusyRocksIteratorAdapter(IgniteSpinBusyLock busyLock, RocksIterator it) {
        super(it);
        this.busyLock = busyLock;
    }

    protected abstract void handleBusy();

    private void handleBusy0() {
        this.handleBusy();
        assert (false) : "handleBusy() should have thrown an exception.";
    }

    @Override
    public boolean hasNext() {
        if (!this.busyLock.enterBusy()) {
            this.handleBusy0();
        }
        try {
            boolean bl = super.hasNext();
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public T next() {
        if (!this.busyLock.enterBusy()) {
            this.handleBusy0();
        }
        try {
            Object t = super.next();
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.busyLock.enterBusy()) {
            this.handleBusy0();
        }
        try {
            super.close();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

