/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.topology;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.cluster.topology.PhysicalTopologyCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.decorators.PlainTopologyDecorator;
import org.apache.ignite.internal.cli.decorators.TopologyDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="physical")
public class PhysicalTopologyReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @Inject
    private PhysicalTopologyCall call;
    @Inject
    private ConnectToClusterQuestion question;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting"})
    private boolean plain;

    @Override
    public void run() {
        TopologyDecorator topologyDecorator = this.plain ? new PlainTopologyDecorator() : new TopologyDecorator();
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.call)).print(topologyDecorator).start();
    }
}

