/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.FieldAccessor;
import org.apache.ignite.internal.util.GridUnsafe;

class UnsafeFieldAccessor
implements FieldAccessor {
    private final Field field;
    private final Class<?> fieldType;
    private final long fieldOffset;

    UnsafeFieldAccessor(Field field) {
        Objects.requireNonNull(field, "field is null");
        this.field = field;
        this.fieldType = field.getType();
        this.fieldOffset = GridUnsafe.objectFieldOffset((Field)field);
    }

    @Override
    public Object getObject(Object target) {
        assert (!this.fieldType.isPrimitive()) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is primitive!";
        return GridUnsafe.getObjectField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setObject(Object target, Object fieldValue) {
        assert (!this.fieldType.isPrimitive()) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is primitive!";
        GridUnsafe.putObjectField((Object)target, (long)this.fieldOffset, (Object)fieldValue);
    }

    @Override
    public byte getByte(Object target) {
        assert (this.fieldType == Byte.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not byte";
        return GridUnsafe.getByteField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setByte(Object target, byte fieldValue) {
        assert (this.fieldType == Byte.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not byte";
        GridUnsafe.putByteField((Object)target, (long)this.fieldOffset, (byte)fieldValue);
    }

    @Override
    public short getShort(Object target) {
        assert (this.fieldType == Short.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not short";
        return GridUnsafe.getShortField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setShort(Object target, short fieldValue) {
        assert (this.fieldType == Short.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not short";
        GridUnsafe.putShortField((Object)target, (long)this.fieldOffset, (short)fieldValue);
    }

    @Override
    public int getInt(Object target) {
        assert (this.fieldType == Integer.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not int";
        return GridUnsafe.getIntField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setInt(Object target, int fieldValue) {
        assert (this.fieldType == Integer.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not int";
        GridUnsafe.putIntField((Object)target, (long)this.fieldOffset, (int)fieldValue);
    }

    @Override
    public long getLong(Object target) {
        assert (this.fieldType == Long.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not long";
        return GridUnsafe.getLongField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setLong(Object target, long fieldValue) {
        assert (this.fieldType == Long.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not long";
        GridUnsafe.putLongField((Object)target, (long)this.fieldOffset, (long)fieldValue);
    }

    @Override
    public float getFloat(Object target) {
        assert (this.fieldType == Float.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not float";
        return GridUnsafe.getFloatField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setFloat(Object target, float fieldValue) {
        assert (this.fieldType == Float.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not float";
        GridUnsafe.putFloatField((Object)target, (long)this.fieldOffset, (float)fieldValue);
    }

    @Override
    public double getDouble(Object target) {
        assert (this.fieldType == Double.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not double";
        return GridUnsafe.getDoubleField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setDouble(Object target, double fieldValue) {
        assert (this.fieldType == Double.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not double";
        GridUnsafe.putDoubleField((Object)target, (long)this.fieldOffset, (double)fieldValue);
    }

    @Override
    public char getChar(Object target) {
        assert (this.fieldType == Character.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not char";
        return GridUnsafe.getCharField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setChar(Object target, char fieldValue) {
        assert (this.fieldType == Character.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not char";
        GridUnsafe.putCharField((Object)target, (long)this.fieldOffset, (char)fieldValue);
    }

    @Override
    public boolean getBoolean(Object target) {
        assert (this.fieldType == Boolean.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not boolean";
        return GridUnsafe.getBooleanField((Object)target, (long)this.fieldOffset);
    }

    @Override
    public void setBoolean(Object target, boolean fieldValue) {
        assert (this.fieldType == Boolean.TYPE) : this.field.getDeclaringClass() + "#" + this.field.getName() + " is not boolean";
        GridUnsafe.putBooleanField((Object)target, (long)this.fieldOffset, (boolean)fieldValue);
    }
}

