/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONAllocWriteIdMessage
extends AllocWriteIdMessage {
    @JsonProperty
    private String server;
    @JsonProperty
    private String servicePrincipal;
    @JsonProperty
    private String dbName;
    @JsonProperty
    private String tableName;
    @JsonProperty
    private List<Long> txnIdList;
    @JsonProperty
    private List<Long> writeIdList;
    @JsonProperty
    private Long timestamp;
    private List<TxnToWriteId> txnToWriteIdList;

    public JSONAllocWriteIdMessage() {
    }

    public JSONAllocWriteIdMessage(String server, String servicePrincipal, List<TxnToWriteId> txnToWriteIdList, String dbName, String tableName, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.timestamp = timestamp;
        this.txnIdList = new ArrayList<Long>();
        this.writeIdList = new ArrayList<Long>();
        for (TxnToWriteId txnToWriteId : txnToWriteIdList) {
            this.txnIdList.add(txnToWriteId.getTxnId());
            this.writeIdList.add(txnToWriteId.getWriteId());
        }
        this.tableName = tableName;
        this.dbName = dbName;
        this.txnToWriteIdList = txnToWriteIdList;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.dbName;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<TxnToWriteId> getTxnToWriteIdList() {
        if (this.txnToWriteIdList == null) {
            this.txnToWriteIdList = new ArrayList<TxnToWriteId>();
            for (int idx = 0; idx < this.txnIdList.size(); ++idx) {
                this.txnToWriteIdList.add(new TxnToWriteId(this.txnIdList.get(idx), this.writeIdList.get(idx)));
            }
        }
        return this.txnToWriteIdList;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

