/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.impl.BreakDetector;

public class BreakDetectorMappingContext<S>
extends MappingContext<S> {
    private final BreakDetector<S> rootDetector;
    private final MappingContext<S> delegateContext;
    private final BreakDetector<S>[] breakDetectors;

    public BreakDetectorMappingContext(KeyDefinition<S, ?> rootKeyDefinition, MappingContext<S> delegateContext, KeyDefinition<S, ?>[] keyDefinitions) {
        this.delegateContext = delegateContext;
        this.breakDetectors = BreakDetectorMappingContext.toBreakDetectors(keyDefinitions);
        this.rootDetector = this.breakDetectors[rootKeyDefinition.getIndex()];
    }

    private static <S> BreakDetector<S>[] toBreakDetectors(KeyDefinition<S, ?>[] definitions) {
        BreakDetector[] breakDetectors = new BreakDetector[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            KeyDefinition<S, ?> definition = definitions[i];
            breakDetectors[i] = new BreakDetector<S>(definition);
        }
        return breakDetectors;
    }

    @Override
    public boolean broke(S source) {
        boolean b = this.rootDetector.broke(source);
        if (b) {
            for (BreakDetector<S> breakDetector : this.breakDetectors) {
                if (breakDetector == this.rootDetector) continue;
                breakDetector.markRootAsBroken();
            }
        }
        for (BreakDetector<S> breakDetector : this.breakDetectors) {
            if (breakDetector == this.rootDetector) continue;
            breakDetector.handleSource(source);
        }
        return b;
    }

    @Override
    public void handleSource(S source) {
        for (BreakDetector<S> breakDetector : this.breakDetectors) {
            breakDetector.handleSource(source);
        }
    }

    @Override
    public void markAsBroken() {
        for (BreakDetector<S> breakDetector : this.breakDetectors) {
            breakDetector.markRootAsBroken();
        }
    }

    @Override
    public <T> T context(int i) {
        return this.delegateContext.context(i);
    }

    @Override
    public void setCurrentValue(int i, Object value) {
        this.breakDetectors[i].setValue(value);
    }

    @Override
    public Object getCurrentValue(int i) {
        return this.breakDetectors[i].getValue();
    }

    public BreakDetector<S> getRootDetector() {
        return this.rootDetector;
    }
}

