/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.BasicStatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.session.SessionState;

@Explain(displayName="Stats Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class StatsWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BasicStatsWork basicStatsWork;
    private BasicStatsNoJobWork basicStatsNoJobWork;
    private ColumnStatsDesc colStats;
    private static final int LIMIT = -1;
    private String currentDatabase;
    private boolean statsReliable;
    private Table table;
    private boolean truncate;
    private boolean footerScan;
    private Set<Partition> partitions = new HashSet<Partition>();

    public StatsWork(Table table, BasicStatsWork basicStatsWork, HiveConf hconf) {
        this.table = table;
        this.basicStatsWork = basicStatsWork;
        this.currentDatabase = SessionState.get().getCurrentDatabase();
        this.statsReliable = hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE);
        basicStatsWork.setStatsReliable(this.statsReliable);
    }

    public StatsWork(Table table, HiveConf hconf) {
        this.table = table;
        this.currentDatabase = SessionState.get().getCurrentDatabase();
        this.statsReliable = hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE);
    }

    public String toString() {
        return String.format("StatWork; fetch: %s", this.getfWork());
    }

    FetchWork getfWork() {
        return this.colStats == null ? null : this.colStats.getFWork();
    }

    @Explain(displayName="Column Stats Desc")
    public ColumnStatsDesc getColStats() {
        return this.colStats;
    }

    public void setColStats(ColumnStatsDesc colStats) {
        this.colStats = colStats;
    }

    @Deprecated
    public static int getLimit() {
        return -1;
    }

    @Explain(displayName="Basic Stats Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public BasicStatsWork getBasicStatsWork() {
        return this.basicStatsWork;
    }

    @Explain(displayName="Basic Stats NoJob Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public BasicStatsNoJobWork getBasicStatsNoJobWork() {
        return this.basicStatsNoJobWork;
    }

    public void setSourceTask(Task<?> sourceTask) {
        this.basicStatsWork.setSourceTask(sourceTask);
    }

    public String getCurrentDatabaseName() {
        return this.currentDatabase;
    }

    public boolean hasColStats() {
        return this.colStats != null;
    }

    public Table getTable() {
        return this.table;
    }

    public void collectStatsFromAggregator(IStatsGatherDesc conf) {
        this.basicStatsWork.setAggKey(conf.getStatsAggPrefix());
        this.basicStatsWork.setStatsTmpDir(conf.getTmpStatsDir());
        this.basicStatsWork.setStatsReliable(this.statsReliable);
    }

    public void truncateExisting(boolean truncate) {
        this.truncate = truncate;
    }

    public void setFooterScan() {
        this.basicStatsNoJobWork = new BasicStatsNoJobWork(this.table.getTableSpec());
        this.basicStatsNoJobWork.setStatsReliable(this.getStatsReliable());
        this.footerScan = true;
    }

    public void addInputPartitions(Set<Partition> partitions) {
        this.partitions.addAll(partitions);
    }

    public Set<Partition> getPartitions() {
        return this.partitions;
    }

    public boolean isFooterScan() {
        return this.footerScan;
    }

    public boolean getStatsReliable() {
        return this.statsReliable;
    }

    public String getFullTableName() {
        return this.table.getDbName() + "." + this.table.getTableName();
    }

    public Task getSourceTask() {
        return this.basicStatsWork == null ? null : this.basicStatsWork.getSourceTask();
    }

    public String getAggKey() {
        return this.basicStatsWork.getAggKey();
    }

    public boolean isAggregating() {
        return this.basicStatsWork != null && this.basicStatsWork.getAggKey() != null;
    }
}

