/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDouble;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;

public class CastStringToFloat
extends CastStringToDouble {
    private static final long serialVersionUID = 1L;

    public CastStringToFloat(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
    }

    public CastStringToFloat() {
    }

    @Override
    protected void func(DoubleColumnVector outV, BytesColumnVector inV, int batchIndex) {
        byte[] bytes = inV.vector[batchIndex];
        int start = inV.start[batchIndex];
        int length = inV.length[batchIndex];
        try {
            if (!LazyUtils.isNumberMaybe(bytes, start, length)) {
                outV.noNulls = false;
                outV.isNull[batchIndex] = true;
                outV.vector[batchIndex] = Double.NaN;
                return;
            }
            outV.vector[batchIndex] = Float.parseFloat(new String(bytes, start, length, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            outV.noNulls = false;
            outV.isNull[batchIndex] = true;
            outV.vector[batchIndex] = Double.NaN;
        }
    }
}

