/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.entity.UserInfo;
import org.apache.hugegraph.service.UserInfoService;
import org.apache.hugegraph.util.E;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1.2/setting"})
public class SettingController {
    @Autowired
    private UserInfoService service;

    @GetMapping(value={"config"})
    public UserInfo config(@RequestParam(value="locale", defaultValue="zh_CN") String locale, HttpServletRequest request, HttpServletResponse response) {
        E.checkArgument((locale != null ? 1 : 0) != 0, (String)"The param lang can't be null", (Object[])new Object[0]);
        E.checkArgument((boolean)Constant.LANGUAGES.contains(locale), (String)"The acceptable languages are %s, but got %s", (Object[])new Object[]{Constant.LANGUAGES, locale});
        String username = "anonymous";
        UserInfo userInfo = this.service.getByName(username);
        if (userInfo == null) {
            userInfo = UserInfo.builder().username(username).locale(locale).build();
            this.service.save(userInfo);
        } else {
            userInfo.setLocale(locale);
            this.service.update(userInfo);
        }
        Cookie cookie = new Cookie("user", userInfo.getUsername());
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge((int)TimeUnit.SECONDS.convert(3L, TimeUnit.DAYS));
        response.addCookie(cookie);
        return userInfo;
    }
}

