/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.api.context.RpcServiceContext;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;

@Extension(value="serviceContext", order=-19500)
@AutoActive(providerSide=true)
public class RpcServiceContextFilter
extends Filter {
    @Override
    public boolean needToLoad(FilterInvoker invoker) {
        return RpcInternalContext.isAttachmentEnable();
    }

    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        RpcServiceContext serviceCtx = new RpcServiceContext();
        RpcInternalContext internalCtx = RpcInternalContext.getContext();
        serviceCtx.setServiceName(request.getTargetServiceUniqueName());
        serviceCtx.setMethodName(request.getMethodName());
        serviceCtx.setTraceId((String)internalCtx.getAttachment("_trace_id"));
        serviceCtx.setRpcId((String)internalCtx.getAttachment("_span_id"));
        serviceCtx.setCallerAppName((String)request.getRequestProp("app"));
        serviceCtx.setCallerUrl(internalCtx.getRemoteHostName());
        RpcInvokeContext.getContext().put("rpc.service.ctx", serviceCtx);
        return invoker.invoke(request);
    }
}

