/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.util.E;

@JsonPropertyOrder(value={"id", "skip", "input", "vertices", "edges"})
public class InputStruct
implements Checkable,
Serializable {
    public static final InputStruct EMPTY = new InputStruct((List<VertexMapping>)ImmutableList.of(), (List<EdgeMapping>)ImmutableList.of());
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="skip")
    private boolean skip;
    @JsonProperty(value="input")
    private InputSource input;
    @JsonProperty(value="vertices")
    private List<VertexMapping> vertices;
    @JsonProperty(value="edges")
    private List<EdgeMapping> edges;

    @JsonCreator
    public InputStruct(@JsonProperty(value="vertices") List<VertexMapping> vertices, @JsonProperty(value="edges") List<EdgeMapping> edges) {
        this.vertices = vertices != null ? vertices : new ArrayList();
        this.edges = edges != null ? edges : new ArrayList();
    }

    @Override
    public void check() throws IllegalArgumentException {
        E.checkArgument((!StringUtils.isEmpty((CharSequence)this.id) ? 1 : 0) != 0, (String)"The mapping.id can't be null or empty", (Object[])new Object[0]);
        E.checkArgument((this.input != null ? 1 : 0) != 0, (String)"The mapping.input can't be null", (Object[])new Object[0]);
        this.input.check();
        E.checkArgument((!this.vertices.isEmpty() || !this.edges.isEmpty() ? 1 : 0) != 0, (String)"The mapping.vertices and mapping.edges can't be empty at same time, need specify at least one", (Object[])new Object[0]);
        this.vertices.forEach(VertexMapping::check);
        this.edges.forEach(EdgeMapping::check);
        this.vertices.forEach(vm -> vm.checkFieldsValid(this.input));
        this.edges.forEach(em -> em.checkFieldsValid(this.input));
    }

    public String id() {
        return this.id;
    }

    public void id(String id) {
        this.id = id;
    }

    public boolean skip() {
        return this.skip;
    }

    public InputSource input() {
        return this.input;
    }

    public void input(InputSource input) {
        this.input = input;
    }

    public List<VertexMapping> vertices() {
        return this.vertices;
    }

    public List<EdgeMapping> edges() {
        return this.edges;
    }

    public void add(ElementMapping mapping) {
        if (mapping.type().isVertex()) {
            this.vertices.add((VertexMapping)mapping);
        } else {
            this.edges.add((EdgeMapping)mapping);
        }
    }

    public InputStruct extractVertexStruct() {
        if (this.vertices.isEmpty()) {
            return EMPTY;
        }
        InputStruct struct = new InputStruct(this.vertices, (List<EdgeMapping>)ImmutableList.of());
        struct.id = this.id;
        struct.skip = this.skip;
        struct.input = this.input;
        return struct;
    }

    public InputStruct extractEdgeStruct() {
        if (this.edges.isEmpty()) {
            return EMPTY;
        }
        InputStruct struct = new InputStruct((List<VertexMapping>)ImmutableList.of(), this.edges);
        struct.id = this.id;
        struct.skip = this.skip;
        struct.input = this.input;
        return struct;
    }

    public String toString() {
        return String.format("InputStruct{id=%s, input=%s}", this.id, this.input);
    }
}

