/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AdobeFontMetricParser
extends AbstractParser {
    static final String MET_AVG_CHAR_WIDTH = "AvgCharacterWidth";
    static final String MET_DOC_VERSION = "DocVersion";
    static final String MET_PS_NAME = "PSName";
    static final String MET_FONT_NAME = "FontName";
    static final String MET_FONT_FULL_NAME = "FontFullName";
    static final String MET_FONT_FAMILY_NAME = "FontFamilyName";
    static final String MET_FONT_SUB_FAMILY_NAME = "FontSubFamilyName";
    static final String MET_FONT_VERSION = "FontVersion";
    static final String MET_FONT_WEIGHT = "FontWeight";
    static final String MET_FONT_NOTICE = "FontNotice";
    static final String MET_FONT_UNDERLINE_THICKNESS = "FontUnderlineThickness";
    private static final long serialVersionUID = -4820306522217196835L;
    private static final MediaType AFM_TYPE = MediaType.application((String)"x-font-adobe-metric");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(AFM_TYPE);

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        AFMParser parser = new AFMParser(stream);
        FontMetrics fontMetrics = parser.parse();
        List unModifiableComments = fontMetrics.getComments();
        ArrayList<String> comments = new ArrayList<String>(unModifiableComments);
        this.extractCreationDate(metadata, comments);
        metadata.set("Content-Type", AFM_TYPE.toString());
        metadata.set(TikaCoreProperties.TITLE, fontMetrics.getFullName());
        this.addMetadataByString(metadata, MET_AVG_CHAR_WIDTH, Float.toString(fontMetrics.getAverageCharacterWidth()));
        this.addMetadataByString(metadata, MET_DOC_VERSION, Float.toString(fontMetrics.getAFMVersion()));
        this.addMetadataByString(metadata, MET_FONT_NAME, fontMetrics.getFontName());
        this.addMetadataByString(metadata, MET_FONT_FULL_NAME, fontMetrics.getFullName());
        this.addMetadataByString(metadata, MET_FONT_FAMILY_NAME, fontMetrics.getFamilyName());
        this.addMetadataByString(metadata, MET_FONT_VERSION, fontMetrics.getFontVersion());
        this.addMetadataByString(metadata, MET_FONT_WEIGHT, fontMetrics.getWeight());
        this.addMetadataByString(metadata, MET_FONT_NOTICE, fontMetrics.getNotice());
        this.addMetadataByString(metadata, MET_FONT_UNDERLINE_THICKNESS, Float.toString(fontMetrics.getUnderlineThickness()));
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (comments.size() > 0) {
            xhtml.element("h1", "Comments");
            xhtml.startElement("div", "class", "comments");
            for (String comment : comments) {
                xhtml.element("p", comment);
            }
            xhtml.endElement("div");
        }
        xhtml.endDocument();
    }

    private void addMetadataByString(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadataByProperty(Metadata metadata, Property property, String value) {
        if (value != null) {
            metadata.set(property, value);
        }
    }

    private void extractCreationDate(Metadata metadata, List<String> comments) {
        String date = null;
        for (String value : comments) {
            if (!value.matches(".*Creation\\sDate.*")) continue;
            date = value.substring(value.indexOf(":") + 2);
            comments.remove(value);
            break;
        }
        if (date != null) {
            this.addMetadataByProperty(metadata, TikaCoreProperties.CREATED, date);
        }
    }
}

