/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.getxmldata;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.xml.Dom4JUtil;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataMeta;
import org.apache.hop.pipeline.transforms.xml.getxmldata.IgnoreDtdEntityResolver;
import org.apache.hop.pipeline.transforms.xml.getxmldata.PdOption;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.EntityResolver;

public class LoopNodesImportProgressDialog {
    private static final Class<?> PKG = GetXmlDataMeta.class;
    private Shell shell;
    private String[] xpaths;
    private String filename;
    private String xml;
    private String url;
    private String encoding;
    private ArrayList<String> listpath;
    private int nr;
    private PdOption option;

    public LoopNodesImportProgressDialog(Shell shell, String xmlSource, PdOption option) {
        this.shell = shell;
        this.option = option;
        this.xpaths = null;
        if (option.isXmlSourceIsFile()) {
            this.filename = xmlSource;
            this.xml = null;
            this.url = null;
        } else if (option.isUseUrl()) {
            this.filename = null;
            this.xml = null;
            this.url = xmlSource;
        } else {
            this.filename = null;
            this.xml = xmlSource;
            this.url = null;
        }
        this.encoding = option.getEncoding();
        this.listpath = new ArrayList();
        this.nr = 0;
    }

    public String[] open() {
        IRunnableWithProgress op = monitor -> {
            try {
                this.xpaths = this.doScan(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Exception.ErrorScanningFile", (String[])new String[]{this.filename, e.toString()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), (Exception)e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.ErrorScanningFile.Message", (String[])new String[0]), (Exception)e);
        }
        return this.xpaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] doScan(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ScanningFile", (String[])new String[]{this.filename}), 1);
        SAXReader reader = Dom4JUtil.getSAXReader();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return null;
        }
        if (this.option.isValidating()) {
            reader.setValidation(true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        } else {
            reader.setEntityResolver((EntityResolver)new IgnoreDtdEntityResolver());
        }
        monitor.worked(1);
        monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingDocument", (String[])new String[0]), 1);
        if (monitor.isCanceled()) {
            return null;
        }
        InputStream is = null;
        try {
            Document document = null;
            if (!Utils.isEmpty((CharSequence)this.filename)) {
                is = HopVfs.getInputStream((String)this.filename);
                document = reader.read(is, this.encoding);
            } else {
                document = !Utils.isEmpty((CharSequence)this.xml) ? reader.read((Reader)new StringReader(this.xml)) : reader.read(new URL(this.url));
            }
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.DocumentOpened", (String[])new String[0]), 1);
            monitor.worked(1);
            monitor.beginTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.ReadingNode", (String[])new String[0]), 1);
            if (monitor.isCanceled()) {
                String[] stringArray = null;
                return stringArray;
            }
            List nodes = document.selectNodes(document.getRootElement().getName());
            monitor.worked(1);
            monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[0]));
            if (monitor.isCanceled()) {
                String[] stringArray = null;
                return stringArray;
            }
            for (Node node : nodes) {
                if (monitor.isCanceled()) {
                    String[] stringArray = null;
                    return stringArray;
                }
                if (this.listpath.contains(node.getPath())) continue;
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.AddingNode", (String[])new String[]{node.getPath()}));
                this.listpath.add(node.getPath());
                this.addLoopXPath(node, monitor);
            }
            monitor.worked(1);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        String[] listXpath = this.listpath.toArray(new String[this.listpath.size()]);
        monitor.setTaskName(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.NodesReturned", (String[])new String[0]));
        monitor.done();
        return listXpath;
    }

    private void addLoopXPath(Node node, IProgressMonitor monitor) {
        Element ce = (Element)node;
        monitor.worked(1);
        for (int j = 0; j < ce.nodeCount(); ++j) {
            if (monitor.isCanceled()) {
                return;
            }
            Node cnode = ce.node(j);
            if (Utils.isEmpty((CharSequence)cnode.getName())) continue;
            Element cce = (Element)cnode;
            if (!this.listpath.contains(cnode.getPath())) {
                ++this.nr;
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.FetchNodes", (String[])new String[]{String.valueOf(this.nr)}));
                monitor.subTask(BaseMessages.getString(PKG, (String)"GetXMLDateLoopNodesImportProgressDialog.Task.AddingNode", (String[])new String[]{cnode.getPath()}));
                this.listpath.add(cnode.getPath());
            }
            if (cce.nodeCount() <= 1) continue;
            this.addLoopXPath(cnode, monitor);
        }
    }

    public PdOption getOption() {
        return this.option;
    }
}

