/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterAllStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterEachStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterFirstStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterPaneStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterProcessingTimeStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterSynchronizedProcessingTimeStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterWatermarkStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.DefaultTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.NeverStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.RepeatedlyStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ReshuffleTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class TriggerStateMachines {
    private TriggerStateMachines() {
    }

    public static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine stateMachineForTrigger(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger trigger) {
        switch (trigger.getTriggerCase()) {
            case AFTER_ALL: {
                return AfterAllStateMachine.of(TriggerStateMachines.stateMachinesForTriggers(trigger.getAfterAll().getSubtriggersList()));
            }
            case AFTER_ANY: {
                return AfterFirstStateMachine.of(TriggerStateMachines.stateMachinesForTriggers(trigger.getAfterAny().getSubtriggersList()));
            }
            case AFTER_END_OF_WINDOW: {
                return TriggerStateMachines.stateMachineForAfterEndOfWindow(trigger.getAfterEndOfWindow());
            }
            case ELEMENT_COUNT: {
                return AfterPaneStateMachine.elementCountAtLeast(trigger.getElementCount().getElementCount());
            }
            case AFTER_SYNCHRONIZED_PROCESSING_TIME: {
                return AfterSynchronizedProcessingTimeStateMachine.ofFirstElement();
            }
            case DEFAULT: {
                return DefaultTriggerStateMachine.of();
            }
            case NEVER: {
                return NeverStateMachine.ever();
            }
            case ALWAYS: {
                return ReshuffleTriggerStateMachine.create();
            }
            case OR_FINALLY: {
                return TriggerStateMachines.stateMachineForTrigger(trigger.getOrFinally().getMain()).orFinally(TriggerStateMachines.stateMachineForTrigger(trigger.getOrFinally().getFinally()));
            }
            case REPEAT: {
                return RepeatedlyStateMachine.forever(TriggerStateMachines.stateMachineForTrigger(trigger.getRepeat().getSubtrigger()));
            }
            case AFTER_EACH: {
                return AfterEachStateMachine.inOrder(TriggerStateMachines.stateMachinesForTriggers(trigger.getAfterEach().getSubtriggersList()));
            }
            case AFTER_PROCESSING_TIME: {
                return TriggerStateMachines.stateMachineForAfterProcessingTime(trigger.getAfterProcessingTime());
            }
            case TRIGGER_NOT_SET: {
                throw new IllegalArgumentException(String.format("Required field 'trigger' not set on %s", trigger));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown trigger type %s", trigger));
    }

    private static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine stateMachineForAfterEndOfWindow(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger.AfterEndOfWindow trigger) {
        if (!trigger.hasEarlyFirings() && !trigger.hasLateFirings()) {
            return AfterWatermarkStateMachine.pastEndOfWindow();
        }
        AfterWatermarkStateMachine.AfterWatermarkEarlyAndLate machine = AfterWatermarkStateMachine.pastEndOfWindow().withEarlyFirings(TriggerStateMachines.stateMachineForTrigger(trigger.getEarlyFirings()));
        if (trigger.hasLateFirings()) {
            machine = machine.withLateFirings(TriggerStateMachines.stateMachineForTrigger(trigger.getLateFirings()));
        }
        return machine;
    }

    private static @UnknownKeyFor @NonNull @Initialized TriggerStateMachine stateMachineForAfterProcessingTime(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger.AfterProcessingTime trigger) {
        AfterDelayFromFirstElementStateMachine stateMachine = AfterProcessingTimeStateMachine.pastFirstElementInPane();
        block5: for (RunnerApi.TimestampTransform transform : trigger.getTimestampTransformsList()) {
            switch (transform.getTimestampTransformCase()) {
                case ALIGN_TO: {
                    stateMachine = stateMachine.alignedTo(Duration.millis((long)transform.getAlignTo().getPeriod()), new Instant(transform.getAlignTo().getOffset()));
                    continue block5;
                }
                case DELAY: {
                    stateMachine = stateMachine.plusDelayOf(Duration.millis((long)transform.getDelay().getDelayMillis()));
                    continue block5;
                }
                case TIMESTAMPTRANSFORM_NOT_SET: {
                    throw new IllegalArgumentException(String.format("Required field 'timestamp_transform' not set in %s", transform));
                }
            }
            throw new IllegalArgumentException(String.format("Unknown timestamp transform case: %s", transform.getTimestampTransformCase()));
        }
        return stateMachine;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TriggerStateMachine> stateMachinesForTriggers(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Trigger> triggers) {
        ArrayList<TriggerStateMachine> stateMachines = new ArrayList<TriggerStateMachine>(triggers.size());
        for (RunnerApi.Trigger trigger : triggers) {
            stateMachines.add(TriggerStateMachines.stateMachineForTrigger(trigger));
        }
        return stateMachines;
    }
}

