/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilesrowcount;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCount;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="GetFilesRowsCount", image="getfilesrowcount.svg", name="i18n::GetFilesRowsCount.Name", description="i18n::GetFilesRowsCount.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::GetFilesRowsCountMeta.keyword"}, documentationUrl="/pipeline/transforms/getfilesrowcount.html")
public class GetFilesRowsCountMeta
extends BaseTransformMeta<GetFilesRowsCount, GetFilesRowsCountData> {
    private static final Class<?> PKG = GetFilesRowsCountMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String YES = "Y";
    @HopMetadataProperty(key="file")
    private List<GCFile> files = new ArrayList<GCFile>();
    @HopMetadataProperty(key="files_count")
    private boolean includeFilesCount;
    @HopMetadataProperty(key="files_count_fieldname")
    private String filesCountFieldName;
    @HopMetadataProperty(key="rows_count_fieldname")
    private String rowsCountFieldName;
    @HopMetadataProperty(key="rowseparator_format", storeWithCode=true)
    private SeparatorFormat rowSeparatorFormat;
    @HopMetadataProperty(key="row_separator")
    private String rowSeparator;
    @HopMetadataProperty(key="filefield")
    private boolean fileFromField;
    @HopMetadataProperty(key="isaddresult")
    private boolean addResultFilename;
    @HopMetadataProperty(key="filename_Field")
    private String outputFilenameField;
    @HopMetadataProperty(key="smartCount")
    private boolean smartCount;

    public GetFilesRowsCountMeta() {
    }

    public GetFilesRowsCountMeta(GetFilesRowsCountMeta m) {
        this();
        this.includeFilesCount = m.includeFilesCount;
        this.filesCountFieldName = m.filesCountFieldName;
        this.rowsCountFieldName = m.rowsCountFieldName;
        this.rowSeparatorFormat = m.rowSeparatorFormat;
        this.rowSeparator = m.rowSeparator;
        this.fileFromField = m.fileFromField;
        this.addResultFilename = m.addResultFilename;
        this.outputFilenameField = m.outputFilenameField;
        this.smartCount = m.smartCount;
        m.files.forEach(f -> this.files.add(new GCFile((GCFile)f)));
    }

    public GetFilesRowsCountMeta clone() {
        return new GetFilesRowsCountMeta(this);
    }

    public void setDefault() {
        this.smartCount = false;
        this.outputFilenameField = "";
        this.fileFromField = false;
        this.addResultFilename = true;
        this.includeFilesCount = false;
        this.filesCountFieldName = "";
        this.rowsCountFieldName = "rowsCount";
        this.rowSeparatorFormat = SeparatorFormat.CR;
        this.rowSeparator = "";
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowsCountFieldName));
        v.setLength(10, 0);
        v.setOrigin(name);
        r.addValueMeta((IValueMeta)v);
        if (this.includeFilesCount) {
            v = new ValueMetaInteger(variables.resolve(this.filesCountFieldName));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public String[] getFilesNames() {
        return (String[])this.files.stream().map(GCFile::getName).toArray(String[]::new);
    }

    public String[] getFilesMasks() {
        return (String[])this.files.stream().map(GCFile::getMask).toArray(String[]::new);
    }

    public String[] getFilesExcludeMasks() {
        return (String[])this.files.stream().map(GCFile::getExcludeMask).toArray(String[]::new);
    }

    public String[] getFilesRequired() {
        return (String[])this.files.stream().map(f -> f.isRequired() ? YES : "N").toArray(String[]::new);
    }

    public boolean[] getFilesSubFolderIncluded() {
        boolean[] b = new boolean[this.files.size()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.files.get(i).isIncludeSubFolder();
        }
        return b;
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.getFilesNames(), (String[])this.getFilesMasks(), (String[])this.getFilesExcludeMasks(), (String[])this.getFilesRequired(), (boolean[])this.getFilesSubFolderIncluded());
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileInputList = this.getFiles(variables);
        if (fileInputList == null || fileInputList.getFiles().isEmpty()) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.rowSeparatorFormat.equals("CUSTOM") && this.rowSeparator == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoSeparator", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.SeparatorOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileFromField) {
                for (GCFile file : this.files) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(file.getName()));
                    file.setName(iResourceNaming.nameResource(fileObject, variables, StringUtils.isEmpty((String)file.getMask())));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public List<GCFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<GCFile> files) {
        this.files = files;
    }

    public boolean isIncludeFilesCount() {
        return this.includeFilesCount;
    }

    public void setIncludeFilesCount(boolean includeFilesCount) {
        this.includeFilesCount = includeFilesCount;
    }

    public String getFilesCountFieldName() {
        return this.filesCountFieldName;
    }

    public void setFilesCountFieldName(String filesCountFieldName) {
        this.filesCountFieldName = filesCountFieldName;
    }

    public String getRowsCountFieldName() {
        return this.rowsCountFieldName;
    }

    public void setRowsCountFieldName(String rowsCountFieldName) {
        this.rowsCountFieldName = rowsCountFieldName;
    }

    public SeparatorFormat getRowSeparatorFormat() {
        return this.rowSeparatorFormat;
    }

    public void setRowSeparatorFormat(SeparatorFormat rowSeparatorFormat) {
        this.rowSeparatorFormat = rowSeparatorFormat;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public boolean isFileFromField() {
        return this.fileFromField;
    }

    public void setFileFromField(boolean fileFromField) {
        this.fileFromField = fileFromField;
    }

    public boolean isAddResultFilename() {
        return this.addResultFilename;
    }

    public void setAddResultFilename(boolean addResultFilename) {
        this.addResultFilename = addResultFilename;
    }

    public String getOutputFilenameField() {
        return this.outputFilenameField;
    }

    public void setOutputFilenameField(String outputFilenameField) {
        this.outputFilenameField = outputFilenameField;
    }

    public boolean isSmartCount() {
        return this.smartCount;
    }

    public void setSmartCount(boolean smartCount) {
        this.smartCount = smartCount;
    }

    public static enum SeparatorFormat implements IEnumHasCodeAndDescription
    {
        CR("CARRIAGERETURN", BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CR.Label", (String[])new String[0])),
        LF("LINEFEED", BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.LF.Label", (String[])new String[0])),
        CRLF("CRLF", BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CRLF.Label", (String[])new String[0])),
        TAB("TAB", BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.TAB.Label", (String[])new String[0])),
        CUSTOM("CUSTOM", BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CUSTOM.Label", (String[])new String[0]));

        private final String code;
        private final String description;

        private SeparatorFormat(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(SeparatorFormat.class);
        }

        public static SeparatorFormat lookupDescription(String description) {
            return (SeparatorFormat)IEnumHasCodeAndDescription.lookupDescription(SeparatorFormat.class, (String)description, (IEnumHasCodeAndDescription)CR);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class GCFile {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="filemask")
        private String mask;
        @HopMetadataProperty(key="exclude_filemask")
        private String excludeMask;
        @HopMetadataProperty(key="file_required")
        private boolean required;
        @HopMetadataProperty(key="include_subfolders")
        private boolean includeSubFolder;

        public GCFile() {
        }

        public GCFile(GCFile f) {
            this();
            this.name = f.name;
            this.mask = f.mask;
            this.excludeMask = f.excludeMask;
            this.required = f.required;
            this.includeSubFolder = f.includeSubFolder;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMask() {
            return this.mask;
        }

        public void setMask(String mask) {
            this.mask = mask;
        }

        public String getExcludeMask() {
            return this.excludeMask;
        }

        public void setExcludeMask(String excludeMask) {
            this.excludeMask = excludeMask;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isIncludeSubFolder() {
            return this.includeSubFolder;
        }

        public void setIncludeSubFolder(boolean includeSubFolder) {
            this.includeSubFolder = includeSubFolder;
        }
    }
}

